<?php

if ( ! function_exists( 'stal_core_add_font_awesome_to_collection' ) ) {
	function stal_core_add_font_awesome_to_collection( $icons ) {
		$icons[] = 'StalCoreFontAwesomePack';
		return $icons;
	}
	
	add_filter( 'qode_framework_filter_add_icon', 'stal_core_add_font_awesome_to_collection' );
}

if ( class_exists( 'QodeFrameworkIconPack' ) ) {
	class StalCoreFontAwesomePack extends QodeFrameworkIconPack {
		
		public function __construct() {
			parent::__construct();
		}
		
		public function add_icon_pack() {
			$this->set_base( 'font-awesome' );
			$this->set_name( 'Font Awesome' );
			$this->set_icons( $this->iconsArray() );
			$this->set_specific_icons( $this->specific_icons() );
		}
		
		public function get_style_url() {
			return STAL_CORE_INC_URL_PATH . '/icons/' . $this->get_base() . '/assets/css/all.min.css';
		}
		
		private function iconsArray() {
			return array_flip( array(
				''                                    => '',
				'500px'                               => 'fab fa-500px',
				'Accessible Icon'                     => 'fab fa-accessible-icon',
				'Accusoft'                            => 'fab fa-accusoft',
				'Address Book'                        => 'fa fa-address-book',
				'Address Card'                        => 'fa fa-address-card',
				'Adjust'                              => 'fa fa-adjust',
				'App.net'                             => 'fab fa-adn',
				'Adversal'                            => 'fab fa-adversal',
				'Affiliatetheme'                      => 'fab fa-affiliatetheme',
				'Algolia'                             => 'fab fa-algolia',
				'Align Center'                        => 'fa fa-align-center',
				'Align Justify'                       => 'fa fa-align-justify',
				'Align Left'                          => 'fa fa-align-left',
				'Align Right'                         => 'fa fa-align-right',
				'Amazon'                              => 'fab fa-amazon',
				'Amazon Pay'                          => 'fab fa-amazon-pay',
				'Ambulance'                           => 'fa fa-ambulance',
				'American Sign Language Interpreting' => 'fa fa-american-sign-language-interpreting',
				'Amilia'                              => 'fab fa-amilia',
				'Anchor'                              => 'fa fa-anchor',
				'Android'                             => 'fab fa-android',
				'AngelList'                           => 'fab fa-angellist',
				'Angle Double Down'                   => 'fa fa-angle-double-down',
				'Angle Double Left'                   => 'fa fa-angle-double-left',
				'Angle Double Right'                  => 'fa fa-angle-double-right',
				'Angle Double Up'                     => 'fa fa-angle-double-up',
				'Angle Down'                          => 'fa fa-angle-down',
				'Angle Left'                          => 'fa fa-angle-left',
				'Angle Right'                         => 'fa fa-angle-right',
				'Angle Up'                            => 'fa fa-angle-up',
				'Angry Creative'                      => 'fab fa-angrycreative',
				'Angular'                             => 'fab fa-angular',
				'App Store'                           => 'fab fa-app-store',
				'IOS App Store'                       => 'fab fa-app-store-ios',
				'Apper Systems AB'                    => 'fab fa-apper',
				'Apple'                               => 'fab fa-apple',
				'Apple Pay'                           => 'fab fa-apple-pay',
				'Archive'                             => 'fa fa-archive',
				'Alternate Arrow Circle Down'         => 'fa fa-arrow-alt-circle-down',
				'Alternate Arrow Circle Left'         => 'fa fa-arrow-alt-circle-left',
				'Alternate Arrow Circle Right'        => 'fa fa-arrow-alt-circle-right',
				'Alternate Arrow Circle Up'           => 'fa fa-arrow-alt-circle-up',
				'Arrow Circle Down'                   => 'fa fa-arrow-circle-down',
				'Arrow Circle Left'                   => 'fa fa-arrow-circle-left',
				'Arrow Circle Right'                  => 'fa fa-arrow-circle-right',
				'Arrow Circle Up'                     => 'fa fa-arrow-circle-up',
				'Arrow Down'                          => 'fa fa-arrow-down',
				'Arrow Left'                          => 'fa fa-arrow-left',
				'Arrow Right'                         => 'fa fa-arrow-right',
				'Arrow Up'                            => 'fa fa-arrow-up',
				'Alternate Arrows'                    => 'fa fa-arrows-alt',
				'Alternate Arrows Horizontal'         => 'fa fa-arrows-alt-h',
				'Alternate Arrows Vertical'           => 'fa fa-arrows-alt-v',
				'Assistive Listening Systems'         => 'fa fa-assistive-listening-systems',
				'Asterisk'                            => 'fa fa-asterisk',
				'Asymmetrik, Ltd.'                    => 'fab fa-asymmetrik',
				'At'                                  => 'fa fa-at',
				'Audible'                             => 'fab fa-audible',
				'Audio Description'                   => 'fa fa-audio-description',
				'Autoprefixer'                        => 'fab fa-autoprefixer',
				'Avianex'                             => 'fab fa-avianex',
				'Aviato'                              => 'fab fa-aviato',
				'Amazon Web Services (AWS)'           => 'fab fa-aws',
				'Backward'                            => 'fa fa-backward',
				'Balance Scale'                       => 'fa fa-balance-scale',
				'Ban'                                 => 'fa fa-ban',
				'Band Aid'                            => 'fa fa-band-aid',
				'Bandcamp'                            => 'fab fa-bandcamp',
				'Barcode'                             => 'fa fa-barcode',
				'Bars'                                => 'fa fa-bars',
				'Baseball Ball'                       => 'fa fa-baseball-ball',
				'Basketball Ball'                     => 'fa fa-basketball-ball',
				'Bath'                                => 'fa fa-bath',
				'Battery Empty'                       => 'fa fa-battery-empty',
				'Battery Full'                        => 'fa fa-battery-full',
				'Battery 1/2 Full'                    => 'fa fa-battery-half',
				'Battery 1/4 Full'                    => 'fa fa-battery-quarter',
				'Battery 3/4 Full'                    => 'fa fa-battery-three-quarters',
				'Bed'                                 => 'fa fa-bed',
				'Beer'                                => 'fa fa-beer',
				'Behance'                             => 'fab fa-behance',
				'Behance Square'                      => 'fab fa-behance-square',
				'Bell'                                => 'fa fa-bell',
				'Bell Slash'                          => 'fa fa-bell-slash',
				'Bicycle'                             => 'fa fa-bicycle',
				'BIMobject'                           => 'fab fa-bimobject',
				'Binoculars'                          => 'fa fa-binoculars',
				'Birthday Cake'                       => 'fa fa-birthday-cake',
				'Bitbucket'                           => 'fab fa-bitbucket',
				'Bitcoin'                             => 'fab fa-bitcoin',
				'Bity'                                => 'fab fa-bity',
				'Font Awesome Black Tie'              => 'fab fa-black-tie',
				'BlackBerry'                          => 'fab fa-blackberry',
				'Blind'                               => 'fa fa-blind',
				'Blogger'                             => 'fab fa-blogger',
				'Blogger B'                           => 'fab fa-blogger-b',
				'Bluetooth'                           => 'fab fa-bluetooth-b',
				'Bold'                                => 'fa fa-bold',
				'Lightning Bolt'                      => 'fa fa-bolt',
				'Bomb'                                => 'fa fa-bomb',
				'Book'                                => 'fa fa-book',
				'Bookmark'                            => 'fa fa-bookmark',
				'Bowling Ball'                        => 'fa fa-bowling-ball',
				'Box'                                 => 'fa fa-box',
				'Boxes'                               => 'fa fa-boxes',
				'Braille'                             => 'fa fa-braille',
				'Briefcase'                           => 'fa fa-briefcase',
				'BTC'                                 => 'fab fa-btc',
				'Bug'                                 => 'fa fa-bug',
				'Building'                            => 'fa fa-building',
				'Bullhorn'                            => 'fa fa-bullhorn',
				'Bullseye'                            => 'fa fa-bullseye',
				'BÃ¼romÃ¶bel Experte GmbH & Co. KG.'  => 'fab fa-buromobelexperte',
				'Bus'                                 => 'fa fa-bus',
				'BuySellAds'                          => 'fab fa-buysellads',
				'Calculator'                          => 'fa fa-calculator',
				'Calendar'                            => 'fa fa-calendar',
				'Alternate Calendar'                  => 'fa fa-calendar-alt',
				'Calendar Check'                      => 'fa fa-calendar-check',
				'Calendar Minus'                      => 'fa fa-calendar-minus',
				'Calendar Plus'                       => 'fa fa-calendar-plus',
				'Calendar Times'                      => 'fa fa-calendar-times',
				'Camera'                              => 'fa fa-camera',
				'Retro Camera'                        => 'fa fa-camera-retro',
				'Car'                                 => 'fa fa-car',
				'Caret Down'                          => 'fa fa-caret-down',
				'Caret Left'                          => 'fa fa-caret-left',
				'Caret Right'                         => 'fa fa-caret-right',
				'Caret Square Down'                   => 'fa fa-caret-square-down',
				'Caret Square Left'                   => 'fa fa-caret-square-left',
				'Caret Square Right'                  => 'fa fa-caret-square-right',
				'Caret Square Up'                     => 'fa fa-caret-square-up',
				'Caret Up'                            => 'fa fa-caret-up',
				'Shopping Cart Arrow Down'            => 'fa fa-cart-arrow-down',
				'Add To Shopping Cart'                => 'fa fa-cart-plus',
				'Amazon Pay Credit Card'              => 'fab fa-cc-amazon-pay',
				'American Express Credit Card'        => 'fab fa-cc-amex',
				'Apple Pay Credit Card'               => 'fab fa-cc-apple-pay',
				'Diners Club Credit Card'             => 'fab fa-cc-diners-club',
				'Discover Credit Card'                => 'fab fa-cc-discover',
				'JCB Credit Card'                     => 'fab fa-cc-jcb',
				'MasterCard Credit Card'              => 'fab fa-cc-mastercard',
				'Paypal Credit Card'                  => 'fab fa-cc-paypal',
				'Stripe Credit Card'                  => 'fab fa-cc-stripe',
				'Visa Credit Card'                    => 'fab fa-cc-visa',
				'Centercode'                          => 'fab fa-centercode',
				'Certificate'                         => 'fa fa-certificate',
				'Area Chart'                          => 'fa fa-chart-area',
				'Bar Chart'                           => 'fa fa-chart-bar',
				'Line Chart'                          => 'fa fa-chart-line',
				'Pie Chart'                           => 'fa fa-chart-pie',
				'Check'                               => 'fa fa-check',
				'Check Circle'                        => 'fa fa-check-circle',
				'Check Square'                        => 'fa fa-check-square',
				'Chess'                               => 'fa fa-chess',
				'Chess Bishop'                        => 'fa fa-chess-bishop',
				'Chess Board'                         => 'fa fa-chess-board',
				'Chess King'                          => 'fa fa-chess-king',
				'Chess Knight'                        => 'fa fa-chess-knight',
				'Chess Pawn'                          => 'fa fa-chess-pawn',
				'Chess Queen'                         => 'fa fa-chess-queen',
				'Chess Rook'                          => 'fa fa-chess-rook',
				'Chevron Circle Down'                 => 'fa fa-chevron-circle-down',
				'Chevron Circle Left'                 => 'fa fa-chevron-circle-left',
				'Chevron Circle Right'                => 'fa fa-chevron-circle-right',
				'Chevron Circle Up'                   => 'fa fa-chevron-circle-up',
				'Chevron Down'                        => 'fa fa-chevron-down',
				'Chevron Left'                        => 'fa fa-chevron-left',
				'Chevron Right'                       => 'fa fa-chevron-right',
				'Chevron Up'                          => 'fa fa-chevron-up',
				'Child'                               => 'fa fa-child',
				'Chrome'                              => 'fab fa-chrome',
				'Circle'                              => 'fa fa-circle',
				'Circle Notched'                      => 'fa fa-circle-notch',
				'Clipboard'                           => 'fa fa-clipboard',
				'Clipboard Check'                     => 'fa fa-clipboard-check',
				'Clipboard List'                      => 'fa fa-clipboard-list',
				'Clock'                               => 'fa fa-clock',
				'Clone'                               => 'fa fa-clone',
				'Closed Captioning'                   => 'fa fa-closed-captioning',
				'Cloud'                               => 'fa fa-cloud',
				'Cloud Download Alternate'            => 'fa fa-cloud-download-alt',
				'Cloud Upload Alternate'              => 'fa fa-cloud-upload-alt',
				'Cloudscale.ch'                       => 'fab fa-cloudscale',
				'Cloudsmith'                          => 'fab fa-cloudsmith',
				'Cloudversify'                        => 'fab fa-cloudversify',
				'Code'                                => 'fa fa-code',
				'Code Branch'                         => 'fa fa-code-branch',
				'Codepen'                             => 'fab fa-codepen',
				'Codie Pie'                           => 'fab fa-codiepie',
				'Coffee'                              => 'fa fa-coffee',
				'Cog'                                 => 'fa fa-cog',
				'Cogs'                                => 'fa fa-cogs',
				'Columns'                             => 'fa fa-columns',
				'Comment'                             => 'fa fa-comment',
				'Alternate Comment'                   => 'fa fa-comment-alt',
				'Comments'                            => 'fa fa-comments',
				'Compass'                             => 'fa fa-compass',
				'Compress'                            => 'fa fa-compress',
				'Connect Develop'                     => 'fab fa-connectdevelop',
				'Contao'                              => 'fab fa-contao',
				'Copy'                                => 'fa fa-copy',
				'Copyright'                           => 'fa fa-copyright',
				'CPanel'                              => 'fab fa-cpanel',
				'Creative Commons'                    => 'fab fa-creative-commons',
				'Credit Card'                         => 'fa fa-credit-card',
				'Crop'                                => 'fa fa-crop',
				'Crosshairs'                          => 'fa fa-crosshairs',
				'CSS 3 Logo'                          => 'fab fa-css3',
				'Alternate CSS3 Logo'                 => 'fab fa-css3-alt',
				'Cube'                                => 'fa fa-cube',
				'Cubes'                               => 'fa fa-cubes',
				'Cut'                                 => 'fa fa-cut',
				'Cuttlefish'                          => 'fab fa-cuttlefish',
				'Dungeons & Dragons'                  => 'fab fa-d-and-d',
				'DashCube'                            => 'fab fa-dashcube',
				'Database'                            => 'fa fa-database',
				'Deaf'                                => 'fa fa-deaf',
				'Delicious Logo'                      => 'fab fa-delicious',
				'Deploy.dog'                          => 'fab fa-deploydog',
				'Deskpro'                             => 'fab fa-deskpro',
				'Desktop'                             => 'fa fa-desktop',
				'DeviantART'                          => 'fab fa-deviantart',
				'Digg Logo'                           => 'fab fa-digg',
				'Digital Ocean'                       => 'fab fa-digital-ocean',
				'Discord'                             => 'fab fa-discord',
				'Discourse'                           => 'fab fa-discourse',
				'DNA'                                 => 'fa fa-dna',
				'DocHub'                              => 'fab fa-dochub',
				'Docker'                              => 'fab fa-docker',
				'Dollar Sign'                         => 'fa fa-dollar-sign',
				'Dolly'                               => 'fa fa-dolly',
				'Dolly Flatbed'                       => 'fa fa-dolly-flatbed',
				'Dot Circle'                          => 'fa fa-dot-circle',
				'Download'                            => 'fa fa-download',
				'Draft2digital'                       => 'fab fa-draft2digital',
				'Dribbble'                            => 'fab fa-dribbble',
				'Dribbble Square'                     => 'fab fa-dribbble-square',
				'Dropbox'                             => 'fab fa-dropbox',
				'Drupal Logo'                         => 'fab fa-drupal',
				'Dyalog'                              => 'fab fa-dyalog',
				'Earlybirds'                          => 'fab fa-earlybirds',
				'Edge Browser'                        => 'fab fa-edge',
				'Edit'                                => 'fa fa-edit',
				'Eject'                               => 'fa fa-eject',
				'Elementor'                           => 'fab fa-elementor',
				'Horizontal Ellipsis'                 => 'fa fa-ellipsis-h',
				'Vertical Ellipsis'                   => 'fa fa-ellipsis-v',
				'Ember'                               => 'fab fa-ember',
				'Galactic Empire'                     => 'fab fa-empire',
				'Envelope'                            => 'fa fa-envelope',
				'Envelope Open'                       => 'fa fa-envelope-open',
				'Envelope Square'                     => 'fa fa-envelope-square',
				'Envira Gallery'                      => 'fab fa-envira',
				'Eraser'                              => 'fa fa-eraser',
				'Erlang'                              => 'fab fa-erlang',
				'Ethereum'                            => 'fab fa-ethereum',
				'Etsy'                                => 'fab fa-etsy',
				'Euro Sign'                           => 'fa fa-euro-sign',
				'Alternate Exchange'                  => 'fa fa-exchange-alt',
				'Exclamation'                         => 'fa fa-exclamation',
				'Exclamation Circle'                  => 'fa fa-exclamation-circle',
				'Exclamation Triangle'                => 'fa fa-exclamation-triangle',
				'Expand'                              => 'fa fa-expand',
				'Alternate Expand Arrows'             => 'fa fa-expand-arrows-alt',
				'ExpeditedSSL'                        => 'fab fa-expeditedssl',
				'Alternate External Link'             => 'fa fa-external-link-alt',
				'Alternate External Link Square'      => 'fa fa-external-link-square-alt',
				'Eye'                                 => 'fa fa-eye',
				'Eye Dropper'                         => 'fa fa-eye-dropper',
				'Eye Slash'                           => 'fa fa-eye-slash',
				'Facebook'                            => 'fab fa-facebook',
				'Facebook F'                          => 'fab fa-facebook-f',
				'Facebook Messenger'                  => 'fab fa-facebook-messenger',
				'Facebook Square'                     => 'fab fa-facebook-square',
				'Fast Backward'                       => 'fa fa-fast-backward',
				'Fast Forward'                        => 'fa fa-fast-forward',
				'Fax'                                 => 'fa fa-fax',
				'Female'                              => 'fa fa-female',
				'Fighter Jet'                         => 'fa fa-fighter-jet',
				'File'                                => 'fa fa-file',
				'Alternate File'                      => 'fa fa-file-alt',
				'Archive File'                        => 'fa fa-file-archive',
				'Audio File'                          => 'fa fa-file-audio',
				'Code File'                           => 'fa fa-file-code',
				'Excel File'                          => 'fa fa-file-excel',
				'Image File'                          => 'fa fa-file-image',
				'PDF File'                            => 'fa fa-file-pdf',
				'Powerpoint File'                     => 'fa fa-file-powerpoint',
				'Video File'                          => 'fa fa-file-video',
				'Word File'                           => 'fa fa-file-word',
				'Film'                                => 'fa fa-film',
				'Filter'                              => 'fa fa-filter',
				'Fire'                                => 'fa fa-fire',
				'Fire Extinguisher'                   => 'fa fa-fire-extinguisher',
				'Firefox'                             => 'fab fa-firefox',
				'First Aid'                           => 'fa fa-first-aid',
				'First Order'                         => 'fab fa-first-order',
				'Firstdraft'                          => 'fab fa-firstdraft',
				'Flag'                                => 'fa fa-flag',
				'Flag Checkered'                      => 'fa fa-flag-checkered',
				'Flask'                               => 'fa fa-flask',
				'Flickr'                              => 'fab fa-flickr',
				'Flipboard'                           => 'fab fa-flipboard',
				'Fly'                                 => 'fab fa-fly',
				'Folder'                              => 'fa fa-folder',
				'Folder Open'                         => 'fa fa-folder-open',
				'Font'                                => 'fa fa-font',
				'Font Awesome'                        => 'fab fa-font-awesome',
				'Alternate Font Awesome'              => 'fab fa-font-awesome-alt',
				'Font Awesome Flag'                   => 'fab fa-font-awesome-flag',
				'Fonticons'                           => 'fab fa-fonticons',
				'Fonticons Fi'                        => 'fab fa-fonticons-fi',
				'Football Ball'                       => 'fa fa-football-ball',
				'Fort Awesome'                        => 'fab fa-fort-awesome',
				'Alternate Fort Awesome'              => 'fab fa-fort-awesome-alt',
				'Forumbee'                            => 'fab fa-forumbee',
				'Forward'                             => 'fa fa-forward',
				'Foursquare'                          => 'fab fa-foursquare',
				'Free Code Camp'                      => 'fab fa-free-code-camp',
				'FreeBSD'                             => 'fab fa-freebsd',
				'Frown'                               => 'fa fa-frown',
				'Futbol'                              => 'fa fa-futbol',
				'Gamepad'                             => 'fa fa-gamepad',
				'Gavel'                               => 'fa fa-gavel',
				'Gem'                                 => 'fa fa-gem',
				'Genderless'                          => 'fa fa-genderless',
				'Get Pocket'                          => 'fab fa-get-pocket',
				'GG Currency'                         => 'fab fa-gg',
				'GG Currency Circle'                  => 'fab fa-gg-circle',
				'Gift'                                => 'fa fa-gift',
				'Git'                                 => 'fab fa-git',
				'Git Square'                          => 'fab fa-git-square',
				'GitHub'                              => 'fab fa-github',
				'Alternate GitHub'                    => 'fab fa-github-alt',
				'GitHub Square'                       => 'fab fa-github-square',
				'GitKraken'                           => 'fab fa-gitkraken',
				'GitLab'                              => 'fab fa-gitlab',
				'Gitter'                              => 'fab fa-gitter',
				'Martini Glass'                       => 'fa fa-glass-martini',
				'Glide'                               => 'fab fa-glide',
				'Glide G'                             => 'fab fa-glide-g',
				'Globe'                               => 'fa fa-globe',
				'Gofore'                              => 'fab fa-gofore',
				'Golf Ball'                           => 'fa fa-golf-ball',
				'Goodreads'                           => 'fab fa-goodreads',
				'Goodreads G'                         => 'fab fa-goodreads-g',
				'Google Logo'                         => 'fab fa-google',
				'Google Drive'                        => 'fab fa-google-drive',
				'Google Play'                         => 'fab fa-google-play',
				'Google Plus'                         => 'fab fa-google-plus',
				'Google Plus G'                       => 'fab fa-google-plus-g',
				'Google Plus Square'                  => 'fab fa-google-plus-square',
				'Google Wallet'                       => 'fab fa-google-wallet',
				'Graduation Cap'                      => 'fa fa-graduation-cap',
				'Gratipay (Gittip)'                   => 'fab fa-gratipay',
				'Grav'                                => 'fab fa-grav',
				'Gripfire, Inc.'                      => 'fab fa-gripfire',
				'Grunt'                               => 'fab fa-grunt',
				'Gulp'                                => 'fab fa-gulp',
				'H Square'                            => 'fa fa-h-square',
				'Hacker News'                         => 'fab fa-hacker-news',
				'Hacker News Square'                  => 'fab fa-hacker-news-square',
				'Lizard (Hand)'                       => 'fa fa-hand-lizard',
				'Paper (Hand)'                        => 'fa fa-hand-paper',
				'Peace (Hand)'                        => 'fa fa-hand-peace',
				'Hand Pointing Down'                  => 'fa fa-hand-point-down',
				'Hand Pointing Left'                  => 'fa fa-hand-point-left',
				'Hand Pointing Right'                 => 'fa fa-hand-point-right',
				'Hand Pointing Up'                    => 'fa fa-hand-point-up',
				'Pointer (Hand)'                      => 'fa fa-hand-pointer',
				'Rock (Hand)'                         => 'fa fa-hand-rock',
				'Scissors (Hand)'                     => 'fa fa-hand-scissors',
				'Spock (Hand)'                        => 'fa fa-hand-spock',
				'Handshake'                           => 'fa fa-handshake',
				'Hashtag'                             => 'fa fa-hashtag',
				'HDD'                                 => 'fa fa-hdd',
				'Heading'                             => 'fa fa-heading',
				'Headphones'                          => 'fa fa-headphones',
				'Heart'                               => 'fa fa-heart',
				'Heartbeat'                           => 'fa fa-heartbeat',
				'Hips'                                => 'fab fa-hips',
				'HireAHelper'                         => 'fab fa-hire-a-helper',
				'History'                             => 'fa fa-history',
				'Hockey Puck'                         => 'fa fa-hockey-puck',
				'Home'                                => 'fa fa-home',
				'Hooli'                               => 'fab fa-hooli',
				'Hospital'                            => 'fa fa-hospital',
				'Hospital Symbol'                     => 'fa fa-hospital-symbol',
				'Hotjar'                              => 'fab fa-hotjar',
				'Hourglass'                           => 'fa fa-hourglass',
				'Hourglass End'                       => 'fa fa-hourglass-end',
				'Hourglass Half'                      => 'fa fa-hourglass-half',
				'Hourglass Start'                     => 'fa fa-hourglass-start',
				'Houzz'                               => 'fab fa-houzz',
				'HTML 5 Logo'                         => 'fab fa-html5',
				'HubSpot'                             => 'fab fa-hubspot',
				'I Beam Cursor'                       => 'fa fa-i-cursor',
				'Identification Badge'                => 'fa fa-id-badge',
				'Identification Card'                 => 'fa fa-id-card',
				'Image'                               => 'fa fa-image',
				'Images'                              => 'fa fa-images',
				'IMDB'                                => 'fab fa-imdb',
				'Inbox'                               => 'fa fa-inbox',
				'Indent'                              => 'fa fa-indent',
				'Industry'                            => 'fa fa-industry',
				'Info'                                => 'fa fa-info',
				'Info Circle'                         => 'fa fa-info-circle',
				'Instagram'                           => 'fab fa-instagram',
				'Internet Explorer'                   => 'fab fa-internet-explorer',
				'Ioxhost'                             => 'fab fa-ioxhost',
				'Italic'                              => 'fa fa-italic',
				'ITunes'                              => 'fab fa-itunes',
				'Itunes Note'                         => 'fab fa-itunes-note',
				'Jenkis'                              => 'fab fa-jenkins',
				'Joget'                               => 'fab fa-joget',
				'Joomla Logo'                         => 'fab fa-joomla',
				'JavaScript (JS)'                     => 'fab fa-js',
				'JavaScript (JS) Square'              => 'fab fa-js-square',
				'JsFiddle'                            => 'fab fa-jsfiddle',
				'Key'                                 => 'fa fa-key',
				'Keyboard'                            => 'fa fa-keyboard',
				'KeyCDN'                              => 'fab fa-keycdn',
				'Kickstarter'                         => 'fab fa-kickstarter',
				'Kickstarter K'                       => 'fab fa-kickstarter-k',
				'KORVUE'                              => 'fab fa-korvue',
				'Language'                            => 'fa fa-language',
				'Laptop'                              => 'fa fa-laptop',
				'Laravel'                             => 'fab fa-laravel',
				'Last.fm'                             => 'fab fa-lastfm',
				'Last.fm Square'                      => 'fab fa-lastfm-square',
				'Leaf'                                => 'fa fa-leaf',
				'Leanpub'                             => 'fab fa-leanpub',
				'Lemon'                               => 'fa fa-lemon',
				'Less'                                => 'fab fa-less',
				'Level Down Alternate'                => 'fa fa-level-down-alt',
				'Level Up Alternate'                  => 'fa fa-level-up-alt',
				'Life Ring'                           => 'fa fa-life-ring',
				'Lightbulb'                           => 'fa fa-lightbulb',
				'Line'                                => 'fab fa-line',
				'Link'                                => 'fa fa-link',
				'LinkedIn'                            => 'fab fa-linkedin',
				'LinkedIn In'                         => 'fab fa-linkedin-in',
				'Linode'                              => 'fab fa-linode',
				'Linux'                               => 'fab fa-linux',
				'Turkish Lira Sign'                   => 'fa fa-lira-sign',
				'List'                                => 'fa fa-list',
				'List Alternate'                      => 'fa fa-list-alt',
				'List Ol'                             => 'fa fa-list-ol',
				'List Ul'                             => 'fa fa-list-ul',
				'Location Arrow'                      => 'fa fa-location-arrow',
				'Lock'                                => 'fa fa-lock',
				'Lock Open'                           => 'fa fa-lock-open',
				'Alternate Long Arrow Down'           => 'fa fa-long-arrow-alt-down',
				'Alternate Long Arrow Left'           => 'fa fa-long-arrow-alt-left',
				'Alternate Long Arrow Right'          => 'fa fa-long-arrow-alt-right',
				'Alternate Long Arrow Up'             => 'fa fa-long-arrow-alt-up',
				'Low Vision'                          => 'fa fa-low-vision',
				'Lyft'                                => 'fab fa-lyft',
				'Magento'                             => 'fab fa-magento',
				'Magic'                               => 'fa fa-magic',
				'Magnet'                              => 'fa fa-magnet',
				'Male'                                => 'fa fa-male',
				'Map'                                 => 'fa fa-map',
				'Map Marker'                          => 'fa fa-map-marker',
				'Map Marker Alternate'                => 'fa fa-map-marker-alt',
				'Map Pin'                             => 'fa fa-map-pin',
				'Map Signs'                           => 'fa fa-map-signs',
				'Mars'                                => 'fa fa-mars',
				'Mars Double'                         => 'fa fa-mars-double',
				'Mars Stroke'                         => 'fa fa-mars-stroke',
				'Mars Stroke Horizontal'              => 'fa fa-mars-stroke-h',
				'Mars Stroke Vertical'                => 'fa fa-mars-stroke-v',
				'MaxCDN'                              => 'fab fa-maxcdn',
				'MedApps'                             => 'fab fa-medapps',
				'Medium'                              => 'fab fa-medium',
				'Medium M'                            => 'fab fa-medium-m',
				'Medkit'                              => 'fa fa-medkit',
				'MRT'                                 => 'fab fa-medrt',
				'Meetup'                              => 'fab fa-meetup',
				'Meh'                                 => 'fa fa-meh',
				'Mercury'                             => 'fa fa-mercury',
				'Microchip'                           => 'fa fa-microchip',
				'Microphone'                          => 'fa fa-microphone',
				'Microphone Slash'                    => 'fa fa-microphone-slash',
				'Microsoft'                           => 'fab fa-microsoft',
				'Minus'                               => 'fa fa-minus',
				'Minus Circle'                        => 'fa fa-minus-circle',
				'Minus Square'                        => 'fa fa-minus-square',
				'Mix'                                 => 'fab fa-mix',
				'Mixcloud'                            => 'fab fa-mixcloud',
				'Mizuni'                              => 'fab fa-mizuni',
				'Mobile Phone'                        => 'fa fa-mobile',
				'Alternate Mobile'                    => 'fa fa-mobile-alt',
				'MODX'                                => 'fab fa-modx',
				'Monero'                              => 'fab fa-monero',
				'Money Bill Alternate'                => 'fa fa-money-bill-alt',
				'Moon'                                => 'fa fa-moon',
				'Motorcycle'                          => 'fa fa-motorcycle',
				'Mouse Pointer'                       => 'fa fa-mouse-pointer',
				'Music'                               => 'fa fa-music',
				'Napster'                             => 'fab fa-napster',
				'Neuter'                              => 'fa fa-neuter',
				'Newspaper'                           => 'fa fa-newspaper',
				'Nintendo Switch'                     => 'fab fa-nintendo-switch',
				'Node.js'                             => 'fab fa-node',
				'Node.js JS'                          => 'fab fa-node-js',
				'Npm'                                 => 'fab fa-npm',
				'NS8'                                 => 'fab fa-ns8',
				'Nutritionix'                         => 'fab fa-nutritionix',
				'Object Group'                        => 'fa fa-object-group',
				'Object Ungroup'                      => 'fa fa-object-ungroup',
				'Odnoklassniki'                       => 'fab fa-odnoklassniki',
				'Odnoklassniki Square'                => 'fab fa-odnoklassniki-square',
				'OpenCart'                            => 'fab fa-opencart',
				'OpenID'                              => 'fab fa-openid',
				'Opera'                               => 'fab fa-opera',
				'Optin Monster'                       => 'fab fa-optin-monster',
				'Open Source Initiative'              => 'fab fa-osi',
				'Outdent'                             => 'fa fa-outdent',
				'Page4 Corporation'                   => 'fab fa-page4',
				'Pagelines'                           => 'fab fa-pagelines',
				'Paint Brush'                         => 'fa fa-paint-brush',
				'Palfed'                              => 'fab fa-palfed',
				'Pallet'                              => 'fa fa-pallet',
				'Paper Plane'                         => 'fa fa-paper-plane',
				'Paperclip'                           => 'fa fa-paperclip',
				'Paragraph'                           => 'fa fa-paragraph',
				'Paste'                               => 'fa fa-paste',
				'Patreon'                             => 'fab fa-patreon',
				'Pause'                               => 'fa fa-pause',
				'Pause Circle'                        => 'fa fa-pause-circle',
				'Paw'                                 => 'fa fa-paw',
				'Paypal'                              => 'fab fa-paypal',
				'Pen Square'                          => 'fa fa-pen-square',
				'Alternate Pencil'                    => 'fa fa-pencil-alt',
				'Percent'                             => 'fa fa-percent',
				'Periscope'                           => 'fab fa-periscope',
				'Phabricator'                         => 'fab fa-phabricator',
				'Phoenix Framework'                   => 'fab fa-phoenix-framework',
				'Phone'                               => 'fa fa-phone',
				'Phone Square'                        => 'fa fa-phone-square',
				'Phone Volume'                        => 'fa fa-phone-volume',
				'PHP'                                 => 'fab fa-php',
				'Pied Piper Logo'                     => 'fab fa-pied-piper',
				'Alternate Pied Piper Logo'           => 'fab fa-pied-piper-alt',
				'Pied Piper PP Logo (Old)'            => 'fab fa-pied-piper-pp',
				'Pills'                               => 'fa fa-pills',
				'Pinterest'                           => 'fab fa-pinterest',
				'Pinterest P'                         => 'fab fa-pinterest-p',
				'Pinterest Square'                    => 'fab fa-pinterest-square',
				'Plane'                               => 'fa fa-plane',
				'Play'                                => 'fa fa-play',
				'Play Circle'                         => 'fa fa-play-circle',
				'PlayStation'                         => 'fab fa-playstation',
				'Plug'                                => 'fa fa-plug',
				'Plus'                                => 'fa fa-plus',
				'Plus Circle'                         => 'fa fa-plus-circle',
				'Plus Square'                         => 'fa fa-plus-square',
				'Podcast'                             => 'fa fa-podcast',
				'Pound Sign'                          => 'fa fa-pound-sign',
				'Power Off'                           => 'fa fa-power-off',
				'Print'                               => 'fa fa-print',
				'Product Hunt'                        => 'fab fa-product-hunt',
				'Pushed'                              => 'fab fa-pushed',
				'Puzzle Piece'                        => 'fa fa-puzzle-piece',
				'Python'                              => 'fab fa-python',
				'QQ'                                  => 'fab fa-qq',
				'Qrcode'                              => 'fa fa-qrcode',
				'Question'                            => 'fa fa-question',
				'Question Circle'                     => 'fa fa-question-circle',
				'Quidditch'                           => 'fa fa-quidditch',
				'QuinScape'                           => 'fab fa-quinscape',
				'Quora'                               => 'fab fa-quora',
				'Quote Left'                          => 'fa fa-quote-left',
				'Quote Right'                         => 'fa fa-quote-right',
				'Random'                              => 'fa fa-random',
				'Ravelry'                             => 'fab fa-ravelry',
				'React'                               => 'fab fa-react',
				'Rebel Alliance'                      => 'fab fa-rebel',
				'Recycle'                             => 'fa fa-recycle',
				'Red River'                           => 'fab fa-red-river',
				'Reddit Logo'                         => 'fab fa-reddit',
				'Reddit Alien'                        => 'fab fa-reddit-alien',
				'Reddit Square'                       => 'fab fa-reddit-square',
				'Redo'                                => 'fa fa-redo',
				'Alternate Redo'                      => 'fa fa-redo-alt',
				'Registered Trademark'                => 'fa fa-registered',
				'Rendact'                             => 'fab fa-rendact',
				'Renren'                              => 'fab fa-renren',
				'Reply'                               => 'fa fa-reply',
				'Reply All'                           => 'fa fa-reply-all',
				'Replyd'                              => 'fab fa-replyd',
				'Resolving'                           => 'fab fa-resolving',
				'Retweet'                             => 'fa fa-retweet',
				'Road'                                => 'fa fa-road',
				'Rocket'                              => 'fa fa-rocket',
				'Rocket.Chat'                         => 'fab fa-rocketchat',
				'Rockrms'                             => 'fab fa-rockrms',
				'Rss'                                 => 'fa fa-rss',
				'RSS Square'                          => 'fa fa-rss-square',
				'Ruble Sign'                          => 'fa fa-ruble-sign',
				'Indian Rupee Sign'                   => 'fa fa-rupee-sign',
				'Safari'                              => 'fab fa-safari',
				'Sass'                                => 'fab fa-sass',
				'Save'                                => 'fa fa-save',
				'SCHLIX'                              => 'fab fa-schlix',
				'Scribd'                              => 'fab fa-scribd',
				'Search'                              => 'fa fa-search',
				'Search Minus'                        => 'fa fa-search-minus',
				'Search Plus'                         => 'fa fa-search-plus',
				'Searchengin'                         => 'fab fa-searchengin',
				'Sellcast'                            => 'fab fa-sellcast',
				'Sellsy'                              => 'fab fa-sellsy',
				'Server'                              => 'fa fa-server',
				'Servicestack'                        => 'fab fa-servicestack',
				'Share'                               => 'fa fa-share',
				'Alternate Share'                     => 'fa fa-share-alt',
				'Alternate Share Square'              => 'fa fa-share-alt-square',
				'Share Square'                        => 'fa fa-share-square',
				'Shekel Sign'                         => 'fa fa-shekel-sign',
				'Alternate Shield'                    => 'fa fa-shield-alt',
				'Ship'                                => 'fa fa-ship',
				'Shipping Fast'                       => 'fa fa-shipping-fast',
				'Shirts In Bulk'                      => 'fab fa-shirtsinbulk',
				'Shopping Bag'                        => 'fa fa-shopping-bag',
				'Shopping Basket'                     => 'fa fa-shopping-basket',
				'Shopping Cart'                       => 'fa fa-shopping-cart',
				'Shower'                              => 'fa fa-shower',
				'Alternate Sign In'                   => 'fa fa-sign-in-alt',
				'Sign Language'                       => 'fa fa-sign-language',
				'Alternate Sign Out'                  => 'fa fa-sign-out-alt',
				'Signal'                              => 'fa fa-signal',
				'SimplyBuilt'                         => 'fab fa-simplybuilt',
				'SISTRIX'                             => 'fab fa-sistrix',
				'Sitemap'                             => 'fa fa-sitemap',
				'Skyatlas'                            => 'fab fa-skyatlas',
				'Skype'                               => 'fab fa-skype',
				'Slack Logo'                          => 'fab fa-slack',
				'Slack Hashtag'                       => 'fab fa-slack-hash',
				'Horizontal Sliders'                  => 'fa fa-sliders-h',
				'Slideshare'                          => 'fab fa-slideshare',
				'Smile'                               => 'fa fa-smile',
				'Snapchat'                            => 'fab fa-snapchat',
				'Snapchat Ghost'                      => 'fab fa-snapchat-ghost',
				'Snapchat Square'                     => 'fab fa-snapchat-square',
				'Snowflake'                           => 'fa fa-snowflake',
				'Sort'                                => 'fa fa-sort',
				'Sort Alpha Down'                     => 'fa fa-sort-alpha-down',
				'Sort Alpha Up'                       => 'fa fa-sort-alpha-up',
				'Sort Amount Down'                    => 'fa fa-sort-amount-down',
				'Sort Amount Up'                      => 'fa fa-sort-amount-up',
				'Sort Down (Descending)'              => 'fa fa-sort-down',
				'Sort Numeric Down'                   => 'fa fa-sort-numeric-down',
				'Sort Numeric Up'                     => 'fa fa-sort-numeric-up',
				'Sort Up (Ascending)'                 => 'fa fa-sort-up',
				'SoundCloud'                          => 'fab fa-soundcloud',
				'Space Shuttle'                       => 'fa fa-space-shuttle',
				'Speakap'                             => 'fab fa-speakap',
				'Spinner'                             => 'fa fa-spinner',
				'Spotify'                             => 'fab fa-spotify',
				'Square'                              => 'fa fa-square',
				'Square Full'                         => 'fa fa-square-full',
				'Stack Exchange'                      => 'fab fa-stack-exchange',
				'Stack Overflow'                      => 'fab fa-stack-overflow',
				'Star'                                => 'fa fa-star',
				'Star Half'                           => 'fa fa-star-half',
				'StayLinked'                          => 'fab fa-staylinked',
				'Steam'                               => 'fab fa-steam',
				'Steam Square'                        => 'fab fa-steam-square',
				'Steam Symbol'                        => 'fab fa-steam-symbol',
				'Step Backward'                       => 'fa fa-step-backward',
				'Step Forward'                        => 'fa fa-step-forward',
				'Stethoscope'                         => 'fa fa-stethoscope',
				'Sticker Mule'                        => 'fab fa-sticker-mule',
				'Sticky Note'                         => 'fa fa-sticky-note',
				'Stop'                                => 'fa fa-stop',
				'Stop Circle'                         => 'fa fa-stop-circle',
				'Stopwatch'                           => 'fa fa-stopwatch',
				'Strava'                              => 'fab fa-strava',
				'Street View'                         => 'fa fa-street-view',
				'Strikethrough'                       => 'fa fa-strikethrough',
				'Stripe'                              => 'fab fa-stripe',
				'Stripe S'                            => 'fab fa-stripe-s',
				'Studio Vinari'                       => 'fab fa-studiovinari',
				'StumbleUpon Logo'                    => 'fab fa-stumbleupon',
				'StumbleUpon Circle'                  => 'fab fa-stumbleupon-circle',
				'Subscript'                           => 'fa fa-subscript',
				'Subway'                              => 'fa fa-subway',
				'Suitcase'                            => 'fa fa-suitcase',
				'Sun'                                 => 'fa fa-sun',
				'Superpowers'                         => 'fab fa-superpowers',
				'Superscript'                         => 'fa fa-superscript',
				'Supple'                              => 'fab fa-supple',
				'Sync'                                => 'fa fa-sync',
				'Alternate Sync'                      => 'fa fa-sync-alt',
				'Syringe'                             => 'fa fa-syringe',
				'Table'                               => 'fa fa-table',
				'Table Tennis'                        => 'fa fa-table-tennis',
				'Tablet'                              => 'fa fa-tablet',
				'Alternate Tablet'                    => 'fa fa-tablet-alt',
				'Alternate Tachometer'                => 'fa fa-tachometer-alt',
				'Tag'                                 => 'fa fa-tag',
				'Tags'                                => 'fa fa-tags',
				'Tasks'                               => 'fa fa-tasks',
				'Taxi'                                => 'fa fa-taxi',
				'Telegram'                            => 'fab fa-telegram',
				'Telegram Plane'                      => 'fab fa-telegram-plane',
				'Tencent Weibo'                       => 'fab fa-tencent-weibo',
				'Terminal'                            => 'fa fa-terminal',
				'Text Height'                         => 'fa fa-text-height',
				'Text Width'                          => 'fa fa-text-width',
				'Th'                                  => 'fa fa-th',
				'Th Large'                            => 'fa fa-th-large',
				'Th List'                             => 'fa fa-th-list',
				'ThemeIsle'                           => 'fab fa-themeisle',
				'Thermometer'                         => 'fa fa-thermometer',
				'Thermometer Empty'                   => 'fa fa-thermometer-empty',
				'Thermometer Full'                    => 'fa fa-thermometer-full',
				'Thermometer 1/2 Full'                => 'fa fa-thermometer-half',
				'Thermometer 1/4 Full'                => 'fa fa-thermometer-quarter',
				'Thermometer 3/4 Full'                => 'fa fa-thermometer-three-quarters',
				'Thumbs Down'                         => 'fa fa-thumbs-down',
				'Thumbs Up'                           => 'fa fa-thumbs-up',
				'Thumbtack'                           => 'fa fa-thumbtack',
				'Alternate Ticket'                    => 'fa fa-ticket-alt',
				'Times'                               => 'fa fa-times',
				'Times Circle'                        => 'fa fa-times-circle',
				'Tint'                                => 'fa fa-tint',
				'Toggle Off'                          => 'fa fa-toggle-off',
				'Toggle On'                           => 'fa fa-toggle-on',
				'Trademark'                           => 'fa fa-trademark',
				'Train'                               => 'fa fa-train',
				'Transgender'                         => 'fa fa-transgender',
				'Alternate Transgender'               => 'fa fa-transgender-alt',
				'Trash'                               => 'fa fa-trash',
				'Alternate Trash'                     => 'fa fa-trash-alt',
				'Tree'                                => 'fa fa-tree',
				'Trello'                              => 'fab fa-trello',
				'TripAdvisor'                         => 'fab fa-tripadvisor',
				'Trophy'                              => 'fa fa-trophy',
				'Truck'                               => 'fa fa-truck',
				'TTY'                                 => 'fa fa-tty',
				'Tumblr'                              => 'fab fa-tumblr',
				'Tumblr Square'                       => 'fab fa-tumblr-square',
				'Television'                          => 'fa fa-tv',
				'Twitch'                              => 'fab fa-twitch',
				'Twitter'                             => 'fab fa-twitter',
				'Twitter Square'                      => 'fab fa-twitter-square',
				'Typo3'                               => 'fab fa-typo3',
				'Uber'                                => 'fab fa-uber',
				'UIkit'                               => 'fab fa-uikit',
				'Umbrella'                            => 'fa fa-umbrella',
				'Underline'                           => 'fa fa-underline',
				'Undo'                                => 'fa fa-undo',
				'Alternate Undo'                      => 'fa fa-undo-alt',
				'Uniregistry'                         => 'fab fa-uniregistry',
				'Universal Access'                    => 'fa fa-universal-access',
				'University'                          => 'fa fa-university',
				'Unlink'                              => 'fa fa-unlink',
				'Unlock'                              => 'fa fa-unlock',
				'Alternate Unlock'                    => 'fa fa-unlock-alt',
				'Untappd'                             => 'fab fa-untappd',
				'Upload'                              => 'fa fa-upload',
				'USB'                                 => 'fab fa-usb',
				'User'                                => 'fa fa-user',
				'User Circle'                         => 'fa fa-user-circle',
				'User Md'                             => 'fa fa-user-md',
				'Add User'                            => 'fa fa-user-plus',
				'User Secret'                         => 'fa fa-user-secret',
				'Remove User'                         => 'fa fa-user-times',
				'Users'                               => 'fa fa-users',
				'Us Sunnah Foundation'                => 'fab fa-ussunnah',
				'Utensil Spoon'                       => 'fa fa-utensil-spoon',
				'Utensils'                            => 'fa fa-utensils',
				'Vaadin'                              => 'fab fa-vaadin',
				'Venus'                               => 'fa fa-venus',
				'Venus Double'                        => 'fa fa-venus-double',
				'Venus Mars'                          => 'fa fa-venus-mars',
				'Viacoin'                             => 'fab fa-viacoin',
				'Viadeo'                              => 'fab fa-viadeo',
				'Viadeo Square'                       => 'fab fa-viadeo-square',
				'Viber'                               => 'fab fa-viber',
				'Video'                               => 'fa fa-video',
				'Vimeo'                               => 'fab fa-vimeo-v',
				'Vimeo Square'                        => 'fab fa-vimeo-square',
				'Vine'                                => 'fab fa-vine',
				'VK'                                  => 'fab fa-vk',
				'VNV'                                 => 'fab fa-vnv',
				'Volleyball Ball'                     => 'fa fa-volleyball-ball',
				'Volume Down'                         => 'fa fa-volume-down',
				'Volume Off'                          => 'fa fa-volume-off',
				'Volume Up'                           => 'fa fa-volume-up',
				'Vue.js'                              => 'fab fa-vuejs',
				'Warehouse'                           => 'fa fa-warehouse',
				'Weibo'                               => 'fab fa-weibo',
				'Weight'                              => 'fa fa-weight',
				'Weixin (WeChat)'                     => 'fab fa-weixin',
				'Whats App'                           => 'fab fa-whatsapp',
				'What	s App Square'                => 'fab fa-whatsapp-square',
				'Wheelchair'                          => 'fa fa-wheelchair',
				'WHMCS'                               => 'fab fa-whmcs',
				'WiFi'                                => 'fa fa-wifi',
				'Wikipedia W'                         => 'fab fa-wikipedia-w',
				'Window Close'                        => 'fa fa-window-close',
				'Window Maximize'                     => 'fa fa-window-maximize',
				'Window Minimize'                     => 'fa fa-window-minimize',
				'Window Restore'                      => 'fa fa-window-restore',
				'Windows'                             => 'fab fa-windows',
				'Won Sign'                            => 'fa fa-won-sign',
				'WordPress Logo'                      => 'fab fa-wordpress',
				'Wordpress Simple'                    => 'fab fa-wordpress-simple',
				'WPBeginner'                          => 'fab fa-wpbeginner',
				'WPExplorer'                          => 'fab fa-wpexplorer',
				'WPForms'                             => 'fab fa-wpforms',
				'Wrench'                              => 'fa fa-wrench',
				'Xbox'                                => 'fab fa-xbox',
				'Xing'                                => 'fab fa-xing',
				'Xing Square'                         => 'fab fa-xing-square',
				'Y Combinator'                        => 'fab fa-y-combinator',
				'Yahoo Logo'                          => 'fab fa-yahoo',
				'Yandex'                              => 'fab fa-yandex',
				'Yandex International'                => 'fab fa-yandex-international',
				'Yelp'                                => 'fab fa-yelp',
				'Yen Sign'                            => 'fa fa-yen-sign',
				'Yoast'                               => 'fab fa-yoast',
				'YouTube'                             => 'fab fa-youtube',
				'YouTube Square'                      => 'fab fa-youtube-square'
			) );
		}
		
		function specific_icons() {
			return array(
				'search'        => 'fa fa-search',
				'dropdown-cart' => 'fa fa-shopping-cart',
				'menu'          => 'fa fa-bars',
				'close'         => 'fa fa-times',
				'back-to-top'   => 'fa fa-angle-up',
				'mobile-menu'   => 'fa fa-bars',
				'quote'         => 'fa fa-quote-left',
				'facebook'      => 'fab fa-facebook-square',
				'twitter'       => 'fab fa-twitter-square',
				'linkedin'      => 'fab fa-linkedin',
				'pinterest'     => 'fab fa-pinterest-square',
				'tumblr'        => 'fab fa-tumblr-square',
				'vk'            => 'fab fa-vk',
			);
		}
	}
}