<?php

if ( ! function_exists( 'stal_core_add_portfolio_list_variation_info_below' ) ) {
	function stal_core_add_portfolio_list_variation_info_below( $variations ) {
		
		$variations['info-below'] = esc_html__( 'Info Below', 'stal-core' );
		
		return $variations;
	}
	
	add_filter( 'stal_core_filter_portfolio_list_layouts', 'stal_core_add_portfolio_list_variation_info_below' );
}

if ( ! function_exists( 'stal_core_add_portfolio_list_options_info_below' ) ) {
	function stal_core_add_portfolio_list_options_info_below( $options ) {
		$info_below_options   = array();
		$margin_option        = array(
			'field_type' => 'text',
			'name'       => 'info_below_content_margin_top',
			'title'      => esc_html__( 'Content Top Margin', 'stal-core' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'info-below',
						'default_value' => 'default'
					)
				)
			),
			'group'      => esc_html__( 'Layout', 'stal-core' )
		);
		$info_below_options[] = $margin_option;
		
		return array_merge( $options, $info_below_options );
	}
	
	add_filter( 'stal_core_filter_portfolio_list_extra_options', 'stal_core_add_portfolio_list_options_info_below' );
}