<?php
/**
 * Plugin Name: Qi Addons For Elementor Premium
 * Plugin URI: https://qodeinteractive.com
 * Description: Qi Addons for Elementor Premium is a comprehensive library of 60 custom, flexible & easily styled widgets for Elementor developed by Qode Interactive.
 * Author: Qode Interactive
 * Author URI: https://qodeinteractive.com/
 * Version: 1.6.2
 * Text Domain: qi-addons-for-elementor-premium
 * Elementor tested up to: 3.18.0
 * Elementor Pro tested up to: 3.17.1
*/
if ( ! class_exists( 'QiAddonsForElementorPremium' ) ) {
	class QiAddonsForElementorPremium {
		private static $instance;

		function __construct() {
			$this->before_init();

			add_action( 'qi_addons_for_elementor_premium_action_framework_load_dependent_plugins', array( $this, 'init' ) );
		}

		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		function before_init() {
			define( 'QI_ADDONS_FOR_ELEMENTOR_PREMIUM_PLUGIN_BASE_FILE', plugin_basename( __FILE__ ) ); // constant is defined here because it's not possible to get main plugin file name from constant.php ( it would return 'constant.php' itself )
			require_once 'constants.php';

			require_once QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ADMIN_PATH . '/class-qiaddonsforelementorpremium-framework.php';
		}

		function init() {
			$this->require_core();

			// Include plugin assets
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_assets' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'localize_js_scripts' ) );

			// Make plugin available for translation
			add_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ), 15 );

			// Add plugin's body classes
			add_filter( 'body_class', array( $this, 'add_body_classes' ) );

			// Hook to include additional modules when plugin loaded
			do_action( 'qi_addons_for_elementor_premium_action_plugin_loaded' );
		}

		function require_core() {
			require_once QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ABS_PATH . '/helpers/helper.php';

			// Hook to include additional files before modules inclusion
			do_action( 'qi_addons_for_elementor_premium_action_before_include_modules' );

			$modules = apply_filters( 'qi_addons_for_elementor_premium_filter_modules_include', glob( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_INC_PATH . '/*/include.php' ) );

			foreach ( $modules as $module ) {
				include_once $module;
			}

			// Hook to include additional files after modules inclusion
			do_action( 'qi_addons_for_elementor_premium_action_after_include_modules' );
		}

		function enqueue_assets() {
			// CSS and JS dependency variables
			$style_dependency_array  = apply_filters( 'qi_addons_for_elementor_premium_filter_style_dependencies', array( 'qi-addons-for-elementor-style' ) );
			$script_dependency_array = apply_filters( 'qi_addons_for_elementor_premium_filter_script_dependencies', array( 'jquery', 'qi-addons-for-elementor-script' ) );

			// Hook to include additional scripts before plugin's main style
			do_action( 'qi_addons_for_elementor_premium_action_before_main_css' );

			// Enqueue plugin's helper style
			wp_enqueue_style( 'qi-addons-for-elementor-premium-helper-parts-style', QI_ADDONS_FOR_ELEMENTOR_PREMIUM_URL_PATH . 'assets/css/helper-parts.min.css' );

			// Enqueue plugin's main style
			wp_enqueue_style( 'qi-addons-for-elementor-premium-style', QI_ADDONS_FOR_ELEMENTOR_PREMIUM_URL_PATH . 'assets/css/main.min.css', $style_dependency_array );

			// Hook to include additional scripts after plugin's main style
			do_action( 'qi_addons_for_elementor_premium_action_after_main_css' );

			// Hook to include additional scripts before plugin's main script
			do_action( 'qi_addons_for_elementor_premium_action_before_main_js' );

			// Enqueue plugin's main script
			wp_enqueue_script( 'qi-addons-for-elementor-premium-script', QI_ADDONS_FOR_ELEMENTOR_PREMIUM_URL_PATH . 'assets/js/main.min.js', $script_dependency_array, false, true );

			wp_register_script( 'typeform-js', '//embed.typeform.com/next/embed.js', array( 'jquery' ), false, true );

			// Hook to include additional scripts after plugin's main script
			do_action( 'qi_addons_for_elementor_premium_action_after_main_js' );
		}

		function load_plugin_textdomain() {
			load_plugin_textdomain( 'qi-addons-for-elementor-premium', false, QI_ADDONS_FOR_ELEMENTOR_PREMIUM_REL_PATH . '/languages' );
		}

		function add_body_classes( $classes ) {
			$classes[] = 'qi-addons-for-elementor-premium-' . QI_ADDONS_FOR_ELEMENTOR_PREMIUM_VERSION;

			return $classes;
		}

		function localize_js_scripts() {
			$global = apply_filters(
				'qi_addons_for_elementor_premium_filter_localize_main_js',
				array()
			);

			wp_localize_script(
				'qi-addons-for-elementor-premium-script',
				'qodefQiAddonsPremiumGlobal',
				array(
					'vars' => $global,
				)
			);
		}
	}

	QiAddonsForElementorPremium::get_instance();
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_activation_trigger' ) ) {
	/**
	 * Function that trigger hooks on plugin activation
	 */
	function qi_addons_for_elementor_premium_activation_trigger() {

		// Hook to add additional code on plugin activation
		do_action( 'qi_addons_for_elementor_premium_action_on_activation' );
	}

	register_activation_hook( __FILE__, 'qi_addons_for_elementor_premium_activation_trigger' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_deactivation_trigger' ) ) {
	/**
	 * Function that trigger hooks on plugin deactivation
	 */
	function qi_addons_for_elementor_premium_deactivation_trigger() {

		// Hook to add additional code on plugin deactivation
		do_action( 'qi_addons_for_elementor_premium_action_on_deactivation' );
	}

	register_deactivation_hook( __FILE__, 'qi_addons_for_elementor_premium_deactivation_trigger' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_check_requirements' ) ) {
	/**
	 * Function that check plugin requirements
	 */
	function qi_addons_for_elementor_premium_check_requirements() {
		if ( ! defined( 'QI_ADDONS_FOR_ELEMENTOR_VERSION' ) ) {
			add_action( 'admin_notices', 'qi_addons_for_elementor_premium_admin_notice_content' );
		}
	}

	add_action( 'plugins_loaded', 'qi_addons_for_elementor_premium_check_requirements' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_admin_notice_content' ) ) {
	/**
	 * Function that display the error message if the requirements are not met
	 */
	function qi_addons_for_elementor_premium_admin_notice_content() {
		echo sprintf( '<div class="notice notice-error"><p>%s</p></div>', esc_html__( 'Qi Addons for Elementor plugin is required for Qi Addons for Elementor Premium plugin to work properly. Please install/activate it first.', 'qi-addons-for-elementor-premium' ) );

		if ( function_exists( 'deactivate_plugins' ) ) {
			deactivate_plugins( plugin_basename( __FILE__ ) );
		}
	}
}
