<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_get_api_keys' ) ) {

	/**
	 * Function that return api keys from db
	 *
	 * @param string $key - requested key
	 *
	 * @return mixed Values if exist, otherwise false
	 */

	function qi_addons_for_elementor_premium_get_api_keys( $key ) {

		$all_keys = get_option( 'QI_ADDONS_FOR_ELEMENTOR_PREMIUM_INTEGRATION_KEYS' );

		if ( false !== $all_keys && isset( $all_keys[ $key ] ) ) {
			return $all_keys[ $key ];
		}

		return false;

	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_list_sc_template_part' ) ) {
	/**
	 * Echo module template part.
	 *
	 * @param string $module name of the module from inc folder
	 * @param string $template full path of the template to load
	 * @param string $slug
	 * @param array $params array of parameters to pass to template
	 */
	function qi_addons_for_elementor_premium_list_sc_template_part( $module, $template, $slug = '', $params = array() ) {
		echo qi_addons_for_elementor_premium_get_list_sc_template_part( $module, $template, $slug, $params );
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_get_list_sc_template_part' ) ) {
	/**
	 * Echo module template part.
	 *
	 * @param string $module name of the module from inc folder
	 * @param string $template full path of the template to load
	 * @param string $slug
	 * @param array $params array of parameters to pass to template
	 *
	 * @return string - string containing html of template
	 */
	function qi_addons_for_elementor_premium_get_list_sc_template_part( $module, $template, $slug = '', $params = array() ) {
		$root = QI_ADDONS_FOR_ELEMENTOR_PREMIUM_INC_PATH;

		return qi_addons_for_elementor_premium_framework_get_list_sc_template_part( $root, $module, $template, $slug, $params );
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_template_part' ) ) {
	/**
	 * Echo module template part.
	 *
	 * @param string $module name of the module from inc folder
	 * @param string $template full path of the template to load
	 * @param string $slug
	 * @param array $params array of parameters to pass to template
	 *
	 */
	function qi_addons_for_elementor_premium_template_part( $module, $template, $slug = '', $params = array() ) {
		echo qi_addons_for_elementor_premium_get_template_part( $module, $template, $slug, $params );
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_get_template_part' ) ) {
	/**
	 * Loads module template part.
	 *
	 * @param string $module name of the module from inc folder
	 * @param string $template full path of the template to load
	 * @param string $slug
	 * @param array $params array of parameters to pass to template
	 *
	 * @return string - string containing html of template
	 */
	function qi_addons_for_elementor_premium_get_template_part( $module, $template, $slug = '', $params = array() ) {
		$root = QI_ADDONS_FOR_ELEMENTOR_PREMIUM_INC_PATH;

		return qi_addons_for_elementor_premium_framework_get_template_part( $root, $module, $template, $slug, $params );
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_is_widget_disabled' ) ) {

	/**
	 * Function that returns array with disabled widgets
	 *
	 *
	 * @param string $type - type of select field
	 * @param bool $enable_default - add first element empty for default value
	 * @param array $exclude - array of items to exclude
	 * @param array $include - array of items to include
	 *
	 * @return bool
	 */

	function qi_addons_for_elementor_premium_is_widget_disabled( $widget ) {
		$disabled_widgets = get_option( QI_ADDONS_FOR_ELEMENTOR_DISABLED_WIDGETS );

		$disabled_widgets_folders = array();

		if ( is_array( $disabled_widgets ) && count( $disabled_widgets ) > 0 ) {
			foreach ( $disabled_widgets as $disabled_widget_key => $disabled_widget_value ) {
				$disabled_widgets_folders[] = $disabled_widget_value;
			}
		}

		if ( in_array( basename( $widget ), $disabled_widgets_folders, true ) ) {
			return true;
		}

		return false;
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_svg_icon' ) ) {

	/**
	 * Function that adds additional svg icon
	 *
	 *
	 * @param string $html - svg icon html
	 * @param string $name - name of svg icon
	 * @param string $class_name - html class name
	 *
	 * @return string
	 */

	function qi_addons_for_elementor_premium_add_svg_icon( $html, $name, $class_name ) {

		$class = isset( $class_name ) && ! empty( $class_name ) ? 'class="' . esc_attr( $class_name ) . '"' : '';

		switch ( $name ) {
			case 'ripped-lines':
				$html = '<svg ' . $class . ' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="789.5px" height="238.9px" viewBox="0 0 789.5 238.9" style="enable-background:new 0 0 789.5 238.9;" xml:space="preserve" preserveAspectRatio="none">
						<path d="M1.6,160.2c0,0,17.2-27.5,26.4-45.8s26.9-58.2,26.9-58.2s7.7-7.3,8.8-12.9S63.3,31.8,69,25.9  C74.7,20,86,8.1,93.9,5.7s11-3.1,18.5-2.8s23.3-1.6,37.1-1.9c13.8-0.3,70.6,8.7,78.4,8.6c7.8-0.1,23.6,3.7,29.6,3.9  c6,0.2,32.5,1.9,42.8,2.4c10.3,0.5,19.7,3.2,32.5,6.8s20.6,4,34.2,5.9c13.6,1.9,17.2,2.9,22.7,5.4s18.4,10,33.9,10.6  c15.5,0.6,53.8,2.8,74.2,4.7c20.4,1.9,31.8,4.5,40.8,4.2c8.9-0.3,32.3-5.1,42.5-5c10.2,0.1,44.6,3.5,53.5,2.8  c8.9-0.7,54.3-9.3,63.1-10.2s18.7-2.5,20.8-3.5c2.1-1,8.6-9.7,10.2-8.8s2.9,4.7,4.2,9.8s4.7,9.4,5,16.6s2.4,39.1,2.4,39.1  s1.1,23.2,3,31.7c1.9,8.5,7.2,23.5,7.4,26.6c0.2,3.1,0,7,0,7s2.2-0.2,1.9,1.2c-0.3,1.4-2.8,9.7-2.8,9.7s-5.7-4.3-13.1-2.5  c-7.4,1.8-9,4.4-12.3,8.8c-3.3,4.4-4.1,9.2-29.3,9.3c-25.2,0.1-36.5-0.6-65.6,2.1c-29.1,2.6-37.1,2.2-53.4,8.1  c-16.3,5.9-27.5,12.6-50.6,10.3c-23.2-2.3-18.9-4.3-37-2.8c-18.1,1.5-57.7,5.9-78.8,7s-54.6,3.3-67.8,1.1s-46-3.6-59.5-3.4  s-45.2-6.4-66.6-10s-31.3-4.1-36.2-5.1c-4.9-0.9-22.1-8.6-38.6-13.5c-16.5-4.9-48.7-5.3-56.6-6.7s-13.2-5.5-18.2-5.8  c-5-0.3-21.5,0.4-34.6-1.5C18.4,163.9,1.6,160.2,1.6,160.2z" pathLength="1"/>
						<path d="M37.1,65l2.6-9.1c0,0,10.8,5.3,16.5,2.8s9.8-12.6,18.2-14.5c8.5-1.9,18.5-0.4,50-2c31.6-1.6,47.8,1.5,68.1-4.3  S230.2,24,245,23.1c14.9-0.9,42.8,5.9,58.5,4.7c15.7-1.2,29-5.2,61.4-5.5s63.2-4.2,76.6-0.5s58.4,3.2,73.4,4.7  c15,1.5,46.8,7.1,59.8,12.1c13,5,29.7,3.1,40.4,6.7C625.8,49,647,62.7,672.3,65c25.3,2.3,30.4,2.1,40,4.9s21.5,0,37,2.7  s31,5,36.4,6.5s1.3,3.7,1.3,3.7s-35,60.2-40.9,77.9c-5.9,17.7-18.5,23.9-19.5,31.1c-0.9,7.2-0.5,11.1-4.9,16.4  c-4.5,5.3-16.6,24.1-35.4,26.6c-18.8,2.5-52.2,3.9-63.2,2.5c-11-1.4-45.2-7.7-59.7-8.8c-14.5-1-29.4-6.1-55.4-6.4  s-64.9-16.6-83-17.5c-18.1-0.9-29.9-6.6-40.5-12.6c-10.5-6-29.6-3.2-45.1-4.5c-15.5-1.2-57.3-4.7-77.1-8.1s-36.6,0-51,0  c-14.4,0-27.7-4.4-51.4-3.2c-23.7,1.2-50.5,9.3-65.9,11c-15.4,1.7-27.8-0.2-31.5,5.6c-3.8,5.8-4.8,9.7-7.3-0.2  c-2.6-9.9-8.9-40.8-7.5-57.4s0.7-25.5-3.3-39.9S37.1,65,37.1,65z" pathLength="1"/>
						</svg>';
				break;
			case 'drawn-underline':
				$html = '<svg ' . $class . ' xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="520px" height="9.001px" viewBox="0 0 520 9.001" enable-background="new 0 0 520 9.001" xml:space="preserve" preserveAspectRatio="xMaxYMax meet">
						<path fill="none" stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M17.549,2.49  c35.122-0.913,77.949-1.463,118.416-1.463c59.421,0,117.662-0.288,177.083,1.011C381.924,3.663,450.124,3.663,519,4.638  C346.474,4.526,170.413,11.214,1,6.025c39.834-3.038,207.725-3.026,254.316-3.026c54.02,0,223.507-1.561,243.764,0.063  C459.916,9.398,259.395,5.02,231.694,5.036C183.632,5.062,58.144,6.802,6.824,2.902" pathLength="1"/>
						</svg>';
				break;
			case 'rectangle':
				$html = '<svg ' . $class . ' width="100%" height="100%" xmlns="http://www.w3.org/2000/svg">
                        <rect stroke-width="5" width="100%" height="100%" pathLength="1"/>
                        </svg>';
				break;
			case 'line':
				$html = '<svg ' . $class . ' width="100%" height="100%" xmlns="http://www.w3.org/2000/svg">
                        <line x1="0%" y1="80%" x2="100%" y2="80%" pathLength="1"></line>
                        </svg>';
				break;
		}

		return $html;

	}

	add_filter( 'qi_addons_for_elementor_filter_svg_icon', 'qi_addons_for_elementor_premium_add_svg_icon', 10, 3 );
}

// TODO: Remove the function before release
if ( ! function_exists( 'qi_addons_for_elementor_premium_add_icons' ) ) {
	function qi_addons_for_elementor_premium_add_icons( $icons ) {
		$new_icons = array(
			'linear-icons-2' => array(
				'name'          => 'linear-icons-2',
				'label'         => __( 'Linear Icons', 'qi-addons-for-elementor-premium' ),
				'url'           => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_INC_URL_PATH . '/icons/linear-icons/assets/css/linear-icons.min.css',
				'enqueue'       => array( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_INC_URL_PATH . '/icons/linear-icons/assets/css/linear-icons.min.css' ),
				'prefix'        => 'lnr-',
				'displayPrefix' => 'lnr',
				'labelIcon'     => 'lnr',
				'ver'           => '1.0',
				'fetchJson'     => array( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_INC_URL_PATH . '/icons/linear-icons/assets/js/regular.js' ),
				'native'        => true,
			),
		);

		return array_merge( $icons, $new_icons );
	}

	//add_filter( 'elementor/icons_manager/additional_tabs', 'qi_addons_for_elementor_premium_add_icons' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_get_ajax_status' ) ) {
	/**
	 * Function that return status from ajax functions
	 *
	 * @param string       $status   - success or error
	 * @param string       $message  - ajax message value
	 * @param string|array $data     - returned value
	 * @param string       $redirect - url address
	 */
	function qi_addons_for_elementor_premium_get_ajax_status( $status, $message, $data = null, $redirect = '' ) {
		$response = array(
			'status'   => esc_attr( $status ),
			'message'  => esc_html( $message ),
			'data'     => $data,
			'redirect' => ! empty( $redirect ) ? esc_url( $redirect ) : '',
		);

		$output = json_encode( $response );

		exit( $output ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}
