<?php
if ( ! function_exists( 'qi_addons_for_elementor_premium_get_license' ) ) {
	/**
	 * @return mixed Value of the option if exist or bool if not exist.
	 */
	function qi_addons_for_elementor_premium_get_license() {
		return trim( get_option( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_LICENSE_OPTION_NAME ) );
	}
}
if ( ! function_exists( 'qi_addons_for_elementor_premium_plugin_get_license_status' ) ) {
	/**
	 * @return mixed Value of the option if exist or bool if not exist.
	 */
	function qi_addons_for_elementor_premium_plugin_get_license_status() {
		return get_option( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_LICENSE_STATUS_OPTION_NAME );
	}
}
if ( ! function_exists( 'qi_addons_for_elementor_premium_is_plugin_activated' ) ) {
	/**
	 * @return bool Check is plugin activated
	 */
	function qi_addons_for_elementor_premium_is_plugin_activated() {

		$license        = qi_addons_for_elementor_premium_get_license();
		$license_status = qi_addons_for_elementor_premium_plugin_get_license_status();

		if ( ( ! empty( $license ) && ! empty( $license_status ) && 'valid' === $license_status ) || ( strpos( getenv( 'HTTP_HOST' ), 'qodeinteractive' ) !== false ) ) {
			return true;
		}

		return false;

	}
}
if ( ! function_exists( 'qi_addons_for_elementor_premium_plugin_updater' ) ) {

	function qi_addons_for_elementor_premium_plugin_updater() {

		// To support auto-updates, this needs to run during the wp_version_check cron job for privileged users.
		$doing_cron = defined( 'DOING_CRON' ) && DOING_CRON;
		if ( ! current_user_can( 'manage_options' ) && ! $doing_cron ) {
			return;
		}

		// retrieve our license key from the DB
		$license_key = qi_addons_for_elementor_premium_get_license();

		// setup the updater
		$edd_updater = new QiAddonsForElementorPremium_Updater(
			QI_ADDONS_FOR_ELEMENTOR_PREMIUM_STORE_URL,
			QI_ADDONS_FOR_ELEMENTOR_PREMIUM_PLUGIN_BASE_FILE,
			array(
				'version' => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_VERSION,
				'license' => $license_key,
				'item_id' => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ITEM_ID,
				'author'  => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ITEM_AUTHOR,
				'beta'    => false,
			)
		);

	}

	add_action( 'init', 'qi_addons_for_elementor_premium_plugin_updater' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_modules_includer' ) ) {
	function qi_addons_for_elementor_premium_modules_includer( $modules ) {

		if ( ! qi_addons_for_elementor_premium_is_plugin_activated() ) {
			$modules = array();
		}

		return $modules;

	}

	add_filter( 'qi_addons_for_elementor_premium_filter_modules_include', 'qi_addons_for_elementor_premium_modules_includer' );
}


if ( ! function_exists( 'qi_addons_for_elementor_premium_clean_promotion_list' ) ) {
	function qi_addons_for_elementor_premium_clean_promotion_list( $shortcodes ) {

		if ( qi_addons_for_elementor_premium_is_plugin_activated() ) {
			$shortcodes = array();
		}

		return $shortcodes;

	}

	add_filter( 'qi_addons_for_elementor_filter_promotion_shortcodes_list', 'qi_addons_for_elementor_premium_clean_promotion_list' );

}

if ( ! function_exists( 'qi_addons_for_elementor_premium_clean_elementor_promotion_tab' ) ) {
	function qi_addons_for_elementor_premium_clean_elementor_promotion_tab( $enabled ) {

		if ( qi_addons_for_elementor_premium_is_plugin_activated() ) {
			return true;
		}

		return $enabled;

	}

	add_filter( 'qi_addons_for_elementor_filter_elementor_promotion_tab', 'qi_addons_for_elementor_premium_clean_elementor_promotion_tab' );

}

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_rest_api_deregistration_route' ) ) {
	/**
	 * Extend main rest api routes with new case
	 *
	 * @param array $routes - list of rest routes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_rest_api_deregistration_route( $routes ) {
		$routes['deregister'] = array(
			'route'    => 'deregister',
			'methods'  => WP_REST_Server::CREATABLE,
			'callback' => 'qi_addons_for_elementor_premium_deregister_plugin',
			'args'     => array(
				'options' => array(
					'required'          => false,
					'validate_callback' => function ( $param, $request, $key ) {
						// Simple solution for validation can be 'is_array' value instead of callback function
						return is_array( $param ) ? $param : (array) $param;
					},
					'description'       => esc_html__( 'Options data is array with all selected shortcode parameters value', 'qi-addons-for-elementor-premium' ),
				),
			),
		);

		return $routes;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_rest_api_routes', 'qi_addons_for_elementor_premium_add_rest_api_deregistration_route' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_deregister_plugin' ) ) {
	/**
	 * Function that deregister plugin
	 *
	 * @return void
	 */
	function qi_addons_for_elementor_premium_deregister_plugin() {
		$license        = qi_addons_for_elementor_premium_get_license();
		$license_status = qi_addons_for_elementor_premium_plugin_get_license_status();

		if ( ( ! empty( $license ) && ! empty( $license_status ) && 'valid' === $license_status ) ) {
			$success = update_option( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_LICENSE_OPTION_NAME, '' ) && update_option( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_LICENSE_STATUS_OPTION_NAME, 'invalid' );

			if ( $success ) {
				qi_addons_for_elementor_premium_get_ajax_status( 'success', esc_html__( 'Plugin deregistered.', 'qi-addons-for-elementor-premium' ), array() );
			} else {
				qi_addons_for_elementor_premium_get_ajax_status( 'error', esc_html__( 'Something went wrong', 'qi-addons-for-elementor-premium' ), array() );
			}
		} else {
			qi_addons_for_elementor_premium_get_ajax_status( 'success', esc_html__( 'Plugin is already deregistered', 'qi-addons-for-elementor-premium' ), array() );
		}
	}
}
