<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_framework_template_part' ) ) {
	/**
	 * Echo module template part.
	 *
	 * @param string $root path of root folder to start templating from
	 * @param string $module name of the module from inc folder
	 * @param string $template full path of the template to load
	 * @param string $slug
	 * @param array $params array of parameters to pass to template
	 *
	 */
	function qi_addons_for_elementor_premium_framework_template_part( $root, $module, $template, $slug = '', $params = array() ) {
		echo qi_addons_for_elementor_premium_framework_get_template_part( $root, $module, $template, $slug, $params );
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_framework_get_template_part' ) ) {
	/**
	 * Loads module template part.
	 *
	 * @param string $root path of root folder to start templating from
	 * @param string $module name of the module from inc folder
	 * @param string $template full path of the template to load
	 * @param string $slug
	 * @param array $params array of parameters to pass to template
	 *
	 * @return string - string containing html of template
	 */
	function qi_addons_for_elementor_premium_framework_get_template_part( $root, $module, $template, $slug = '', $params = array() ) {
		$available_characters = '/[^A-Za-z0-9\_\-\/]/';

		if ( is_scalar( $module ) ) {
			$module = preg_replace( $available_characters, '', $module );
		} else {
			$module = '';
		}

		if ( is_scalar( $template ) ) {
			$template = preg_replace( $available_characters, '', $template );
		} else {
			$template = '';
		}

		$temp = $root . '/' . $module . '/' . $template;

		$template = qi_addons_for_elementor_premium_framework_get_template_with_slug( $temp, $slug );

		return qi_addons_for_elementor_premium_framework_execute_template_with_params( $template, $params );
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_framework_list_sc_template_part' ) ) {
	/**
	 * Echo module template part.
	 *
	 * @param string $root path of root folder to start templating from
	 * @param string $module name of the module from inc folder
	 * @param string $template full path of the template to load
	 * @param string $slug
	 * @param array $params array of parameters to pass to template
	 *
	 */
	function qi_addons_for_elementor_premium_framework_list_sc_template_part( $root, $module, $template, $slug = '', $params = array() ) {
		echo qi_addons_for_elementor_premium_framework_get_list_sc_template_part( $root, $module, $template, $slug, $params );
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_framework_get_list_sc_template_part' ) ) {
	/**
	 * Echo module template part.
	 *
	 * @param string $root path of root folder to start templating from
	 * @param string $module name of the module from inc folder
	 * @param string $template full path of the template to load
	 * @param string $slug
	 * @param array $params array of parameters to pass to template
	 *
	 * @return string - string containing html of template
	 */
	function qi_addons_for_elementor_premium_framework_get_list_sc_template_part( $root, $module, $template, $slug = '', $params = array() ) {
		$temp_in_variation = false;

		/* In order to use this way of templating, option for list item layout must be called layoyt */
		if ( isset( $params['layout'] ) ) {
			/* Check if folder for variation exists */
			$variation_path = apply_filters( 'qi_addons_for_elementor_premium_filter_framework_list_sc_layout_path', $root . '/' . $module . '/variations/' . $params['layout'], $params );
			if ( file_exists( $variation_path ) ) {
				/* Check if template file in variation folder exists */
				$temp_file = qi_addons_for_elementor_premium_framework_get_template_with_slug( $variation_path . '/' . $template, $slug );

				if ( ! empty( $temp_file ) && file_exists( $temp_file ) ) {
					$template          = $temp_file;
					$temp_in_variation = true;
				}
			}
		}

		/* Template doesn't exist in variation folder, use default one */
		if ( ! $temp_in_variation ) {
			$temp     = $root . '/' . $module . '/templates/' . $template;
			$template = qi_addons_for_elementor_premium_framework_get_template_with_slug( $temp, $slug );
		}

		return qi_addons_for_elementor_premium_framework_execute_template_with_params( $template, $params );
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_framework_get_template_with_slug' ) ) {
	/**
	 * Loads module template part.
	 *
	 * @param string $temp temp path to file that is being loaded
	 * @param string $slug slug that should be checked if exists
	 *
	 * @return string - string with template path
	 */
	function qi_addons_for_elementor_premium_framework_get_template_with_slug( $temp, $slug ) {
		$template = '';

		if ( ! empty( $temp ) ) {
			if ( ! empty( $slug ) ) {
				$template = "{$temp}-{$slug}.php";

				if ( ! file_exists( $template ) ) {
					$template = $temp . '.php';
				}
			} else {
				$template = $temp . '.php';
			}
		}

		return $template;
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_framework_execute_template_with_params' ) ) {
	/**
	 * Loads module template part.
	 *
	 * @param string $template path to template that is going to be included
	 * @param array $params params that are passed to template
	 *
	 * @return string - template html
	 */
	function qi_addons_for_elementor_premium_framework_execute_template_with_params( $template, $params ) {
		if ( ! empty( $template ) && file_exists( $template ) ) {
			//Extract params so they could be used in template
			if ( is_array( $params ) && count( $params ) ) {
				extract( $params, EXTR_SKIP ); // @codingStandardsIgnoreLine
			}

			ob_start();
			include( $template );
			$html = ob_get_clean();

			return $html;
		} else {
			return '';
		}
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_framework_is_installed' ) ) {
	/**
	 * Function check is some plugin/theme is installed
	 *
	 * @param string $plugin name
	 *
	 * @return bool
	 */
	function qi_addons_for_elementor_premium_framework_is_installed( $plugin ) {
		switch ( $plugin ) :
			case 'elementor':
				return defined( 'ELEMENTOR_VERSION' );
			case 'woocommerce':
				return class_exists( 'WooCommerce' );
			case 'gravity_forms':
				return class_exists( 'GFForms' );
			case 'contact_form_7':
				return defined( 'WPCF7_VERSION' );
			case 'wp_forms':
				return defined( 'WPFORMS_VERSION' );
			case 'wpml':
				return defined( 'ICL_SITEPRESS_VERSION' );
			default:
				return apply_filters( 'qi_addons_for_elementor_premium_filter_framework_is_plugin_installed', false, $plugin );

		endswitch;
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_framework_call_shortcode' ) ) {
	/**
	 * @param      $base - shortcode base
	 * @param      $params - shortcode parameters
	 * @param null $content - shortcode content
	 *
	 * @return mixed|string
	 */
	function qi_addons_for_elementor_premium_framework_call_shortcode( $base, $params, $content = null ) {
		global $shortcode_tags;

		if ( ! isset( $shortcode_tags[ $base ] ) ) {
			return false;
		}

		if ( is_array( $shortcode_tags[ $base ] ) ) {
			$shortcode = $shortcode_tags[ $base ];

			return call_user_func(
				array(
					$shortcode[0],
					$shortcode[1],
				),
				$params,
				$content,
				$base
			);
		}

		return call_user_func( $shortcode_tags[ $base ], $params, $content, $base );
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_framework_map_shortcode_fields' ) ) {
	/**
	 * @param array $default_options - default supported options
	 * @param array $params - params set
	 *
	 * @return array - formatted array with merge default and passed options
	 */
	function qi_addons_for_elementor_premium_framework_map_shortcode_fields( $default_options, $params ) {
		$atts = (array) $params;
		$out  = array();

		foreach ( $default_options as $name => $default ) {
			if ( array_key_exists( $name, $atts ) ) {
				$out[ $name ] = $atts[ $name ];
			} else {
				$out[ $name ] = $default;
			}
		}

		return $out;
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_generate_stylesheet' ) ) {
	function qi_addons_for_elementor_premium_generate_stylesheet( $enabled_shortcodes ) {

		global $wp_filesystem;

		if ( empty( $wp_filesystem ) ) {
			require_once ABSPATH . '/wp-admin/includes/file.php';
			WP_Filesystem();
		}

		$main_file  = QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_PATH . '/css/main.min.css';
		$main_style = '';

		wp_delete_file( $main_file );

		if ( ! empty( $enabled_shortcodes ) ) {

			foreach ( $enabled_shortcodes as $slug => $file ) {

				$part = QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_PATH . '/css/parts/' . $file . '-default.min.css';

				$main_style .= $wp_filesystem->get_contents( $part );

			}
		}

		$wp_filesystem->put_contents( $main_file, $main_style, FS_CHMOD_FILE );
	}
	add_action( 'qi_addons_for_elementor_action_saved_widgets', 'qi_addons_for_elementor_premium_generate_stylesheet' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_remove_plugin_actions' ) ) {

	function qi_addons_for_elementor_premium_remove_plugin_actions( $links ) {

		if ( isset( $links['upgrade'] ) ) {
			unset( $links['upgrade'] );
		}

		return $links;
	}

	add_filter( 'qi_addons_for_elementor_filter_extend_plugin_actions', 'qi_addons_for_elementor_premium_remove_plugin_actions' );
}
