<?php


if ( ! function_exists( 'qi_addons_for_elementor_premium_add_integration_sub_page_to_list' ) ) {
	/**
	 * Function that add additional sub page item into general page list
	 *
	 * @param array $sub_pages
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_integration_sub_page_to_list( $sub_pages ) {

		$sub_pages[] = 'QiAddonsForElementorPremium_Admin_Page_Integration';

		return $sub_pages;
	}

	add_filter( 'qi_addons_for_elementor_filter_add_welcome_sub_page', 'qi_addons_for_elementor_premium_add_integration_sub_page_to_list' );
}

if ( class_exists( 'QiAddonsForElementor_Admin_Sub_Pages' ) ) {
	class QiAddonsForElementorPremium_Admin_Page_Integration extends QiAddonsForElementor_Admin_Sub_Pages {

		private $integration_services;

		public function __construct() {

			$this->integration_services = array(

				'google_maps'   => array(
					'title'       => esc_html__( 'Google Maps API Key', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'This is where you can input a Google Maps API key in order to use the Google Map custom widget you get with Qi Addons Premium.', 'qi-addons-for-elementor-premium' ),
					'fields'      => array(
						array(
							'field_name'        => 'google_maps_api_key',
							'field_type'        => 'text',
							'field_description' => '',
						),
					),
				),
				'yelp'          => array(
					'title'       => esc_html__( 'Business Reviews - Yelp API Key', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'Here you can input a Yelp Business Reviews API key in order to use the Business Reviews Yelp widget you get with Qi Addons Premium.', 'qi-addons-for-elementor-premium' ),
					'fields'      => array(
						array(
							'field_name'        => 'yelp_api_key',
							'field_type'        => 'text',
							'field_description' => '',
						),
					),
				),
				'google_places' => array(
					'title'       => esc_html__( 'Business Reviews - Google Places API Key', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'In this field you can input a Google Places API key in order to use the Business Reviews Google widget you get with Qi Addons Premium.', 'qi-addons-for-elementor-premium' ),
					'fields'      => array(
						array(
							'field_name'        => 'google_places_api_key',
							'field_type'        => 'text',
							'field_description' => '',
						),
					),
				),
			);

			parent::__construct();

			add_action(
				'qi_addons_for_elementor_action_additional_scripts',
				array(
					$this,
					'set_additional_scripts',
				)
			);

			add_action(
				'wp_ajax_qi_addons_for_elementor_premium_action_framework_save_options',
				array(
					$this,
					'save_form',
				)
			);

		}

		function add_sub_page() {
			$this->set_base( 'integration' );
			$this->set_menu_slug( 'qi_addons_for_elementor_premium_integration' );
			$this->set_title( esc_html__( 'Integration Page', 'qi-addons-for-elementor-premium' ) );
			$this->set_position( 4 );
			$this->set_atts( $this->set_atributtes() );
		}

		function set_atributtes() {

			$atts = array(
				'integration_services' => $this->integration_services,
				'api_key_values'       => $this->get_api_keys(),
			);

			return $atts;
		}

		function set_additional_scripts() {
			if ( isset( $_GET['page'] ) && $_GET['page'] === $this->get_menu_slug() ) {
				wp_enqueue_script( 'qodef-qi-addos-for-elementor-premium-integration', QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ADMIN_URL_PATH . '/inc/admin-pages/integration/assets/js/integration.js', array( 'jquery' ) );
				wp_enqueue_style( 'qodef-qi-addos-for-elementor-premium-integration', QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ADMIN_URL_PATH . '/inc/admin-pages/integration/assets/css/integration.css' );
			}
		}

		function get_content() {
			qi_addons_for_elementor_framework_template_part( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ADMIN_PATH . '/inc/admin-pages', $this->get_base(), 'templates/' . $this->get_base(), '', $this->get_atts() );
		}

		function get_api_keys() {

			$api_keys = get_option( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_INTEGRATION_KEYS );

			if ( false === $api_keys ) {
				return array();
			}

			return $api_keys;
		}

		function save_form() {

			if ( current_user_can( 'edit_theme_options' ) ) {

				$_REQUEST = stripslashes_deep( $_REQUEST );
				unset( $_REQUEST['action'] );
				check_ajax_referer( 'qi_addons_for_elementor_premium_integration_ajax_save_nonce', 'qi_addons_for_elementor_premium_integration_ajax_save_nonce' );

				$finall_values = array();

				if ( is_array( $this->integration_services ) && count( $this->integration_services ) > 0 ) {

					foreach ( $this->integration_services as $service ) {

						if ( isset( $service['fields'] ) ) {
							foreach ( $service['fields'] as $field ) {
								$finall_values[ $field['field_name'] ] = $_REQUEST[ $field['field_name'] ];
							}
						}
					}
				}

				$results = update_option( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_INTEGRATION_KEYS, $finall_values );

				do_action( 'qi_addons_for_elementor_premium_action_saved_integration_keys', $results );

				if ( $results ) {
					esc_html_e( 'Saved', 'qi-addons-for-elementor-premium' );
				}

				die();
			}
		}
	}
}

