<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_blog_list_premium_shortcode' ) ) {
	/**
	 * Function that isadding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_blog_list_premium_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Blog_List_Premium_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_blog_list_premium_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_List_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Blog_List_Premium_Shortcode extends QiAddonsForElementor_List_Shortcode {

		public function __construct() {
			$this->set_post_type( 'post' );
			$this->set_post_type_taxonomy( 'category' );
			$this->set_post_type_additional_taxonomies( array( 'post_tag' ) );
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_blog_list_premium_extra_options', array(), $this ) );
			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_INC_URL_PATH . '/blog/shortcodes/blog-list-premium' );
			$this->set_base( 'qi_addons_for_elementor_premium_blog_list_premium' );
			$this->set_name( esc_html__( 'Blog List Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays list of blog posts', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Business', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/blog-list-premium/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#05_blog_list_premium' );
			$this->set_scripts(
				apply_filters(
					'qi_addons_for_elementor_premium_filter_blog_list_premium_register_scripts',
					array(
						'fslightbox' => array(
							'registered' => true,
						),
					)
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_same_height_items',
					'title'         => esc_html__( 'Enable Same Height Items', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'If same height enabled, the highest item height will be set on all items', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'hidden',
					'name'          => 'behavior',
					'title'         => esc_html__( 'Behavior', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'columns',
				)
			);
			$this->map_list_options(
				array(
					'exclude_behavior' => array( 'masonry' ),
					'include_option'   => array( 'pagination_type' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'choose',
					'name'          => 'alignment',
					'title'         => esc_html__( 'Content Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'responsive'    => true,
					'default_value' => 'center',
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->map_layout_options();
			$this->map_query_options();
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'title_hover_underline',
					'title'      => esc_html__( 'Title Hover Underline', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'boxed_items_indexes',
					'title'       => esc_html__( 'Boxed Items Indexes', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'Enter the indexes of the posts you would like to be in boxed layout, ex. 1, 3, 5', 'qi-addons-for-elementor-premium' ),
					'group'       => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'double_width_items_indexes',
					'title'       => esc_html__( 'Double Width Items Indexes', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'Enter the indexes of the posts you wolud like to be double width, ex. 1, 3, 5', 'qi-addons-for-elementor-premium' ),
					'group'       => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'show_info_icons',
					'title'      => esc_html__( 'Show Info Icons', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no' ),
					'group'      => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'show_date',
					'title'      => esc_html__( 'Show Date', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no' ),
					'group'      => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'show_category',
					'title'      => esc_html__( 'Show Category', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no' ),
					'group'      => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'show_author',
					'title'      => esc_html__( 'Show Author', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no' ),
					'group'      => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'info_color',
					'title'      => esc_html__( 'Info Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item:not(.qodef-item--boxed) .qodef-e-info-item' => 'color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'info_hover_color',
					'title'      => esc_html__( 'Info Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item:not(.qodef-item--boxed) .qodef-e-info-item a:hover' => 'color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'info_typography',
					'title'      => esc_html__( 'Info Typography', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-blog-item .qodef-e-info-item',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'info_icons_color',
					'title'      => esc_html__( 'Info Icons Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item:not(.qodef-item--boxed) .qodef-e-info-item-icon' => 'color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'show_info_icons' => array(
								'values'        => array( 'yes' ),
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'image_hover',
					'title'      => esc_html__( 'Image Hover', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Image Style', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'zoom'     => esc_html__( 'Zoom In', 'qi-addons-for-elementor-premium' ),
						'zoom-out' => esc_html__( 'Zoom Out', 'qi-addons-for-elementor-premium' ),
						'move'     => esc_html__( 'Move', 'qi-addons-for-elementor-premium' ),
						''         => esc_html__( 'None', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'image_zoom_origin',
					'title'      => esc_html__( 'Image Hover Zoom Origin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Image Style', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						''       => esc_html__( 'Center', 'qi-addons-for-elementor-premium' ),
						'top'    => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
						'bottom' => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
						'left'   => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'right'  => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
					),
					'dependency' => array(
						'show' => array(
							'image_hover' => array(
								'values'        => array( 'zoom', 'zoom-out' ),
								'default_value' => 'zoom',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'overlay_color',
					'title'      => esc_html__( 'Overlay Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Image Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-media-image a:after' => 'background-color: {{VALUE}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'overlay_hover_color',
					'title'      => esc_html__( 'Overlay Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Image Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e:hover .qodef-e-media-image a:after' => 'background-color: {{VALUE}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'image_margin_bottom',
					'title'      => esc_html__( 'Image Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Layout Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item .qodef-e-media-image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_margin_bottom',
					'title'      => esc_html__( 'Title Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Layout Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item:not(.qodef-item--boxed) .qodef-e-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'content_padding',
					'title'      => esc_html__( 'Regular Content Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item:not(.qodef-item--boxed) .qodef-e-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Layout Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'boxed_title_margin_bottom',
					'title'      => esc_html__( 'Boxed Title Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Layout Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item.qodef-item--boxed .qodef-e-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'boxed_padding',
					'title'      => esc_html__( 'Boxed Item Padding', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Layout Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item.qodef-item--boxed .qodef-e-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'boxed_background_color',
					'title'      => esc_html__( 'Boxed Background Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Boxed Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item.qodef-item--boxed .qodef-e-inner' => 'background-color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'boxed_title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Boxed Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item.qodef-item--boxed .qodef-e-title' => 'color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'boxed_title_hover_color',
					'title'      => esc_html__( 'Title Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Boxed Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item.qodef-item--boxed .qodef-e-title a:hover' => 'color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'boxed_info_color',
					'title'      => esc_html__( 'Info Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Boxed Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item.qodef-item--boxed .qodef-e-info-item' => 'color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'boxed_info_hover_color',
					'title'      => esc_html__( 'Info Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Boxed Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item.qodef-item--boxed .qodef-e-info-item a:hover' => 'color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'boxed_info_icons_color',
					'title'      => esc_html__( 'Info Icons Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Boxed Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-blog-item.qodef-item--boxed .qodef-e-info-item-icon' => 'color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'show_info_icons' => array(
								'values'        => array( 'yes' ),
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qi_addons_for_elementor_framework_call_shortcode( 'qi_addons_for_elementor_premium_blog_list_premium', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function load_assets() {
			parent::load_assets();

			wp_enqueue_style( 'fslightbox' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['post_type'] = $this->get_post_type();

			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );

			$atts['holder_classes']             = $this->get_holder_classes( $atts );
			$atts['boxed_items_indexes']        = explode( ',', $atts['boxed_items_indexes'] );
			$atts['double_width_items_indexes'] = explode( ',', $atts['double_width_items_indexes'] );
			$atts['query_result']               = new \WP_Query( qi_addons_for_elementor_get_query_params( $atts ) );
			$atts['this_shortcode']             = $this;
			$atts['behavior']                   = 'masonry'; //it needs to be set after get_holder_classes so it doesn't trigger default masonry behavior
			$atts['data_attr']                  = array();

			if ( isset( $atts['pagination_type'] ) && in_array( $atts['pagination_type'], array( 'standard', 'load-more', 'infinite-scroll' ), true ) ) {
				$atts['data_attr']['data-options'] = qi_addons_for_elementor_premium_get_pagination_data( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_REL_PATH, 'blog/shortcodes', 'blog-list-premium', 'post', $atts );
			}

			return qi_addons_for_elementor_premium_get_template_part( 'blog/shortcodes/blog-list-premium', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-blog-list-premium';
			$holder_classes[] = 'qodef--list';

			$holder_classes[] = ( 'yes' === $atts['enable_same_height_items'] ) ? 'qodef--same-height' : '';
			$holder_classes[] = ( 'yes' !== $atts['show_info_icons'] ) ? 'qodef-info-no-icons' : '';
			$holder_classes[] = 'yes' === $atts['title_hover_underline'] ? 'qodef-title--hover-underline' : '';
			$holder_classes[] = ! empty( $atts['image_hover'] ) ? 'qodef-image--hover-' . $atts['image_hover'] : '';
			$holder_classes[] = ! empty( $atts['image_zoom_origin'] ) ? 'qodef-image--hover-from-' . $atts['image_zoom_origin'] : '';
			$holder_classes[] = ! empty( $atts['alignment'] ) ? 'qodef-alignment--' . $atts['alignment'] : '';

			$list_classes   = $this->get_list_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $list_classes );

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts, $index ) {
			$item_classes      = $this->init_item_classes();
			$item_classes[]    = 'qodef-blog-item';
			$item_classes[]    = ( in_array( $index, $atts['double_width_items_indexes'] ) ) ? 'qodef-item--double' : '';
			$item_classes[]    = ( in_array( $index, $atts['boxed_items_indexes'] ) ) ? 'qodef-item--boxed' : '';
			$list_item_classes = $this->get_list_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_blog_list_premium_additional_pagination_params' ) ) {
	function qi_addons_for_elementor_premium_blog_list_premium_additional_pagination_params( $options ) {

		if ( 'blog-list-premium' === $options['shortcode'] ) {
			$options['behavior']                   = 'masonry';
			$options['boxed_items_indexes']        = explode( ',', $options['boxed_items_indexes'] );
			$options['double_width_items_indexes'] = explode( ',', $options['double_width_items_indexes'] );
		}

		return $options;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_pagination_params', 'qi_addons_for_elementor_premium_blog_list_premium_additional_pagination_params' );
}
