<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_blog_list_variation_side_date_premium' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_blog_list_variation_side_date_premium( $variations ) {
		$variations['side-date-premium'] = esc_html__( 'Side Date Premium', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_filter_blog_list_layouts', 'qi_addons_for_elementor_premium_add_blog_list_variation_side_date_premium', 15 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_blog_list_side_date_premium_hide_options' ) ) {
	/**
	 * Function that adds layout on filter that hides excerpt options
	 *
	 * @param array $layouts
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_blog_list_side_date_premium_hide_options( $layouts ) {
		$layouts['side-date-premium'] = 'side-date-premium';

		return $layouts;
	}

	add_filter( 'qi_addons_for_elementor_filter_blog_list_layout_hide_media', 'qi_addons_for_elementor_premium_add_blog_list_side_date_premium_hide_options' );
	add_filter( 'qi_addons_for_elementor_filter_blog_list_layout_hide_date', 'qi_addons_for_elementor_premium_add_blog_list_side_date_premium_hide_options' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_blog_list_options_side_date_premium' ) ) {
	function qi_addons_for_elementor_premium_add_blog_list_options_side_date_premium( $options ) {
		$side_date_options = array();

		$day_color = array(
			'field_type' => 'color',
			'name'       => 'day_color',
			'title'      => esc_html__( 'Day Color', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Date Style', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-blog-item .qodef-e-info-day' => 'color: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
		);

		$day_hover_color = array(
			'field_type' => 'color',
			'name'       => 'day_hover_color',
			'title'      => esc_html__( 'Day Hover Color', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Date Style', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-blog-item .qodef-e-info-day:hover' => 'color: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
		);

		$day_typography = array(
			'field_type' => 'typography',
			'name'       => 'day_typography',
			'title'      => esc_html__( 'Day Typography', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Date Style', 'qi-addons-for-elementor-premium' ),
			'selector'   => '{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-blog-item .qodef-e-info-day',
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
		);

		$month_year_color = array(
			'field_type' => 'color',
			'name'       => 'month_year_color',
			'title'      => esc_html__( 'Month/Year Color', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Date Style', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-blog-item .qodef-e-info-month-year' => 'color: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
		);

		$month_year_hover_color = array(
			'field_type' => 'color',
			'name'       => 'month_year_hover_color',
			'title'      => esc_html__( 'Month/Year Hover Color', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Date Style', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-blog-item .qodef-e-info-month-year:hover' => 'color: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
		);

		$month_year_typography = array(
			'field_type' => 'typography',
			'name'       => 'month_year_typography',
			'title'      => esc_html__( 'Month/Year Typography', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Date Style', 'qi-addons-for-elementor-premium' ),
			'selector'   => '{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-blog-item .qodef-e-info-month-year',
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
		);

		$content_margin_right = array(
			'field_type' => 'slider',
			'name'       => 'content_padding_right',
			'title'      => esc_html__( 'Content Padding Right', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Layout Spacing Style', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-blog-item .qodef-e-right' => 'padding-right: {{SIZE}}{{UNIT}};',
			),
		);

		$button_margin_top = array(
			'field_type' => 'slider',
			'name'       => 'button_margin_top',
			'title'      => esc_html__( 'Button Margin Top', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Layout Spacing Style', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-blog-item .qodef-e-info.qodef-info--bottom' => 'margin-top: {{SIZE}}{{UNIT}};',
			),
		);

		$date_margin = array(
			'field_type' => 'dimensions',
			'name'       => 'date_margin',
			'title'      => esc_html__( 'Date Margin', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Layout Spacing Style', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-blog-item .qodef-e-left' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			),
		);

		$date_min_width = array(
			'field_type' => 'slider',
			'name'       => 'date_min_width',
			'title'      => esc_html__( 'Date Min Width', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Layout Spacing Style', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-blog-item .qodef-e-left' => 'min-width: {{SIZE}}{{UNIT}};',
			),
		);

		$padding_bottom = array(
			'field_type' => 'slider',
			'name'       => 'side_date_item_padding_bottom',
			'title'      => esc_html__( 'Item Padding Top', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-e-inner'    => 'padding-bottom: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-grid-inner' => 'margin-bottom: -{{SIZE}}{{UNIT}} !important;',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Layout Spacing Style', 'qi-addons-for-elementor-premium' ),
		);

		$border_bottom_color = array(
			'field_type' => 'color',
			'name'       => 'side_date_border_bottom_color',
			'title'      => esc_html__( 'Border Color', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-e-inner' => 'border-color: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
		);

		$border_bottom_thickness = array(
			'field_type' => 'slider',
			'name'       => 'side_date_border_bottom_thickness',
			'title'      => esc_html__( 'Border Top Thickness', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-e-inner' => 'border-bottom-width: {{SIZE}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
		);

		$border_bottom_style = array(
			'field_type' => 'select',
			'name'       => 'side_date_border_bottom_type',
			'title'      => esc_html__( 'Border Top Style', 'qi-addons-for-elementor-premium' ),
			'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'border_style' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--side-date-premium .qodef-e-inner' => 'border-bottom-style: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'side-date-premium',
						'default_value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
		);

		$side_date_options[] = $day_color;
		$side_date_options[] = $day_hover_color;
		$side_date_options[] = $day_typography;
		$side_date_options[] = $month_year_color;
		$side_date_options[] = $month_year_hover_color;
		$side_date_options[] = $month_year_typography;
		$side_date_options[] = $date_margin;
		$side_date_options[] = $date_min_width;
		$side_date_options[] = $padding_bottom;
		$side_date_options[] = $border_bottom_color;
		$side_date_options[] = $border_bottom_thickness;
		$side_date_options[] = $border_bottom_style;
		$side_date_options[] = $content_margin_right;
		$side_date_options[] = $button_margin_top;

		return array_merge( $options, $side_date_options );
	}

	add_filter( 'qi_addons_for_elementor_filter_blog_list_extra_options', 'qi_addons_for_elementor_premium_add_blog_list_options_side_date_premium' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_blog_list_render' ) ) {
	function qi_addons_for_elementor_premium_blog_list_render( $template, $layout, $post_format, $params ) {
		if ( 'side-date-premium' === $layout ) {
			return qi_addons_for_elementor_premium_get_list_sc_template_part( 'blog/shortcodes/blog-list', 'layouts/' . $layout, get_post_format(), $params );
		} else {
			return $template;
		}
	}

	add_filter( 'qi_addons_for_elementor_filter_blog_list_sc_layout_path', 'qi_addons_for_elementor_premium_blog_list_render', 10, 4 );
}
