<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_pagination_additional_for_list' ) ) {

	function qi_addons_for_elementor_premium_add_pagination_additional_for_list( $object, $group, $include_option ) {

		if ( in_array( 'pagination_type', $include_option, true ) ) {
			$object->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'pagination_type',
					'title'         => esc_html__( 'Pagination', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'no-pagination'   => esc_html__( 'No Pagination', 'qi-addons-for-elementor-premium' ),
						'wp-standard'     => esc_html__( 'Standard WordPress', 'qi-addons-for-elementor-premium' ),
						'standard'        => esc_html__( 'Standard', 'qi-addons-for-elementor-premium' ),
						'load-more'       => esc_html__( 'Load More', 'qi-addons-for-elementor-premium' ),
						'infinite-scroll' => esc_html__( 'Infinite', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'wp-standard',
					'dependency'    => array(
						'show' => array(
							'enable_pagination' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'         => esc_html__( 'Pagination', 'qi-addons-for-elementor-premium' ),
				)
			);

			$object->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'load_more_button_typography',
					'title'      => esc_html__( 'Typography', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-load-more-button.qodef-qi-button',
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);
			$object->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'load_more_button_style_tabs',
					'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);

			$object->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'load_more_button_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);
			$object->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'load_more_button_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-load-more-button.qodef-qi-button' => 'color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);
			$object->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'load_more_button_background_color',
					'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-load-more-button.qodef-qi-button.qodef-layout--filled' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);
			$object->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'load_more_button_border_color',
					'title'      => esc_html__( 'Border Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-load-more-button.qodef-qi-button' => 'border-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);

			$object->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'load_more_button_tab_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);
			$object->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'load_more_button_tab_hover',
					'title'      => esc_html__( 'Hover', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);
			$object->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'load_more_button_hover_color',
					'title'      => esc_html__( 'Text Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-load-more-button.qodef-qi-button:hover' => 'color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);
			$object->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'load_more_button_hover_background_color',
					'title'      => esc_html__( 'Background Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-load-more-button.qodef-qi-button.qodef-html--link.qodef-layout--filled:hover'   => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => '',
							),
						),
					),
				)
			);
			$object->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'load_more_button_hover_border_color',
					'title'      => esc_html__( 'Border Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-load-more-button.qodef-qi-button:hover' => 'border-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => '',
							),
						),
					),
				)
			);

			$object->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'load_more_button_tab_hover_end',
					'title'      => esc_html__( 'Hover End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);
			$object->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'load_more_button_style_tabs_end',
					'title'      => esc_html__( 'Tabs End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);

			$object->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_load_more_button_tab_style',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);

			$object->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'load_more_button_border_width',
					'title'      => esc_html__( 'Border Width', 'qi-addons-for-elementor-premium' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-load-more-button.qodef-qi-button' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
					),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);
			$object->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'load_more_button_border_radius',
					'title'      => esc_html__( 'Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-load-more-button.qodef-qi-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);
			$object->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'load_more_button_padding',
					'title'      => esc_html__( 'Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-load-more-button.qodef-qi-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Pagination Load More Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'pagination_type' => array(
								'values'        => 'load-more',
								'default_value' => 'wp-standard',
							),
						),
					),
				)
			);
		}
	}

	add_action( 'qi_addons_for_elementor_action_map_additional_options', 'qi_addons_for_elementor_premium_add_pagination_additional_for_list', 15, 3 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_list_pagination_classes' ) ) {
	function qi_addons_for_elementor_premium_list_pagination_classes( $holder_classes, $params ) {

		if ( isset( $params['pagination_type'] ) && in_array( $params['pagination_type'], array( 'standard', 'load-more', 'infinite-scroll' ), true ) ) {
			$holder_classes[] = 'qodef-qi-pagination--on';
			$holder_classes[] = 'qodef-pagination-type--' . $params['pagination_type'];
		}

		return $holder_classes;
	}

	add_filter( 'qi_addons_for_elementor_filter_list_classes', 'qi_addons_for_elementor_premium_list_pagination_classes', 10, 2 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_list_pagination_template' ) ) {
	function qi_addons_for_elementor_premium_list_pagination_template( $pagination, $params ) {
		if ( isset( $params['pagination_type'] ) && 'wp-standard' !== $params['pagination_type'] ) {
			// Include global pagination from plugin
			$pagination = qi_addons_for_elementor_premium_get_template_part( 'pagination', 'templates/pagination', $params['pagination_type'], $params );
		}

		return $pagination;
	}

	add_filter( 'qi_addons_for_elementor_filter_list_pagination', 'qi_addons_for_elementor_premium_list_pagination_template', 10, 2 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_rest_api_pagination_global_variables' ) ) {
	/**
	 * Extend main rest api variables with new case
	 *
	 * @param array $global - list of variables
	 * @param string $namespace - rest namespace url
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_rest_api_pagination_global_variables( $global, $namespace ) {
		$global['paginationRestRoute'] = $namespace . '/get-posts';

		return $global;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_rest_api_global_variables', 'qi_addons_for_elementor_premium_add_rest_api_pagination_global_variables', 10, 2 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_rest_api_pagination_route' ) ) {
	/**
	 * Extend main rest api routes with new case
	 *
	 * @param array $routes - list of rest routes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_rest_api_pagination_route( $routes ) {
		$routes['pagination'] = array(
			'route'    => 'get-posts',
			'methods'  => WP_REST_Server::READABLE,
			'callback' => 'qi_addons_for_elementor_premium_get_new_posts',
			'args'     => array(
				'options' => array(
					'required'          => true,
					'validate_callback' => function ( $param, $request, $key ) {
						// Simple solution for validation can be 'is_array' value instead of callback function
						return is_array( $param ) ? $param : (array) $param;
					},
					'description'       => esc_html__( 'Options data is array with all selected shortcode parameters value', 'qi-addons-for-elementor-premium' ),
				),
			),
		);

		return $routes;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_rest_api_routes', 'qi_addons_for_elementor_premium_add_rest_api_pagination_route' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_get_new_posts' ) ) {
	/**
	 * Function that load new posts for pagination functionality
	 *
	 * @return void
	 */
	function qi_addons_for_elementor_premium_get_new_posts() {

		if ( ! isset( $_GET ) || empty( $_GET ) ) {
			qi_addons_for_elementor_premium_get_ajax_status( 'error', esc_html__( 'Get method is invalid', 'qi-addons-for-elementor-premium' ) );
		} else {
			$options = isset( $_GET['options'] ) ? (array) $_GET['options'] : array();

			if ( ! empty( $options ) ) {
				$plugin     = $options['plugin'];
				$module     = $options['module'];
				$shortcode  = $options['shortcode'];
				$options    = array_merge( $options, qi_addons_for_elementor_premium_get_widget_params( $options['shortcode_class'], $options['page_id'], $options['element_id'] ) );
				$query_args = qi_addons_for_elementor_premium_get_query_params( $options );

				$options['query_result'] = new \WP_Query( $query_args );
				if ( isset( $options['shortcode_class'] ) && ! empty( $options['shortcode_class'] ) && class_exists( $options['shortcode_class'] ) ) {
					$options['this_shortcode'] = new $options['shortcode_class'](); // needed for pagination loading items since object is not transferred via data params
				}

				ob_start();

				$get_template_part = $plugin . '_get_template_part';

				$options = apply_filters( 'qi_addons_for_elementor_premium_filter_pagination_params', $options );

				if ( 'masonry' === $options['behavior'] && 'standard' === $options['pagination_type'] ) {
					qi_addons_for_elementor_template_part( 'masonry', 'templates/sizer-gutter', '', $options['behavior'] );
				}

				// Variable name is function name - escaped no need
				echo apply_filters( "qi_addons_for_elementor_premium_filter_{$get_template_part}", $get_template_part( $module . '/' . $shortcode, 'templates/loop', '', $options ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

				$html = ob_get_contents();

				ob_end_clean();

				$pagination_html = '';
				if ( 'standard' === $options['pagination_type'] ) {
					$pagination_html = apply_filters( "qi_addons_for_elementor_premium_filter_{$get_template_part}_pagination", qi_addons_for_elementor_premium_get_template_part( 'pagination', 'templates/pagination', $options['pagination_type'], $options ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				}

				$data = apply_filters(
					'qi_addons_for_elementor_premium_filter_pagination_data_return',
					array(
						'html'            => $html,
						'max_pages_num'   => $options['query_result']->max_num_pages,
						'pagination_html' => $pagination_html,
					),
					$options
				);

				qi_addons_for_elementor_premium_get_ajax_status( 'success', esc_html__( 'Items are loaded', 'qi-addons-for-elementor-premium' ), $data );
			} else {
				qi_addons_for_elementor_premium_get_ajax_status( 'error', esc_html__( 'Options are invalid', 'qi-addons-for-elementor-premium' ) );
			}
		}
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_get_query_params' ) ) {
	/**
	 * Function that return query parameters
	 *
	 * @param array $params - options value
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_get_query_params( $params ) {
		$post_type      = isset( $params['post_type'] ) && ! empty( $params['post_type'] ) ? $params['post_type'] : 'post';
		$posts_per_page = isset( $params['posts_per_page'] ) && ! empty( $params['posts_per_page'] ) ? $params['posts_per_page'] : 12;

		$args = array(
			'post_status'         => 'publish',
			'post_type'           => esc_attr( $post_type ),
			'posts_per_page'      => $posts_per_page,
			'orderby'             => esc_attr( $params['orderby'] ),
			'order'               => esc_attr( $params['order'] ),
			'ignore_sticky_posts' => 1,
		);

		if ( isset( $params['next_page'] ) && ! empty( $params['next_page'] ) ) {
			$args['paged'] = intval( $params['next_page'] );
		} elseif ( ! empty( max( 1, get_query_var( 'paged' ) ) ) ) {
			$args['paged'] = max( 1, get_query_var( 'paged' ) );

			// Additional conditional for archives pages to prevent widgets element to change paged value
			if ( isset( $params['is_widget_element'] ) && 'yes' === $params['is_widget_element'] ) {
				$args['paged'] = 1;
			}
		} else {
			$args['paged'] = 1;
		}

		if ( isset( $params['additional_query_args'] ) && ! empty( $params['additional_query_args'] ) ) {
			foreach ( $params['additional_query_args'] as $key => $value ) {
				$args[ esc_attr( $key ) ] = $value;
			}
		}

		return apply_filters( 'qi_addons_for_elementor_premium_filter_query_params', $args, $params );
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_get_pagination_data' ) ) {
	/**
	 * Function that return pagination data
	 *
	 * @param string $plugin - plugin name
	 * @param string $module - module name
	 * @param string $shortcode - shortcode name
	 * @param string $post_type - post type value
	 * @param array $params - shortcode params
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_get_pagination_data( $plugin, $module, $shortcode, $post_type, $params ) {
		$data = array();

		if ( ! empty( $post_type ) && ! empty( $params ) ) {
			$additional_params = array(
				'plugin'          => str_replace( '-', '_', esc_attr( $plugin ) ),
				'module'          => esc_attr( $module ),
				'shortcode'       => esc_attr( $shortcode ),
				'shortcode_class' => esc_attr( $params['object_class_name'] ),
				'post_type'       => esc_attr( $post_type ),
				'next_page'       => '2',
				'max_pages_num'   => $params['query_result']->max_num_pages,
				'page_id'         => get_the_ID(),
			);

			$data = json_encode( $additional_params );
		}

		return $data;
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_get_widget_params' ) ) {
	function qi_addons_for_elementor_premium_get_widget_params( $shortcode_class, $page_id, $widget_id ) {
		$current_elementor_page = get_post_meta( $page_id, '_elementor_data', true );
		$content                = json_decode( $current_elementor_page );

		if ( is_array( $content ) && count( $content ) ) {
			foreach ( $content as $section ) {
				foreach ( $section->elements as $column ) {
					foreach ( $column->elements as $item ) {
						if ( 'widget' === $item->elType && $item->id == $widget_id ) {
							return qi_addons_for_elementor_premium_formated_shortcode_options( $shortcode_class, $item->settings );
						} elseif ( 'section' === $item->elType ) {
							foreach ( $item->elements as $inner_column ) {
								foreach ( $inner_column->elements as $inner_item ) {
									if ( 'widget' === $inner_item->elType && $inner_item->id == $widget_id ) {
										return qi_addons_for_elementor_premium_formated_shortcode_options( $shortcode_class, $inner_item->settings );
									}
								}
							}
						}
					}
				}
			}
		}

		return array();
	}
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_formated_shortcode_options' ) ) {
	function qi_addons_for_elementor_premium_formated_shortcode_options( $shortcode_class, $object_params ) {
		$formatted_options = array();

		foreach ( $object_params as $key => $param ) {
			if ( is_object( $param ) ) {
				$temp_param = array();

				foreach ( $param as $sub_key => $sub_param ) {
					$temp_param[ $sub_key ] = $sub_param;
				}
				$formatted_options[ $key ] = $temp_param;
			} else {
				$formatted_options[ $key ] = $param;
			}
		}

		$shortcode_object = new $shortcode_class;

		$default_options = array();

		foreach ( $shortcode_object->get_options() as $name => $option ) {
			$default_value = isset( $option['default_value'] ) ? $option['default_value'] : '';

			if ( isset( $option['hide_from_atts'] ) && true === $option['hide_from_atts'] ) {
				continue;
			}

			$default_options[ $name ] = $default_value;

			//map_responsive option should be set to true if responsive option are needed in shortcode rendering (see in class-qiaddonsforelementor-slider-shortcode.php line 353)
			if ( isset( $option['map_responsive'] ) && true === $option['map_responsive'] && isset( $option['responsive'] ) && true === $option['responsive'] ) {
				$default_options[ $name . '_tablet' ] = $default_value;
				$default_options[ $name . '_mobile' ] = $default_value;
			}
		}

		return qi_addons_for_elementor_framework_map_shortcode_fields( $default_options, $formatted_options );
	}
}
