<?php

if ( ! class_exists( 'QiAddonsForElementorPremium_Gravity_Forms' ) ) {
	class QiAddonsForElementorPremium_Gravity_Forms {
		private static $instance;

		public function __construct() {

			if ( qi_addons_for_elementor_premium_framework_is_installed( 'gravity_forms' ) ) {
				// Include files
				$this->include_files();
			}
		}

		/**
		 * @return QiAddonsForElementorPremium_Gravity_Forms
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		function include_files() {

			// Include helper functions
			include_once QI_ADDONS_FOR_ELEMENTOR_PREMIUM_PLUGINS_PATH . '/gravity-forms/helper.php';

			// Include shortcodes
			add_action(
				'qi_addons_for_elementor_action_framework_before_shortcodes_register',
				array(
					$this,
					'include_shortcodes',
				)
			);
		}

		function include_shortcodes() {
			foreach ( glob( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_PLUGINS_PATH . '/gravity-forms/shortcodes/*/include.php' ) as $shortcode ) {
				include_once $shortcode;
			}
		}
	}

	QiAddonsForElementorPremium_Gravity_Forms::get_instance();
}
