<?php
if ( ! function_exists( 'qi_addons_for_elementor_premium_get_gravity_forms' ) ) {
	/**
	 * Function that return array of gravity forms
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_get_gravity_forms() {
		$options       = array();
		$contact_forms = GFAPI::get_forms();

		if ( ! empty( $contact_forms ) ) {
			foreach ( $contact_forms as $contact_form ) {
				$options[ $contact_form['id'] ] = esc_html( $contact_form['title'] );
			}
		} else {
			$options[0] = esc_html__( 'No contact forms found', 'qi-addons-for-elementor-premium' );
		}

		return $options;
	}
}
