<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_gravity_forms_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_gravity_forms_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Gravity_Forms_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_gravity_forms_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Gravity_Forms_Shortcode extends QiAddonsForElementor_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_PLUGINS_URL_PATH . '/gravity-forms/shortcodes/gravity-forms' );
			$this->set_base( 'qi_addons_for_elementor_premium_gravity_forms' );
			$this->set_name( esc_html__( 'Gravity Forms', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays gravity forms with provided parameters', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Form Style', 'qi-addons-for-elementor-premium' ) );
//			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/contact-form-7/' );
//			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#7_contact_form_7' );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'gravity_form_id',
					'title'      => esc_html__( 'Choose Gravity Form', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_premium_get_gravity_forms(),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'show_title',
					'title'         => esc_html__( 'Show Title', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'show_description',
					'title'         => esc_html__( 'Show Description', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
				)
			);

			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'alignment',
					'title'      => esc_html__( 'Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'group'      => esc_html__( 'Global Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'column_gap',
					'title'      => esc_html__( 'Column Gap', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_wrapper .gform_fields' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Global Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'row_gap',
					'title'      => esc_html__( 'Row Gap', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_wrapper .gform_fields' => 'grid-row-gap: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Global Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'heading_title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gform_heading .gform_title',
					'group'      => esc_html__( 'Heading Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'heading_title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gform_heading .gform_title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Heading Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'heading_description_typography',
					'title'      => esc_html__( 'Description Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gform_heading .gform_description',
					'group'      => esc_html__( 'Heading Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'heading_description_color',
					'title'      => esc_html__( 'Description Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gform_heading .gform_description' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Heading Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'heading_title_margin_bottom',
					'title'      => esc_html__( 'Title Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_heading .gform_title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Heading Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'heading_legend_typography',
					'title'      => esc_html__( 'Legend Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gform_heading .gform_required_legend',
					'group'      => esc_html__( 'Heading Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'heading_legend_color',
					'title'      => esc_html__( 'Legend Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gform_heading .gform_required_legend' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Heading Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'heading_legend_margin_bottom',
					'title'      => esc_html__( 'Legend Margin Top', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_heading .gform_required_legend' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Heading Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'heading_margin_bottom',
					'title'      => esc_html__( 'Heading Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_heading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Heading Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'label_typography',
					'title'      => esc_html__( 'Label Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gfield_label',
					'group'      => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'label_color',
					'title'      => esc_html__( 'Label Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gfield_label' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'label_margin_bottom',
					'title'      => esc_html__( 'Label Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gfield_label' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'label_required_typography',
					'title'      => esc_html__( 'Required Label Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gfield_label .gfield_required',
					'group'      => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'label_required_color',
					'title'      => esc_html__( 'Required Label Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gfield_label .gfield_required' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'sublabel_typography',
					'title'      => esc_html__( 'Sublabel Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .ginput_complex label, {{WRAPPER}} .gfield_header_item, {{WRAPPER}} .ginput_product_price_label',
					'group'      => esc_html__( 'Sublabel Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'sublabel_color',
					'title'      => esc_html__( 'Sublabel Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .ginput_complex label' => 'color: {{VALUE}};',
						'{{WRAPPER}} .gfield_header_item' => 'color: {{VALUE}};',
						'{{WRAPPER}} .ginput_product_price_label' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Sublabel Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'sublabel_margin',
					'title'      => esc_html__( 'Sublabel Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .ginput_complex label' => 'margin-bottom: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .form_sublabel_below .ginput_complex label' => 'margin-top: {{SIZE}}{{UNIT}}; margin-bottom: 0;',
						'{{WRAPPER}} .gfield_list_header' => 'margin-bottom: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .ginput_product_price_label' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Sublabel Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'description_typography',
					'title'      => esc_html__( 'Description Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gfield_description:not(.validation_message)',
					'group'      => esc_html__( 'Description Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'description_color',
					'title'      => esc_html__( 'Description Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gfield_description:not(.validation_message)' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Description Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'description_margin',
					'title'      => esc_html__( 'Description Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gfield_description:not(.validation_message)' => 'padding-top: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .field_description_above .gfield_description' => 'padding-top: 0; padding-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Description Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'additional_typography',
					'title'      => esc_html__( 'Additional Info Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gform_fileupload_rules, {{WRAPPER}} .gfield_post_tags_hint, {{WRAPPER}} .ginput_container_post_image',
					'group'      => esc_html__( 'Additional Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'additional_info_color',
					'title'      => esc_html__( 'Additional Info Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} input[type=file]' => 'color: {{VALUE}};',
						'{{WRAPPER}} .gform_fileupload_rules' => 'color: {{VALUE}};',
						'{{WRAPPER}} .gfield_post_tags_hint' => 'color: {{VALUE}};',
						'{{WRAPPER}} .ginput_container_post_image' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Additional Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'additional_info_margin',
					'title'      => esc_html__( 'Additional Info Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_fileupload_rules' => 'padding-top: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .gfield_post_tags_hint' => 'margin-top: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .ginput_container_post_image input[type=file]' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Additional Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'cf7_style_tabs',
					'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'input_typography',
					'title'      => esc_html__( 'Input Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gform_fields input:not([type=submit]):not([type=file]), {{WRAPPER}} .gform_fields textarea, {{WRAPPER}} .gform_fields select',
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_color',
					'title'      => esc_html__( 'Input Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gform_fields input:not([type=submit]):not([type=file])' => 'color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields textarea' => 'color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields select' => 'color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields select option' => 'color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields input:not([type=submit])::placeholder' => 'color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields textarea::placeholder' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_background_color',
					'title'      => esc_html__( 'Input Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gform_fields input:not([type=submit])' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields textarea' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields select' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'border',
					'name'       => 'input_border',
					'title'      => esc_html__( 'Input Border', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gform_fields input:not([type=submit]),{{WRAPPER}} .gform_fields textarea, {{WRAPPER}} .gform_fields select',
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_tab_active',
					'title'      => esc_html__( 'Active', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'input_focus_typography',
					'title'      => esc_html__( 'Input Focus Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gform_fields input:not([type=submit]):focus, {{WRAPPER}} .gform_fields textarea:focus, {{WRAPPER}} .gform_fields select:focus',
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_focus_color',
					'title'      => esc_html__( 'Input Focus Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gform_fields input:not([type=submit]):focus' => 'color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields textarea:focus' => 'color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields select:focus'   => 'color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields select:focus option'   => 'color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields input:not([type=submit]):focus::placeholder' => 'color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields textarea:focus::placeholder' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_focus_background_color',
					'title'      => esc_html__( 'Input Focus Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gform_fields input:not([type=submit]):focus' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields textarea:focus' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .gform_fields select:focus'   => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'border',
					'name'       => 'input_focus_border',
					'title'      => esc_html__( 'Input Focus Border', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gform_fields input:not([type=submit]):focus,{{WRAPPER}} .gform_fields textarea:focus, {{WRAPPER}} .gform_fields select:focus',
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_tab_active_end',
					'title'      => esc_html__( 'Active End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'cf7_tabs_end',
					'title'      => esc_html__( 'Tabs End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'divider_border_radius',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'input_border_radius',
					'title'      => esc_html__( 'Input Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_fields input:not([type=submit])' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .gform_fields textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .gform_fields select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'input_padding',
					'title'      => esc_html__( 'Input Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_fields input:not([type=submit])' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .gform_fields textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .gform_fields select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'checkbox_label_typography',
					'title'      => esc_html__( 'Label Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gfield_checkbox label, {{WRAPPER}} .ginput_container_consent .gfield_consent_label',
					'group'      => esc_html__( 'Checkbox Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'checkbox_label_color',
					'title'      => esc_html__( 'Label Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gfield_checkbox label' => 'color: {{VALUE}};',
						'{{WRAPPER}} .ginput_container_consent .gfield_consent_label' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Checkbox Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'checkbox_size',
					'title'      => esc_html__( 'Checkbox Input Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_fields input[type=checkbox]' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Checkbox Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'checkbox_margin',
					'title'      => esc_html__( 'Checkbox Input Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Checkbox Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_fields input[type=checkbox]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'checkbox_space',
					'title'      => esc_html__( 'Checkbox Space Between', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gfield_checkbox .gchoice:not(:last-of-type)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Checkbox Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'checkbox_holder_margin',
					'title'      => esc_html__( 'Checkbox Holder Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Checkbox Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .ginput_container_checkbox' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .ginput_container_consent' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'checkbox_select_all_margin',
					'title'      => esc_html__( 'Select All Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gfield_checkbox button' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Checkbox Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'radio_label_typography',
					'title'      => esc_html__( 'Label Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gfield_radio label',
					'group'      => esc_html__( 'Radio Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'radio_label_color',
					'title'      => esc_html__( 'Label Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gfield_radio label' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Radio Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'radio_size',
					'title'      => esc_html__( 'Radio Input Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_fields input[type=radio]' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Radio Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'radio_margin',
					'title'      => esc_html__( 'Radio Input Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Radio Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_fields input[type=radio]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'radio_space',
					'title'      => esc_html__( 'Radio Space Between', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gfield_radio .gchoice:not(:last-of-type)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Radio Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'radio_holder_margin',
					'title'      => esc_html__( 'Radio Holder Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Radio Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .ginput_container_radio' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'button_typography',
					'title'      => esc_html__( 'Button Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} form input[type=button], {{WRAPPER}} form button',
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'cf7_button_style_tabs',
					'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_button_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_color',
					'title'      => esc_html__( 'Button Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=button]' => 'color: {{VALUE}};',
						'{{WRAPPER}} form button' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_background_color',
					'title'      => esc_html__( 'Button Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=button]' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} form button' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_border_color',
					'title'      => esc_html__( 'Button Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=button]' => 'border-color: {{VALUE}};',
						'{{WRAPPER}} form button' => 'border-color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_button_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_button_tab_active',
					'title'      => esc_html__( 'Active', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_hover_color',
					'title'      => esc_html__( 'Button Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=button]:hover' => 'color: {{VALUE}};',
						'{{WRAPPER}} form button:hover' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_hover_background_color',
					'title'      => esc_html__( 'Button Hover Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=button]:hover' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} form button:hover' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_hover_border_color',
					'title'      => esc_html__( 'Button Hover Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=button]:hover' => 'border-color: {{VALUE}};',
						'{{WRAPPER}} form button:hover' => 'border-color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_button_tab_active_end',
					'title'      => esc_html__( 'Active End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'cf7_button_tabs_end',
					'title'      => esc_html__( 'Tabs End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'divider_hover',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'button_border_style',
					'title'      => esc_html__( 'Button Border Style', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'border_style' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=button]' => 'border-style: {{VALUE}};',
						'{{WRAPPER}} form button' => 'border-style: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_border_width',
					'title'      => esc_html__( 'Button Border Width', 'qi-addons-for-elementor-premium' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} form input[type=button]' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
						'{{WRAPPER}} form button' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_border_radius',
					'title'      => esc_html__( 'Button Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} form input[type=button]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} form button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_margin',
					'title'      => esc_html__( 'Button Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} form input[type=button]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} form button]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_padding',
					'title'      => esc_html__( 'Button Padding', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} form input[type=button]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} form button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'submit_typography',
					'title'      => esc_html__( 'Submit Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} form input[type=submit]',
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'cf7_submit_style_tabs',
					'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_submit_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'submit_color',
					'title'      => esc_html__( 'Submit Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=submit]' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'submit_background_color',
					'title'      => esc_html__( 'Submit Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=submit]' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'submit_border_color',
					'title'      => esc_html__( 'Submit Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=submit]' => 'border-color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_submit_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_submit_tab_active',
					'title'      => esc_html__( 'Active', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'submit_hover_color',
					'title'      => esc_html__( 'Submit Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=submit]:hover' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'submit_hover_background_color',
					'title'      => esc_html__( 'Submit Hover Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=submit]:hover' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'submit_hover_border_color',
					'title'      => esc_html__( 'Submit Hover Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=submit]:hover' => 'border-color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_submit_tab_active_end',
					'title'      => esc_html__( 'Active End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'cf7_submit_tabs_end',
					'title'      => esc_html__( 'Tabs End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'divider_submit_hover',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'submit_border_style',
					'title'      => esc_html__( 'Submit Border Style', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'border_style' ),
					'selectors'  => array(
						'{{WRAPPER}} form input[type=submit]' => 'border-style: {{VALUE}};',
					),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'submit_border_width',
					'title'      => esc_html__( 'Submit Border Width', 'qi-addons-for-elementor-premium' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} form input[type=submit]' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
					),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'submit_border_radius',
					'title'      => esc_html__( 'Submit Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} form input[type=submit]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'submit_margin',
					'title'      => esc_html__( 'Submit Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} form input[type=submit]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'submit_padding',
					'title'      => esc_html__( 'Submit Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} form input[type=submit]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'full_button',
					'title'      => esc_html__( 'Submit Full Width', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'group'      => esc_html__( 'Submit Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'progress_title_typography',
					'title'      => esc_html__( 'Progress Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gf_progressbar_wrapper .gf_progressbar_title',
					'group'      => esc_html__( 'Progress Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'progress_title_color',
					'title'      => esc_html__( 'Progress Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gf_progressbar_wrapper .gf_progressbar_title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Progress Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'progress_title_margin_bottom',
					'title'      => esc_html__( 'Progress Title Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gf_progressbar_wrapper .gf_progressbar_title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Progress Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_progress_style',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Progress Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'progress_inactive_color',
					'title'      => esc_html__( 'Progress Inactive Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gf_progressbar_wrapper .gf_progressbar' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Progress Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'progress_active_color',
					'title'      => esc_html__( 'Progress Active Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gf_progressbar_wrapper .gf_progressbar_percentage' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Progress Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'progress_number_color',
					'title'      => esc_html__( 'Progress Number Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gf_progressbar_wrapper .gf_progressbar_percentage' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Progress Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'progress_number_typography',
					'title'      => esc_html__( 'Progress Number Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gf_progressbar_wrapper .gf_progressbar_percentage > span',
					'group'      => esc_html__( 'Progress Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'progress_margin_bottom',
					'title'      => esc_html__( 'Progress Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gf_progressbar' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Progress Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'section_title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gsection .gsection_title',
					'group'      => esc_html__( 'Section Break Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'section_title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gsection .gsection_title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Section Break Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'section_description_typography',
					'title'      => esc_html__( 'Description Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gsection .gsection_description',
					'group'      => esc_html__( 'Section Break Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'section_descirption_color',
					'title'      => esc_html__( 'Description Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gsection .gsection_description' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Section Break Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'description_margin_top',
					'title'      => esc_html__( 'Description Margin Top', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gsection .gsection_description' => 'padding-top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Section Break Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'validation_typography',
					'title'      => esc_html__( 'Validation Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} form .gfield_validation_message',
					'group'      => esc_html__( 'Validation Message Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'validation_color',
					'title'      => esc_html__( 'Validation Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form .gfield_validation_message' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Validation Message Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_style_validation_typography',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Validation Message Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'validation_background',
					'title'      => esc_html__( 'Validation Background', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} form .gfield_validation_message' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Validation Message Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'border',
					'name'       => 'validation_border',
					'title'      => esc_html__( 'Validation Border', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} form .gfield_validation_message',
					'group'      => esc_html__( 'Validation Message Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'validation_border_radius',
					'title'      => esc_html__( 'Validation Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} form .gfield_validation_message' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Validation Message Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'validation_padding',
					'title'      => esc_html__( 'Validation Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} form .gfield_validation_message' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Validation Message Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'validation_margin',
					'title'      => esc_html__( 'Validation Margin Top', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} form .gfield_validation_message' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Validation Message Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'error_typography',
					'title'      => esc_html__( 'Error Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gform_validation_errors > .gform_submission_error',
					'group'      => esc_html__( 'Error Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'error_color',
					'title'      => esc_html__( 'Error Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gform_validation_errors > .gform_submission_error' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Error Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_style_error_typography',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Error Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'error_background',
					'title'      => esc_html__( 'Error Background', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gform_validation_errors' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Error Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'border',
					'name'       => 'error_border',
					'title'      => esc_html__( 'Error Border', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gform_validation_errors',
					'group'      => esc_html__( 'Error Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'error_border_radius',
					'title'      => esc_html__( 'Error Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .gform_validation_errors' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Error Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'error_margin',
					'title'              => esc_html__( 'Error Margin', 'qi-addons-for-elementor-premium' ),
					'allowed_dimensions' => array( 'top', 'bottom' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'responsive'         => true,
					'selectors'          => array(
						'{{WRAPPER}} .gform_validation_errors' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}};',
					),
					'group'              => esc_html__( 'Error Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'error_padding',
					'title'              => esc_html__( 'Error Padding', 'qi-addons-for-elementor-premium' ),
					'allowed_dimensions' => array( 'top', 'bottom' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'responsive'         => true,
					'selectors'          => array(
						'{{WRAPPER}} .gform_validation_errors' => 'padding-top: {{TOP}}{{UNIT}}; padding-bottom: {{BOTTOM}}{{UNIT}};',
					),
					'group'              => esc_html__( 'Error Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'confirmation_typography',
					'title'      => esc_html__( 'Confirmation Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .gform_confirmation_wrapper',
					'group'      => esc_html__( 'Confirmation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'confirmation_color',
					'title'      => esc_html__( 'Confirmation Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .gform_confirmation_wrapper' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Confirmation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$form = GFAPI::get_form( $atts['gravity_form_id'] );
			if ( false === $form ) {
				return esc_html__( 'Please enter valid form ID', 'qi-addons-for-elementor-premium' );
			}

			$atts['holder_classes']   = $this->get_holder_classes( $atts );
			$atts['show_title']       = isset( $atts['show_title'] ) && 'yes' === $atts['show_title'] ? 'true' : 'false';
			$atts['show_description'] = isset( $atts['show_description'] ) && 'yes' === $atts['show_description'] ? 'true' : 'false';

			return qi_addons_for_elementor_premium_get_template_part( 'plugins/gravity-forms/shortcodes/gravity-forms', 'templates/gravity-forms', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-gravity-forms';
			$holder_classes[] = ( 'yes' === $atts['full_button'] ) ? 'qodef-button--full-width' : '';
			$holder_classes[] = ( ! empty( $atts['alignment'] ) ) ? 'qodef-alignment--' . $atts['alignment'] : '';

			return implode( ' ', $holder_classes );
		}
	}
}
