<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_order_tracking_form_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_order_tracking_form_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Order_Tracking_Form_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_order_tracking_form_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Order_Tracking_Form_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_PLUGINS_URL_PATH . '/woocommerce/shortcodes/order-tracking-form' );
			$this->set_base( 'qi_addons_for_elementor_premium_order_tracking_form' );
			$this->set_name( esc_html__( 'Order Tracking Form', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays order tracking form', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'WooCommerce', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/order-tracking-form/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#order_tracking_form' );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
					'default_value' => qi_addons_for_elementor_get_example_text( 'title' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'subtitle',
					'title'         => esc_html__( 'Subtitle', 'qi-addons-for-elementor-premium' ),
					'default_value' => qi_addons_for_elementor_get_example_text( 'subtitle' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'hide_text',
					'title'         => esc_html__( 'Hide Text', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .qodef-m-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .qodef-m-title',
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'subtitle_tag',
					'title'         => esc_html__( 'Subtitle Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h5',
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .qodef-m-subtitle' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'subtitle_typography',
					'title'      => esc_html__( 'Subtitle Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .qodef-m-subtitle',
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .woocommerce form p:first-child' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .woocommerce form p:first-child',
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'alignment',
					'title'      => esc_html__( 'Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form, {{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input' => 'text-align: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'title_margin',
					'title'      => esc_html__( 'Title Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .qodef-m-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'subtitle_margin',
					'title'      => esc_html__( 'Subtitle Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .qodef-m-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'text_margin',
					'title'      => esc_html__( 'Text Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .woocommerce form p:first-child' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'label_margin',
					'title'      => esc_html__( 'Label Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'label_typography',
					'title'      => esc_html__( 'Label Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form label',
					'group'      => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'label_color',
					'title'      => esc_html__( 'Label Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form label' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Label Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'cf7_style_tabs',
					'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'input_typography',
					'title'      => esc_html__( 'Input Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit]), {{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea, {{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form select',
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_color',
					'title'      => esc_html__( 'Input Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit])'              => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea'                              => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form select'                                => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit])::placeholder' => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea::placeholder'                 => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_background_color',
					'title'      => esc_html__( 'Input Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit])' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea'                 => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form select'                   => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'border',
					'name'       => 'input_border',
					'title'      => esc_html__( 'Input Border', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit]),{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea, {{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form select',
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_tab_active',
					'title'      => esc_html__( 'Active', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'input_focus_typography',
					'title'      => esc_html__( 'Input Focus Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit]):focus, {{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea:focus, {{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form select:focus',
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_focus_color',
					'title'      => esc_html__( 'Input Focus Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit]):focus'              => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea:focus'                              => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form select:focus'                                => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit]):focus::placeholder' => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea:focus::placeholder'                 => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'input_focus_background_color',
					'title'      => esc_html__( 'Input Focus Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit]):focus' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea:focus'                 => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form select:focus'                   => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'border',
					'name'       => 'input_focus_border',
					'title'      => esc_html__( 'Input Focus Border', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit]):focus,{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea:focus, {{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form select:focus',
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_tab_active_end',
					'title'      => esc_html__( 'Active End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'cf7_tabs_end',
					'title'      => esc_html__( 'Tabs End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'divider_border_radius',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'input_border_radius',
					'title'      => esc_html__( 'Input Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit])' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea'                 => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form select'                   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Input Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'button_typography',
					'title'      => esc_html__( 'Button Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form button[type=submit]',
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'cf7_button_style_tabs',
					'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_button_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_color',
					'title'      => esc_html__( 'Button Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form button[type=submit]' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_background_color',
					'title'      => esc_html__( 'Button Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form button[type=submit]' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_border_color',
					'title'      => esc_html__( 'Button Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form button[type=submit]' => 'border-color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_button_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'cf7_button_tab_active',
					'title'      => esc_html__( 'Active', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_hover_color',
					'title'      => esc_html__( 'Button Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form button[type=submit]:hover' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_hover_background_color',
					'title'      => esc_html__( 'Button Hover Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form button[type=submit]:hover' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_hover_border_color',
					'title'      => esc_html__( 'Button Hover Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form button[type=submit]:hover' => 'border-color: {{VALUE}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'cf7_button_tab_active_end',
					'title'      => esc_html__( 'Active End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'cf7_button_tabs_end',
					'title'      => esc_html__( 'Tabs End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'divider_hover',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'button_border_style',
					'title'      => esc_html__( 'Button Border Style', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'border_style' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form button[type=submit]' => 'border-style: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_border_width',
					'title'      => esc_html__( 'Button Border Width', 'qi-addons-for-elementor-premium' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form button[type=submit]' => 'border-width: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_border_radius',
					'title'      => esc_html__( 'Button Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form button[type=submit]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'form_item_space',
					'title'              => esc_html__( 'Form Item Space', 'qi-addons-for-elementor-premium' ),
					'group'              => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'allowed_dimensions' => array( 'top', 'bottom' ),
					'responsive'         => true,
					'selectors'          => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .form-row.form-row-first, {{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .form-row.form-row-last' => 'padding: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'input_margin',
					'title'      => esc_html__( 'Input Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit])' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea'                 => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form select'                   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'input_padding',
					'title'      => esc_html__( 'Input Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form input:not([type=submit])' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form textarea'                 => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form select'                   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_margin',
					'title'      => esc_html__( 'Button Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form button[type=submit]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'button_padding',
					'title'      => esc_html__( 'Button Padding', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form button[type=submit]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'error_alignment',
					'title'      => esc_html__( 'Response Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons_flex', false ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .woocommerce-error' => 'align-items: {{VALUE}};',
					),
					'group'      => esc_html__( 'Response Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'response_typography',
					'title'      => esc_html__( 'Response Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .woocommerce-error',
					'group'      => esc_html__( 'Response Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'response_color',
					'title'      => esc_html__( 'Response Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .woocommerce-error' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Response Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_style_response_typography',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Response Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'response_padding',
					'title'      => esc_html__( 'Response Padding', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Response Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .woocommerce-error' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'response_margin',
					'title'      => esc_html__( 'Response Margin', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Response Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .woocommerce-error' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_style_response_spacing',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Response Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'border',
					'name'       => 'response_border',
					'title'      => esc_html__( 'Response Border', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .woocommerce-error',
					'group'      => esc_html__( 'Response Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_style_response_background',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Response Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'background',
					'name'       => 'response_background',
					'title'      => esc_html__( 'Response Background', 'qi-addons-for-elementor-premium' ),
					'types'      => array( 'classic', 'gradient', 'video' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-woo-shortcode-order-tracking-form .woocommerce-error',
					'group'      => esc_html__( 'Response Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );

			return qi_addons_for_elementor_premium_get_template_part( 'plugins/woocommerce/shortcodes/order-tracking-form', 'templates/order-tracking-form', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-woo-shortcode-order-tracking-form';
			$holder_classes[] = ! empty( $atts['hide_text'] ) && 'yes' === $atts['hide_text'] ? 'qodef--hide-text' : '';

			return implode( ' ', $holder_classes );
		}
	}
}
