<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_product_comparison_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_product_comparison_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Product_Comparison_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_product_comparison_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Product_Comparison_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_PLUGINS_URL_PATH . '/woocommerce/shortcodes/product-comparison' );
			$this->set_base( 'qi_addons_for_elementor_premium_product_comparison' );
			$this->set_name( esc_html__( 'Product Comparison', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays product comparison', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'WooCommerce', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/product-comparison/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#product_comparison' );
			$this->set_video( 'https://www.youtube.com/watch?v=CfO3giIhEq0' );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select2',
					'name'       => 'products',
					'title'      => esc_html__( 'Choose Products', 'qi-addons-for-elementor-premium' ),
					'multiple'   => true,
					'options'    => $this->getProducts(),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'orderby',
					'title'         => esc_html__( 'Order By', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'order_by', true ),
					'default_value' => 'date',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'order',
					'title'         => esc_html__( 'Order', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'order' ),
					'default_value' => 'DESC',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'fields',
					'title'         => esc_html__( 'Fields to show', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'type' => 'image',
						),
						array(
							'type' => 'title',
						),
						array(
							'type' => 'price',
						),
						array(
							'type' => 'stock',
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'select',
							'name'          => 'type',
							'title'         => esc_html__( 'Type', 'qi-addons-for-elementor-premium' ),
							'options'       => array_merge(
								array(
									'image'             => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
									'title'             => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
									'image-with-title'  => esc_html__( 'Image with title', 'qi-addons-for-elementor-premium' ),
									'image-title-price' => esc_html__( 'Image, title and price', 'qi-addons-for-elementor-premium' ),
									'price'             => esc_html__( 'Price', 'qi-addons-for-elementor-premium' ),
									'stock'             => esc_html__( 'Availability', 'qi-addons-for-elementor-premium' ),
									'add-to-cart'       => esc_html__( 'Add to cart', 'qi-addons-for-elementor-premium' ),
									'rating'            => esc_html__( 'Rating', 'qi-addons-for-elementor-premium' ),
									'description'       => esc_html__( 'Description', 'qi-addons-for-elementor-premium' ),
									'sku'               => esc_html__( 'SKU', 'qi-addons-for-elementor-premium' ),
									'weight'            => esc_html__( 'Weight', 'qi-addons-for-elementor-premium' ),
									'dimensions'        => esc_html__( 'Dimensions', 'qi-addons-for-elementor-premium' ),
								),
								$this->get_woo_attr_taxonomies()
							),
							'default_value' => esc_html__( 'title', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'table_layout',
					'title'         => esc_html__( 'Table Layout', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'auto'  => esc_html__( 'Auto', 'qi-addons-for-elementor-premium' ),
						'fixed' => esc_html__( 'Fixed', 'qi-addons-for-elementor-premium' ),
					),
					'responsive'    => true,
					'default_value' => 'auto',
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-table' => 'table-layout: {{VALUE}};',
					),
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'minimal_width',
					'title'      => esc_html__( 'Minimal Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 1,
							'max' => 2000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table' => 'min-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'border_style',
					'title'      => esc_html__( 'Border Style', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'all'    => esc_html__( 'All', 'qi-addons-for-elementor-premium' ),
						'inside' => esc_html__( 'Inside Only', 'qi-addons-for-elementor-premium' ),
						'none'   => esc_html__( 'None', 'qi-addons-for-elementor-premium' ),
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'border',
					'name'       => 'border',
					'title'      => esc_html__( 'Border', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-cell',
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'hide' => array(
							'border_style' => array(
								'values'        => 'none',
								'default_value' => 'all',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'headings_cell_padding',
					'title'              => esc_html__( 'Column Title Cell Padding', 'qi-addons-for-elementor-premium' ),
					'allowed_dimensions' => array( 'top', 'bottom' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'responsive'         => true,
					'selectors'          => array(
						'{{WRAPPER}} .qodef-e-cell.qodef-row-title' => 'padding-top: {{TOP}}{{UNIT}}; padding-bottom: {{BOTTOM}}{{UNIT}};',
					),
					'group'              => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'cell_padding',
					'title'      => esc_html__( 'Cell Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-cell' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'first_column_width',
					'title'      => esc_html__( 'First Column Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 1,
							'max' => 2000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-cell:first-child' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'background_style',
					'title'      => esc_html__( 'Background Style', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'simple'        => esc_html__( 'Simple', 'qi-addons-for-elementor-premium' ),
						'row-content'   => esc_html__( 'Row - Content', 'qi-addons-for-elementor-premium' ),
						'alternating'   => esc_html__( 'Alternating', 'qi-addons-for-elementor-premium' ),
						'varied-colors' => esc_html__( 'Varied Colors', 'qi-addons-for-elementor-premium' ),
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color',
					'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-background-style--simple .qodef-m-table'                                      => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--row-content .qodef-row-title'                               => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--alternating .qodef-e-row:nth-child(2n+1)'                   => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--varied-colors .qodef-e-row:nth-child(odd) .qodef-row-title' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color_2',
					'title'      => esc_html__( 'Background Color Second', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'hide' => array(
							'background_style' => array(
								'values'        => 'simple',
								'default_value' => 'simple',
							),
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-background-style--row-content .qodef-e-content-column'                         => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--alternating .qodef-e-row:nth-child(2n)'                      => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--varied-colors .qodef-e-row:nth-child(even) .qodef-row-title' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color_3',
					'title'      => esc_html__( 'Background Color Third', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'background_style' => array(
								'values'        => 'varied-colors',
								'default_value' => 'simple',
							),
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-background-style--varied-colors .qodef-e-row:nth-child(odd) .qodef-e-content-column:nth-child(even)' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color_4',
					'title'      => esc_html__( 'Background Color Fourth', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'background_style' => array(
								'values'        => 'varied-colors',
								'default_value' => 'simple',
							),
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-background-style--varied-colors .qodef-e-row:nth-child(even) .qodef-e-content-column:nth-child(even)' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color_5',
					'title'      => esc_html__( 'Background Color Fifth', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'background_style' => array(
								'values'        => 'varied-colors',
								'default_value' => 'simple',
							),
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-background-style--varied-colors .qodef-e-row:nth-child(odd) .qodef-e-content-column:nth-child(odd)' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color_6',
					'title'      => esc_html__( 'Background Color Sixth', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'background_style' => array(
								'values'        => 'varied-colors',
								'default_value' => 'simple',
							),
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-background-style--varied-colors .qodef-e-row:nth-child(even) .qodef-e-content-column:nth-child(odd)' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'row_title_tag',
					'title'         => esc_html__( 'Row Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h6',
					'group'         => esc_html__( 'Row Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'row_title_color',
					'title'      => esc_html__( 'Row Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-row-title .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Row Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'row_title_typography',
					'title'      => esc_html__( 'Row Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-row-title .qodef-e-title',
					'group'      => esc_html__( 'Row Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'cell_content_color',
					'title'      => esc_html__( 'Cell Content Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-cell.qodef-e-content-column' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Cell Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'cell_content_typography',
					'title'      => esc_html__( 'Cell Content Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-cell.qodef-e-content-column',
					'group'      => esc_html__( 'Cell Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'alignment',
					'title'      => esc_html__( 'Cell Content Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-cell.qodef-e-content-column' => 'text-align: {{VALUE}};',
					),
					'group'      => esc_html__( 'Cell Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'images_proportion',
					'default_value' => 'full',
					'title'         => esc_html__( 'Image Proportions', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'list_image_dimension', false ),
					'group'         => esc_html__( 'Image Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'image_cell_padding',
					'title'      => esc_html__( 'Image Type Cell Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-cell.qodef-cell-type--image-title-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-e-cell.qodef-cell-type--image-with-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-e-cell.qodef-cell-type--image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Image Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'number',
					'name'        => 'custom_image_width',
					'title'       => esc_html__( 'Custom Image Width', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'Enter image width in px', 'qi-addons-for-elementor-premium' ),
					'group'       => esc_html__( 'Image Style', 'qi-addons-for-elementor-premium' ),
					'dependency'  => array(
						'show' => array(
							'images_proportion' => array(
								'values'        => 'custom',
								'default_value' => 'full',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'number',
					'name'        => 'custom_image_height',
					'title'       => esc_html__( 'Custom Image Height', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'Enter image height in px', 'qi-addons-for-elementor-premium' ),
					'group'       => esc_html__( 'Image Style', 'qi-addons-for-elementor-premium' ),
					'dependency'  => array(
						'show' => array(
							'images_proportion' => array(
								'values'        => 'custom',
								'default_value' => 'full',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'product_title_color',
					'title'      => esc_html__( 'Product Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-product-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Product Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'product_title_typography',
					'title'      => esc_html__( 'Product Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-product-title',
					'group'      => esc_html__( 'Product Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'product_title_margin_top',
					'title'      => esc_html__( 'Product Title Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Product Title Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-product-title' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'price_color',
					'title'      => esc_html__( 'Price Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-woo-product-price' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Price Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'price_typography',
					'title'      => esc_html__( 'Price Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-woo-product-price',
					'group'      => esc_html__( 'Price Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'price_margin_top',
					'title'      => esc_html__( 'Price Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Price Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-woo-product-price' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'price_margin_bottom',
					'title'      => esc_html__( 'Price Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Price Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-woo-product-price' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class', 'button_text', 'button_link' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_premium_rating',
					'exclude'           => array( 'custom_class', 'rating_value' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Rating', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['rows']           = $this->parse_repeater_items( $atts['fields'] );
			$atts['rating_params']  = $this->generate_rating_params( $atts );

			$query_array          = $this->generateProductQueryArray( $atts );
			$query_result         = new \WP_Query( $query_array );
			$atts['query_result'] = $query_result;

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'plugins/woocommerce/shortcodes/product-comparison', 'templates/product-comparison', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-woo-shortcode-product-comparison';
			$holder_classes[] = 'qodef-addons-woo-shortcode';
			$holder_classes[] = ! empty( $atts['border_style'] ) ? 'qodef-border--' . $atts['border_style'] : '';
			$holder_classes[] = ! empty( $atts['background_style'] ) ? 'qodef-background-style--' . $atts['background_style'] : '';

			return implode( ' ', $holder_classes );
		}

		private function getProducts() {
			$formatted_array = array( '' );

			$all_ids = get_posts(
				array(
					'post_type'   => 'product',
					'numberposts' => - 1,
					'post_status' => 'publish',
					'fields'      => 'ids',
				)
			);
			foreach ( $all_ids as $id ) {
				$formatted_array[ $id ] = get_the_title( $id );
			}

			return $formatted_array;
		}

		private function generateProductQueryArray( $atts ) {
			$query_array = array(
				'post_status'         => 'publish',
				'post_type'           => 'product',
				'ignore_sticky_posts' => 1,
				'post__in'            => $atts['products'],
				'orderby'             => $atts['orderby'],
				'order'               => $atts['order'],
			);

			return $query_array;
		}

		private function get_woo_attr_taxonomies() {
			$attributes_tax = wc_get_attribute_taxonomies();
			$data           = array();

			foreach ( $attributes_tax as $item ) {
				$data[ wc_attribute_taxonomy_name( $item->attribute_name ) ] = $item->attribute_label;
			}

			return $data;
		}

		public function generate_button_params( $atts ) {
			$product = qi_addons_for_elementor_woo_get_global_product();

			if ( $product ) {
				$defaults = array(
					'quantity'   => 1,
					'class'      => implode(
						' ',
						array_filter(
							array(
								'button',
								'product_type_' . $product->get_type(),
								$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
								$product->supports( 'ajax_add_to_cart' ) && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
							)
						)
					),
					'attributes' => array(
						'data-product_id'  => $product->get_id(),
						'data-product_sku' => $product->get_sku(),
						'aria-label'       => $product->add_to_cart_description(),
						'rel'              => 'nofollow',
					),
				);

				$args = apply_filters( 'woocommerce_loop_add_to_cart_args', $defaults, $product );

				if ( isset( $args['attributes']['aria-label'] ) ) {
					$args['attributes']['aria-label'] = wp_strip_all_tags( $args['attributes']['aria-label'] );
				}

				if ( ! empty( $args['class'] ) ) {
					$atts['custom_class'] = $args['class'];
				}

				if ( count( $args['attributes'] ) ) {
					$atts['custom_attrs']                  = $args['attributes'];
					$atts['custom_attrs']['data-quantity'] = $args['quantity'];
				}

				$atts['button_link'] = array();

				$atts['button_link']['url'] = $product->add_to_cart_url();
				$atts['button_text']        = $product->add_to_cart_text();

				return $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_button',
						'exclude'        => array( 'button_target', 'not_custom_class' ),
						'atts'           => $atts,
					)
				);
			}

			return array();
		}

		private function generate_rating_params( $atts ) {
			$params = array();

			$params = $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'qi_addons_for_elementor_premium_rating',
					'exclude'        => array( 'custom_class', 'rating_value' ),
					'atts'           => $atts,
				)
			);

			return $params;
		}
	}
}
