<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_product_list_data' ) ) {
	function qi_addons_for_elementor_premium_add_product_list_data( $data, $atts ) {

		if ( isset( $atts['pagination_type'] ) && in_array( $atts['pagination_type'], array( 'standard', 'load-more', 'infinite-scroll' ), true ) ) {
			$data['data-options'] = qi_addons_for_elementor_premium_get_pagination_data( QI_ADDONS_FOR_ELEMENTOR_REL_PATH, 'plugins/woocommerce/shortcodes', 'product-list', 'product', $atts );
		}

		return $data;
	}

	add_filter( 'qi_addons_for_elementor_filter_product_list_data_attr', 'qi_addons_for_elementor_premium_add_product_list_data', 10, 2 );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_product_list_include_options' ) ) {
	function qi_addons_for_elementor_premium_product_list_include_options( $include_array ) {
		$include_array[] = 'pagination_type';

		return $include_array;
	}

	add_filter( 'qi_addons_for_elementor_filter_product_list_list_option', 'qi_addons_for_elementor_premium_product_list_include_options' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_product_list_additional_params' ) ) {
	function qi_addons_for_elementor_premium_product_list_additional_params( $params ) {
		if ( 'product-list' === $params['shortcode'] ) {
			$params['button_params'] = $params['this_shortcode']->generate_button_params( $params );
		}

		return $params;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_pagination_params', 'qi_addons_for_elementor_premium_product_list_additional_params' );
}
