<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_advanced_timeline_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_advanced_timeline_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Advanced_Timeline_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_advanced_timeline_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Advanced_Timeline_Shortcode extends QiAddonsForElementor_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/advanced-timeline' );
			$this->set_base( 'qi_addons_for_elementor_premium_advanced_timeline' );
			$this->set_name( esc_html__( 'Advanced Timeline', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that adds advanced timeline', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Business', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/advanced-timeline/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#advanced_timeline' );
			$this->set_video( 'https://www.youtube.com/watch?v=OSD4xmoZzu0' );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'   => 'select',
					'name'         => 'timeline_format',
					'title'        => esc_html__( 'Timeline displays?', 'qi-addons-for-elementor-premium' ),
					'options'      => array(
						'Y'        => esc_html__( 'Only Years', 'qi-addons-for-elementor-premium' ),
						'M Y'      => esc_html__( 'Years and Months', 'qi-addons-for-elementor-premium' ),
						'M d, \'y' => esc_html__( 'Years, Months and Days', 'qi-addons-for-elementor-premium' ),
						'M d'      => esc_html__( 'Months and Days', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'Y',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'distance',
					'title'         => esc_html__( 'Minimal Distance Between Dates', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Default value is 60', 'qi-addons-for-elementor-premium' ),
					'default_value' => '60',
				)
			);

			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Timeline elements', 'qi-addons-for-elementor-premium' ),
					'items'      => array(
						array(
							'field_type'  => 'text',
							'name'        => 'item_date',
							'title'       => esc_html__( 'Timeline Date', 'qi-addons-for-elementor-premium' ),
							'description' => esc_html__( 'Enter date in format mm/dd/yyyy.', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'image',
							'name'       => 'item_image',
							'title'      => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_subtitle',
							'title'      => esc_html__( 'Subtitle', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_title',
							'title'      => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_text',
							'title'      => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'link',
							'name'          => 'item_link',
							'title'         => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_link_text',
							'title'         => esc_html__( 'Link Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => '',
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'content_top_offset',
					'title'      => esc_html__( 'Content Top Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-content'  => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'General Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_image_and_text',
					'title'      => esc_html__( 'Space Between Image and Text', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-content .qodef-at-content-inner'  => 'column-gap: {{SIZE}}{{UNIT}}; row-gap: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'General Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'content_layout',
					'title'      => esc_html__( 'Image/Content Layout', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'image-on-left'     => esc_html__( 'Image on Left', 'qi-addons-for-elementor-premium' ),
						'image-on-top' => esc_html__( 'Image on Top', 'qi-addons-for-elementor-premium' ),
						'image-on-right'     => esc_html__( 'Image on Right', 'qi-addons-for-elementor-premium' ),
					),
					'group'      => esc_html__( 'General Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'image_alignment',
					'title'      => esc_html__( 'Image Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'group'      => esc_html__( 'General Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'content_alignment',
					'title'      => esc_html__( 'Content Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'group'      => esc_html__( 'General Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'content_padding',
					'title'      => esc_html__( 'Content Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-content .qodef-at-content-inner .qodef-m-content .qodef-m-content-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'General Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'line_color',
					'title'      => esc_html__( 'Line Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-inner' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'active_line_color',
					'title'      => esc_html__( 'Active Line Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-filling-line' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'line_thickness',
					'title'      => esc_html__( 'Line Thickness', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-inner'  => 'height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-at-nav-inner a:after'  => 'bottom: calc(-5px + {{SIZE}}{{UNIT}} /2);',
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'line_side_offset',
					'title'      => esc_html__( 'Line Side Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-wrapper'  => 'margin: 0 {{SIZE}}{{UNIT}}; width: calc(100% - {{SIZE}}{{UNIT}}*2);',
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'date_color',
					'title'      => esc_html__( 'Date Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-inner a span' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'date_typography',
					'title'      => esc_html__( 'Date Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-at-nav-inner a span',
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'point_type',
					'title'      => esc_html__( 'Point Type', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'standard' => esc_html__( 'Standard', 'qi-addons-for-elementor-premium' ),
						'icon'     => esc_html__( 'Icon', 'qi-addons-for-elementor-premium' ),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'point_size',
					'title'      => esc_html__( 'Point Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-inner a:after' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; left: calc(50% - {{SIZE}}{{UNIT}}/2)',
						'{{WRAPPER}} .qodef-at-nav-inner a .qodef-e-icon-holder' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-at-nav-wrapper' => 'height: calc( 62px + {{SIZE}}{{UNIT}} )',
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'point_vertical_position',
					'title'      => esc_html__( 'Point Vertical Position', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => - 20,
							'max' => 20,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-inner a' => 'bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'point_color',
					'title'      => esc_html__( 'Point Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-inner a:after' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => array( 'standard', 'line' ),
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'point_border_radius',
					'title'      => esc_html__( 'Point Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-inner a:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'standard',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'icons',
					'name'       => 'icon_type',
					'title'      => esc_html__( 'Icon Type', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'icon',
								'default_value' => 'standard',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_color',
					'title'      => esc_html__( 'Icon Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-inner a .qodef-e-icon-holder' => 'color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'icon',
								'default_value' => 'standard',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_background_color',
					'title'      => esc_html__( 'Icon Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-inner a .qodef-e-icon-holder' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'icon',
								'default_value' => 'standard',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_background_size',
					'title'      => esc_html__( 'Icon Background Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'responsive' => true,
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'icon',
								'default_value' => 'standard',
							),
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-inner a .qodef-e-icon-holder' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'icon_background_border_radius',
					'title'      => esc_html__( 'Icon Background Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-inner a .qodef-e-icon-holder' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'point_type' => array(
								'values'        => 'icon',
								'default_value' => 'standard',
							),
						),
					),
					'group'      => esc_html__( 'Line & Point Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'navigation_vertical_position',
					'title'      => esc_html__( 'Vertical Position', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => - 100,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-navigation a' => 'bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'navigation_arrow_prev',
					'title'         => esc_html__( 'Navigation Arrow Previous', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(),
					'group'         => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'navigation_arrow_next',
					'title'         => esc_html__( 'Navigation Arrow Next', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(),
					'group'         => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'divider_navigation_together_style',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'arrows_style_tabs',
					'title'      => esc_html__( 'Arrows Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'arrows_style_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'navigation_arrows_color',
					'title'      => esc_html__( 'Navigation Arrow Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-navigation a .qodef-m-nav-icon' => 'color: {{VALUE}}',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'navigation_arrows_background_color',
					'title'      => esc_html__( 'Navigation Arrow Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-navigation a .qodef-m-nav-icon' => 'background-color: {{VALUE}}',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'arrows_style_tab_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'arrows_style_tab_hover',
					'title'      => esc_html__( 'Hover', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'navigation_arrows_hover_color',
					'title'      => esc_html__( 'Navigation Arrow Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-navigation a:hover .qodef-m-nav-icon' => 'color: {{VALUE}}',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'navigation_arrows_hover_background_color',
					'title'      => esc_html__( 'Navigation Arrow Background Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-navigation a:hover .qodef-m-nav-icon' => 'background-color: {{VALUE}}',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'arrows_style_tab_hover_end',
					'title'      => esc_html__( 'Hover End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'arrows_style_tabs_end',
					'title'      => esc_html__( 'Arrows End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'divider_navigation_style_end',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'navigation_arrows_size',
					'title'      => esc_html__( 'Navigation Arrow Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-navigation a .qodef-m-nav-icon' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-at-nav-navigation a .qodef-m-nav-icon svg' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'navigation_arrows_holder_width',
					'title'      => esc_html__( 'Navigation Arrow Holder Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-nav-navigation a .qodef-m-nav-icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-content li .qodef-m-subtitle' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'subtitle_typography',
					'title'      => esc_html__( 'Subtitle Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-at-content li .qodef-m-subtitle',
					'group'      => esc_html__( 'Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'subtitle_bottom_margin',
					'title'      => esc_html__( 'Subtitle Bottom Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-content li .qodef-m-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-content li .qodef-m-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-at-content li .qodef-m-title',
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_bottom_margin',
					'title'      => esc_html__( 'Title Bottom Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-content li .qodef-m-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-content li p.qodef-m-text' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-at-content li p.qodef-m-text',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'text_bottom_margin',
					'title'      => esc_html__( 'Text Bottom Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-at-content li p.qodef-m-text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class', 'button_text', 'button_link' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['button_params']  = $this->generate_button_params( $atts );
			$atts['this_object']    = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/advanced-timeline', 'templates/advanced-timeline', '', $atts );
		}


		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-advanced-timeline';

			if ( ! empty( $atts['point_type'] ) && 'icon' === $atts['point_type'] ) {
				$holder_classes[] = 'qodef-qi-advanced-timeline-has-icon-points';
			}

			$holder_classes[] = 'qodef-qi-advanced-timeline-content-' . $atts['content_alignment'] . '-alignment';
			$holder_classes[] = 'qodef-qi-advanced-timeline-image-' . $atts['image_alignment'] . '-alignment';
			$holder_classes[] = 'qodef-qi-advanced-timeline-' . $atts['content_layout'];

			return implode( ' ', $holder_classes );
		}

		public function getItemClasses( $item ) {
			$item_classes = array();

			$item_classes[] = ! empty( $item['item_image'] ) ? 'qodef-advanced-timeline-has-image' : 'qodef-advanced-timeline-no-image';

			return implode( ' ', $item_classes );
		}
		private function generate_button_params( $atts ) {
			$atts['button_text'] = '';
			$atts['button_link'] = array(
				'url'               => '',
				'is_external'       => '',
				'nofollow'          => '',
				'custom_attributes' => '',
			);

			$params = $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'qi_addons_for_elementor_button',
					'exclude'        => array( 'custom_class' ),
					'atts'           => $atts,
				)
			);

			return $params;
		}

	}
}
