<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_advanced_toggle_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_advanced_toggle_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Advanced_Toggle_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_advanced_toggle_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Advanced_Toggle_Shortcode extends QiAddonsForElementor_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/advanced-toggle' );
			$this->set_base( 'qi_addons_for_elementor_premium_advanced_toggle' );
			$this->set_name( esc_html__( 'Advanced Toggle', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that adds advanced toggle', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Business', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/advanced-toggle/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#advanced_toggle' );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'first_title',
					'title'         => esc_html__( 'First Title', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'First Title', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'second_title',
					'title'         => esc_html__( 'Second Title', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Second Title', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'first_section',
					'title'         => esc_html__( 'Select First Section Template', 'qi-addons-for-elementor-premium' ),
					'default_value' => '0',
					'options'       => qi_addons_for_elementor_generate_elementor_templates_control(),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'second_section',
					'title'         => esc_html__( 'Select Second Section Template', 'qi-addons-for-elementor-premium' ),
					'default_value' => '0',
					'options'       => qi_addons_for_elementor_generate_elementor_templates_control(),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'alignment',
					'title'         => esc_html__( 'Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'flex-start' => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'center'     => esc_html__( 'Center', 'qi-addons-for-elementor-premium' ),
						'flex-end'   => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
					),
					'responsive'    => true,
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-switcher' => 'justify-content: {{VALUE}};',
					),
					'default_value' => 'center',
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'switcher_holder_background_color',
					'title'      => esc_html__( 'Switcher Holder Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-switcher' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h5',
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-swither-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-swither-title',
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'switcher_style',
					'title'         => esc_html__( 'Switcher Style', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'rounded' => esc_html__( 'Rounded', 'qi-addons-for-elementor-premium' ),
						'square'  => esc_html__( 'Square', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'rounded',
					'group'         => esc_html__( 'Switcher Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'switcher_button_background_color',
					'title'      => esc_html__( 'Button Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-switch .qodef-e-slider:before' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Switcher Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'switcher_button_border_color',
					'title'      => esc_html__( 'Button Border Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-switch .qodef-e-slider:before' => 'border: 1px solid {{VALUE}};',
					),
					'group'      => esc_html__( 'Switcher Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'number',
					'name'       => 'switcher_button_border_width',
					'title'      => esc_html__( 'Button Border Width', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-switch .qodef-e-slider:before' => 'border-width: {{VALUE}}px;',
					),
					'group'      => esc_html__( 'Switcher Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'switcher_background_color',
					'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-switch .qodef-e-slider' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Switcher Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'switcher_border_color',
					'title'      => esc_html__( 'Border Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-switch .qodef-e-slider' => 'border-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Switcher Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'number',
					'name'       => 'switcher_border_width',
					'title'      => esc_html__( 'Border Width', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-switch .qodef-e-slider' => 'border-width: {{VALUE}}px;',
						'{{WRAPPER}} .qodef-e-switch .qodef-e-slider:before' => 'width: calc( 24px - 2*{{VALUE}}px); height: calc( 24px - 2*{{VALUE}}px);',
					),
					'group'      => esc_html__( 'Switcher Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'switcher_margin_left_right',
					'title'      => esc_html__( 'Switcher Margin Left/Right', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-switch' => 'margin: 0 {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'switcher_margin_bottom',
					'title'      => esc_html__( 'Switcher Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-switcher' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'switcher_padding',
					'title'      => esc_html__( 'Switcher Holder Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-switcher' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/advanced-toggle', 'templates/advanced-toggle', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-advanced-toggle';
			$holder_classes[] = ! empty( $atts['switcher_style'] ) ? 'qodef-switcher--' . $atts['switcher_style'] : '';

			return implode( ' ', $holder_classes );
		}
	}
}
