<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_animated_device_slider_shortcode' ) ) {
	/**
	 * Function that add animated device slider for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_animated_device_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Animated_Device_Slider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_animated_device_slider_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Animated_Device_Slider_Shortcode extends QiAddonsForElementor_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/animated-device-slider' );
			$this->set_base( 'qi_addons_for_elementor_premium_animated_device_slider' );
			$this->set_name( esc_html__( 'Animated Device Slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays animated device slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/animated-device-slider/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#animated_device_slider' );
			$this->set_video( 'https://www.youtube.com/watch?v=IE6zc2fHSt0' );
			$this->set_scripts(
				array(
					'swiper' => array(
						'registered' => true,
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'note',
					'name'       => 'warning',
					'title'      => esc_html__( 'Please note that this widget can be used only as a standalone widget on a page', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_phone_frame',
					'title'         => esc_html__( 'Enable Phone Frame', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'image',
					'name'          => 'phone_frame_image',
					'default_value' => array( '' ),
					'title'         => esc_html__( 'Phone Frame Image', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'enable_phone_frame' => array(
								'values'        => 'yes',
								'default_value' => 'yes',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'background',
					'name'       => 'background_image',
					'title'      => esc_html__( 'Background Image', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-holder',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'background',
					'name'       => 'stripe_background_color',
					'title'      => esc_html__( 'Stripe Background Color', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-stripe',
					'group'      => esc_html__( 'Stripe Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_tagline_line',
					'title'         => esc_html__( 'Enable Tagline Line', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'contact_form_title',
					'title'      => esc_html__( 'Contact Form Title', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Last Slide', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'contact_form_subtitle',
					'title'      => esc_html__( 'Contact Form Subtitle', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Last Slide', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'textarea',
					'name'       => 'contact_form_text',
					'title'      => esc_html__( 'Contact Form Text', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Last Slide', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'contact_form_id',
					'title'      => esc_html__( 'Select Contact Form 7', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_framework_is_installed( 'contact_form_7' ) ? qi_addons_for_elementor_get_contact_form_7_forms() : array(),
					'group'      => esc_html__( 'Last Slide', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'background',
					'name'       => 'last_slide_form_background',
					'title'      => esc_html__( 'Form Background', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-contact-form',
					'group'      => esc_html__( 'Last Slide', 'qi-addons-for-elementor-premium' ),
				)
			);

			if ( ! qi_addons_for_elementor_framework_is_installed( 'contact_form_7' ) ) {
				$this->import_shortcode_options(
					array(
						'shortcode_base'    => 'qi_addons_for_elementor_button',
						'exclude'           => array( 'custom_class' ),
						'additional_params' => array(
							'nested_group' => esc_html__( 'Last Slide Button', 'qi-addons-for-elementor-premium' ),
						),
					)
				);
			}

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_app_store_link',
					'title'         => esc_html__( 'Enable App Store Link', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'group'         => esc_html__( 'App Buttons', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'app_store_background_color',
					'title'      => esc_html__( 'App Store Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-info .qodef-m-frame-info-other a.qodef-m-item-app-store-link' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'enable_app_store_link' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'App Buttons', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'image',
					'name'          => 'app_store_image',
					'title'         => esc_html__( 'App Store Image', 'qi-addons-for-elementor-premium' ),
					'default_value' => array( '' ),
					'dependency'    => array(
						'show' => array(
							'enable_app_store_link' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'         => esc_html__( 'App Buttons', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'app_store_link',
					'title'      => esc_html__( 'App Store Link', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'enable_app_store_link' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'App Buttons', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_play_store_link',
					'title'         => esc_html__( 'Enable Google Play Store Link', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'group'         => esc_html__( 'App Buttons', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'play_store_background_color',
					'title'      => esc_html__( 'Google Play Store Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-info .qodef-m-frame-info-other a.qodef-m-item-play-store-link' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'enable_play_store_link' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'App Buttons', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'image',
					'name'          => 'play_store_image',
					'title'         => esc_html__( 'Google Play Image', 'qi-addons-for-elementor-premium' ),
					'default_value' => array( '' ),
					'dependency'    => array(
						'show' => array(
							'enable_play_store_link' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'         => esc_html__( 'App Buttons', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'play_store_link',
					'title'      => esc_html__( 'Google Play Store Link', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'enable_play_store_link' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'App Buttons', 'qi-addons-for-elementor-premium' ),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Image Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_title'   => esc_html__( 'Item Title 1', 'qi-addons-for-elementor-premium' ),
							'item_text'    => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
							'item_tagline' => esc_html__( 'Item Tagline 1', 'qi-addons-for-elementor-premium' ),
							'item_image'   => $placeholder,
						),
						array(
							'item_title'   => esc_html__( 'Item Title 2', 'qi-addons-for-elementor-premium' ),
							'item_text'    => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
							'item_tagline' => esc_html__( 'Item Tagline 2', 'qi-addons-for-elementor-premium' ),
							'item_image'   => $placeholder,
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'text',
							'name'          => 'item_title',
							'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Item Title', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'textarea',
							'name'          => 'item_text',
							'title'         => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
						),
						array(
							'field_type' => 'image',
							'name'       => 'item_decoration',
							'title'      => esc_html__( 'Decoration', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_tagline',
							'title'         => esc_html__( 'Tagline', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Item Tagline', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
					),
				)
			);

			//Frame style
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'frame_size',
					'title'      => esc_html__( 'Frame size', 'qi-addons-for-elementor-premium' ),
					'responsive' => true,
					'size_units' => array( 'vh', 'px' ),
					'range'      => array(
						'vh' => array(
							'min' => 10,
							'max' => 100,
						),
					),
					'default_value'    => array(
						'unit' => 'vh',
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-holder' => 'height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Frame Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'frame_image_width',
					'title'      => esc_html__( 'Frame Image Width', 'qi-addons-for-elementor-premium' ),
					'responsive' => true,
					'size_units' => array( '%', 'px' ),
					'default_value'    => array(
						'unit' => '%',
					),
					'range'      => array(
						'%' => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-holder .qodef-m-inner-frame' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Frame Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'frame_image_height',
					'title'      => esc_html__( 'Frame Image Height', 'qi-addons-for-elementor-premium' ),
					'responsive' => true,
					'size_units' => array( '%', 'px' ),
					'default_value'    => array(
						'unit' => '%',
					),
					'range'      => array(
						'%' => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-holder .qodef-m-inner-frame' => 'height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Frame Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'frame_image_border_radius',
					'title'      => esc_html__( 'Frame Image Border Radius', 'qi-addons-for-elementor-premium' ),
					'responsive' => true,
					'size_units' => array( 'px', '%' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-holder .qodef-m-inner-frame img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Frame Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			//Title style
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'title_tag',
					'title'      => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-frame-title',
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			//Text style
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'text_tag',
					'title'      => esc_html__( 'Text Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-text' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-frame-text',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			//Tagline style
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'tagline_tag',
					'title'      => esc_html__( 'Tagline Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Tagline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'tagline_color',
					'title'      => esc_html__( 'Tagline Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-slide-tagline' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Tagline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'tagline_typography',
					'title'      => esc_html__( 'Tagline Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-frame-slide-tagline',
					'group'      => esc_html__( 'Tagline Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			//Decoration style
			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'decoration_position',
					'title'              => esc_html__( 'Decoration Position', 'qi-addons-for-elementor-premium' ),
					'group'              => esc_html__( 'Decoration Style', 'qi-addons-for-elementor-premium' ),
					'allowed_dimensions' => array( 'top', 'left' ),
					'size_units'         => array( 'px', '%' ),
					'responsive'         => true,
					'selectors'          => array(
						'{{WRAPPER}} .qodef-m-frame-decoration' => 'top: {{TOP}}{{UNIT}}; left: {{LEFT}}{{UNIT}};',
					),
				)
			);

			//Number style
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'number_tag',
					'title'      => esc_html__( 'Number Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Number Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'number_color',
					'title'      => esc_html__( 'Number Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-slide-number' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Number Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'number_typography',
					'title'      => esc_html__( 'Number Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-frame-slide-number',
					'group'      => esc_html__( 'Number Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			//Bullet options
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'bullet_color',
					'title'      => esc_html__( 'Bullet Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .swiper-pagination-bullet' => 'background: {{VALUE}};',
					),
					'group'      => esc_html__( 'Bullet Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'bullet_active_color',
					'title'      => esc_html__( 'Active Bullet Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .swiper-pagination-bullet-active' => 'background: {{VALUE}};',
					),
					'group'      => esc_html__( 'Bullet Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'bullet_opacity',
					'title'      => esc_html__( 'Bullet Opacity', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( '%' ),
					'range'      => array(
						'%' => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .swiper-pagination-bullet' => 'opacity: {{SIZE}}%;',
					),
					'group'      => esc_html__( 'Bullet Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'bullet_spacing',
					'title'      => esc_html__( 'Bullet Spacing', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'selectors'  => array(
						'{{WRAPPER}} .swiper-pagination-bullet' => 'margin-top: {{SIZE}}{{UNIT}}; margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Bullet Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'bullet_offset_from_edge',
					'title'      => esc_html__( 'Bullet Offset from Edge', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .swiper-container-vertical > .swiper-pagination-bullets' => 'right: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Bullet Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			//Spacing style
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-text' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			//Content position
			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'content_position_tabs',
					'title'      => esc_html__( 'Content Position Tabs', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'content_position_tabs_odd',
					'title'      => esc_html__( 'Odd', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'info_top_horizontal_alignment',
					'title'         => esc_html__( 'Basic Info Horizontal Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'left'  => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'right' => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'left',
					'group'         => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'info_top_horizontal_offset',
					'title'      => esc_html__( 'Basic Info Horizontal Position', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 500,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-info-top' => 'left: auto; right: auto; {{info_top_horizontal_alignment.value}}: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'info_top_vertical_alignment',
					'title'         => esc_html__( 'Basic Info Vertical Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'top'    => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
						'bottom' => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'top',
					'group'         => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'info_top_vertical_offset',
					'title'      => esc_html__( 'Basic Info Vertical Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 500,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-info-top' => 'top: auto; bottom: auto; {{info_top_vertical_alignment.value}}: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'info_bottom_horizontal_alignment',
					'title'         => esc_html__( 'Additional Info Horizontal Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'left'  => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'right' => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'left',
					'group'         => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'info_bottom_horizontal_offset',
					'title'      => esc_html__( 'Additional Info Horizontal Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 500,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-info-bottom' => 'left: auto; right: auto; {{info_bottom_horizontal_alignment.value}}: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'info_bottom_vertical_alignment',
					'title'         => esc_html__( 'Additional Info Vertical Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'top'    => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
						'bottom' => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'top',
					'group'         => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'info_bottom_vertical_offset',
					'title'      => esc_html__( 'Additional Info Vertical Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 500,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-info-bottom' => 'top: auto; bottom: auto; {{info_bottom_vertical_alignment.value}}: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'content_position_tabs_odd_end',
					'title'      => esc_html__( 'Odd End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'content_position_tabs_even',
					'title'      => esc_html__( 'Even', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'info_top_horizontal_alignment_even',
					'title'         => esc_html__( 'Basic Info Horizontal Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'left'  => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'right' => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'left',
					'group'         => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'info_top_horizontal_offset_even',
					'title'      => esc_html__( 'Basic Info Horizontal Position', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 500,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-even .qodef-m-frame-info-top' => 'left: auto; right: auto; {{info_top_horizontal_alignment_even.value}}: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'info_top_vertical_alignment_even',
					'title'         => esc_html__( 'Basic Info Vertical Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'top'    => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
						'bottom' => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'top',
					'group'         => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'info_top_vertical_offset_even',
					'title'      => esc_html__( 'Basic Info Vertical Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 500,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-even .qodef-m-frame-info-top' => 'top: auto; bottom: auto; {{info_top_vertical_alignment_even.value}}: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'info_bottom_horizontal_alignment_even',
					'title'         => esc_html__( 'Additional Info Horizontal Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'left'  => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'right' => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'left',
					'group'         => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'info_bottom_horizontal_offset_even',
					'title'      => esc_html__( 'Additional Info Horizontal Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 500,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-even .qodef-m-frame-info-bottom' => 'left: auto; right: auto; {{info_bottom_horizontal_alignment_even.value}}: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'info_bottom_vertical_alignment_even',
					'title'         => esc_html__( 'Additional Info Vertical Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'top'    => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
						'bottom' => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'top',
					'group'         => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'info_bottom_vertical_offset_even',
					'title'      => esc_html__( 'Additional Info Vertical Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 500,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-frame-even .qodef-m-frame-info-bottom' => 'top: auto; bottom: auto; {{info_bottom_vertical_alignment_even.value}}: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'content_position_tabs_even_end',
					'title'      => esc_html__( 'Even End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'content_position_tabs_end',
					'title'      => esc_html__( 'Content Position Tabs End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
				)
			);

			//Last Slide style
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'last_slide_title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-contact-form-info .qodef-m-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Last Slide Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'last_slide_title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-contact-form-info .qodef-m-title',
					'group'      => esc_html__( 'Last Slide Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'last_slide_subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-contact-form-info .qodef-m-subtitle' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Last Slide Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'last_slide_subtitle_typography',
					'title'      => esc_html__( 'Subtitle Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-contact-form-info .qodef-m-subtitle',
					'group'      => esc_html__( 'Last Slide Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'last_slide_text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-contact-form-info .qodef-m-text' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Last Slide Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'last_slide_text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-contact-form-info .qodef-m-text',
					'group'      => esc_html__( 'Last Slide Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'last_slide_info_width',
					'title'      => esc_html__( 'Info Width', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Last Slide Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-contact-form-info' => 'width: {{SIZE}}%;',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'subtitle_title_space',
					'title'      => esc_html__( 'Space Between Subtitle and Title', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Last Slide Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-contact-form-info .qodef-m-title' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_text_space',
					'title'      => esc_html__( 'Space Between Title and Text', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Last Slide Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-contact-form-info .qodef-m-text' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'contact_form_margin_top',
					'title'      => esc_html__( 'Margin Above Contact Form Button', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Last Slide Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-contact-form .qodef-m-button' => 'margin-top: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-m-contact-form .wpcf7' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->map_extra_options();
		}

		public function load_assets() {
			wp_enqueue_script( 'swiper' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']           = $this->get_holder_classes( $atts );
			$atts['items']                    = $this->parse_repeater_items( $atts['children'] );
			$atts['last_slide_button_params'] = $this->generate_button_params( $atts );
			$atts['this_shortcode']           = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/animated-device-slider', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-animated-device-slider qodef-animated-device-slider-ready-animation';

			$holder_classes[] = 'no' === $atts['enable_phone_frame'] ? 'qodef-animated-device-slider-no-frame' : '';

			return implode( ' ', $holder_classes );
		}

		private function generate_button_params( $atts ) {

			$button_params = $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'qi_addons_for_elementor_button',
					'exclude'        => array( 'custom_class' ),
					'atts'           => $atts,
				)
			);

			return $button_params;
		}
	}
}
