<?php
$tagline_tag = isset( $tagline_tag ) && ! empty( $tagline_tag ) ? $tagline_tag : 'p';
$title_tag   = isset( $title_tag ) && ! empty( $title_tag ) ? $title_tag : 'h4';
$text_tag    = isset( $text_tag ) && ! empty( $text_tag ) ? $text_tag : 'p';
$number_tag  = isset( $number_tag ) && ! empty( $number_tag ) ? $number_tag : 'p';
?>
<div <?php qi_addons_for_elementor_framework_class_attribute( $holder_classes ); ?>>
	<div class="qodef-m-holder">
		<div class="qodef-m-stripe"></div>
		<div class="qodef-m-frame-holder">
			<div class="qodef-m-frame-mobile-holder">
				<?php if ( isset( $phone_frame_image ) && ! empty( $phone_frame_image ) ) { ?>
					<?php echo wp_get_attachment_image( $phone_frame_image, 'full' ); ?>
				<?php } else { ?>
					<img src="<?php echo QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/animated-device-slider/assets/img/mobile-frame.png'; ?>" alt="<?php esc_attr_e( 'Mobile Frame Image', 'qi-addons-for-elementor-premium' ); ?>">
				<?php } ?>
				<div class="qodef-m-inner-frame"></div>
			</div>
		</div>
		<div class="qodef-m-frame-info qodef-m-frame-animate-out">
			<div class="qodef-m-frame-info-top">
				<div class="qodef-m-frame-decoration"></div>
				<div class="qodef-m-frame-content">
					<a itemprop="url" class="qodef-m-frame-link">
						<<?php echo qi_addons_for_elementor_framework_sanitize_tags( $title_tag ); ?> class="qodef-m-frame-title"></<?php echo qi_addons_for_elementor_framework_sanitize_tags( $title_tag ); ?>>
					</a>
					<div class="qodef-m-info-text">
						<<?php echo qi_addons_for_elementor_framework_sanitize_tags( $text_tag ); ?> class="qodef-m-frame-text"></<?php echo qi_addons_for_elementor_framework_sanitize_tags( $text_tag ); ?>>
					</div>
				</div>
			</div>
			<div class="qodef-m-frame-info-bottom">
				<<?php echo qi_addons_for_elementor_framework_sanitize_tags( $number_tag ); ?> class="qodef-m-frame-slide-number">01</<?php echo qi_addons_for_elementor_framework_sanitize_tags( $number_tag ); ?>>
				<div class="qodef-m-frame-slide-info">
					<<?php echo qi_addons_for_elementor_framework_sanitize_tags( $tagline_tag ); ?> class="qodef-m-frame-slide-tagline"></<?php echo qi_addons_for_elementor_framework_sanitize_tags( $tagline_tag ); ?>>
					<?php if ( 'yes' === $enable_tagline_line ) { ?>
						<div class="qodef-m-frame-slide-decoration"></div>
					<?php } ?>
				</div>
			</div>
			<?php qi_addons_for_elementor_premium_template_part( 'shortcodes/animated-device-slider', 'templates/parts/app-buttons', '', $params ); ?>
		</div>
		<div class="swiper-container">
			<div class="swiper-wrapper">
				<?php if ( ! empty( $items ) ) { ?>
					<?php
					foreach ( $items as $item ) :
						$item['title_tag']   = $title_tag;
						$item['tagline_tag'] = $tagline_tag;
						$item['text_tag']    = $tagline_tag;
						?>
						<div class="swiper-slide">
							<div class="qodef-m-item">
								<?php qi_addons_for_elementor_premium_template_part( 'shortcodes/animated-device-slider', 'templates/parts/image', '', $item ); ?>
								<div class="qodef-m-item-info">
									<?php qi_addons_for_elementor_premium_template_part( 'shortcodes/animated-device-slider', 'templates/parts/title', '', $item ); ?>
									<?php qi_addons_for_elementor_premium_template_part( 'shortcodes/animated-device-slider', 'templates/parts/text', '', $item ); ?>
									<?php qi_addons_for_elementor_premium_template_part( 'shortcodes/animated-device-slider', 'templates/parts/decoration', '', $item ); ?>
									<?php qi_addons_for_elementor_premium_template_part( 'shortcodes/animated-device-slider', 'templates/parts/tagline', '', $item ); ?>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
					<?php qi_addons_for_elementor_premium_template_part( 'shortcodes/animated-device-slider', 'templates/parts/swiper', '', $params ); ?>
				<?php } ?>
			</div>
			<div class="swiper-pagination qodef-custom-pagination"></div>
		</div>
	</div>
</div>
