<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_author_info_variation_background' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_author_info_variation_background( $variations ) {
		$variations['background'] = esc_html__( 'Background', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_filter_author_info_layouts', 'qi_addons_for_elementor_premium_add_author_info_variation_background' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_author_info_render' ) ) {
	function qi_addons_for_elementor_premium_author_info_render( $template, $atts ) {
		if ( 'background' === $atts['layout'] ) {
			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/author-info', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		} else {
			return $template;
		}
	}

	add_filter( 'qi_addons_for_elementor_filter_author_info_render_template', 'qi_addons_for_elementor_premium_author_info_render', 10, 2 );
}
