<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_business_reviews_google_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param $shortcodes array
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_business_reviews_google_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Business_Reviews_Google_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_business_reviews_google_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Slider_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Business_Reviews_Google_Shortcode extends QiAddonsForElementor_List_Shortcode {

		public function __construct() {

			$this->set_layouts( apply_filters( 'qi_addons_for_elementor_premium_filter_business_reviews_google_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_business_reviews_google_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/business-reviews-google' );
			$this->set_base( 'qi_addons_for_elementor_premium_business_reviews_google' );
			$this->set_name( esc_html__( 'Business Reviews Google', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that adds circular slider element', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'SEO', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/business-reviews-google/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#business_reviews_google' );
			$this->set_necessary_styles( qi_addons_for_elementor_icon_necessary_styles() );
			$this->set_option(
				array(
					'field_type' => 'note',
					'name'       => 'warning',
					'title'      => esc_html__( 'Please note that for this widget Google Places Api key must be inserted in Integration page', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'place_id',
					'title'      => esc_html__( 'Place ID', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->map_list_options(
				array(
					'exclude_option'  => array( 'images_proportion', 'enable_pagination' ),
					'exclude_columns' => array( '6', '8' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'items_number',
					'title'         => esc_html__( 'Number Of Reviews', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Note that the maximum number of reviews is 5', 'qi-addons-for-elementor-premium' ),
					'default_value' => 5,
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'reviews_translations',
					'title'         => esc_html__( 'Enable Automatic Translation', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'If disabled, the reviews will be displayed in the language they were originally posted in', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
				)
			);

			// Icons options
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'review_marked_icon',
					'title'         => esc_html__( 'Marked Icon', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-star',
						'library' => 'solid',
					),
					'group'         => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'review_unmarked_icon',
					'title'         => esc_html__( 'Unmarked Icon', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'far fa-star',
						'library' => 'regular',
					),
					'group'         => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'drop_shadow',
					'title'      => esc_html__( 'Enable Drop Shadow', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'dependency' => array(
						'show' => array(
							'layout' => array(
								'values'        => array( 'boxed', 'boxed-centered' ),
								'default-value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'slider',
					'name'          => 'review_icon_size',
					'title'         => esc_html__( 'Icon Size', 'qi-addons-for-elementor-premium' ),
					'size_units'    => array( 'px' ),
					'responsive'    => true,
					'min'           => 0,
					'max'           => 100,
					'step'          => 1,
					'default_value' => array(
						'unit' => 'px',
						'size' => '16',
					),
					'selectors'     => array(
						'{{WRAPPER}} .qodef-e-icon > *, {{WRAPPER}} .qodef-e-icon > svg' => 'font-size: {{SIZE}}px; width: {{SIZE}}px;',
					),
					'group'         => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'slider',
					'name'          => 'review_split_unmarked_size',
					'title'         => esc_html__( 'Icon Unmarked Size', 'qi-addons-for-elementor-premium' ),
					'size_units'    => array( 'px' ),
					'responsive'    => true,
					'min'           => 0,
					'max'           => 100,
					'step'          => 1,
					'default_value' => array(
						'unit' => 'px',
						'size' => '16',
					),
					'selectors'     => array(
						'{{WRAPPER}} .qodef-e-icon.qodef-e-icon-unmarked > *, {{WRAPPER}} .qodef-e-icon.qodef-e-icon-unmarked > svg' => 'font-size: {{SIZE}}px; width: {{SIZE}}px;',
					),
					'group'         => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'rating_marked_color',
					'title'      => esc_html__( 'Marked Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-icon-marked' => 'color: {{VALUE}}; fill: {{VALUE}}; stroke: {{VALUE}};',
					),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'rating_unmarked_color',
					'title'      => esc_html__( 'Unmarked Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-icon-unmarked' => 'color: {{VALUE}}; fill: {{VALUE}}; stroke: {{VALUE}};',
					),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			// Title Options
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-title',
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			//Spacing Options
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_margin_bottom',
					'title'      => esc_html__( 'Title Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_margin_top',
					'title'      => esc_html__( 'Title Margin Top', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-title' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_margin_right',
					'title'      => esc_html__( 'Icon Margin Right', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-icon > *' => 'margin-right: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'text_margin_bottom',
					'title'      => esc_html__( 'Text Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-text' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'rating_margin_bottom',
					'title'      => esc_html__( 'Rating Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-rating' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'rating_margin_top',
					'title'      => esc_html__( 'Rating Margin Top', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-rating' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			//Text Options
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_length',
					'title'      => esc_html__( 'Text Length', 'qi-addons-for-elementor-premium' ),
					'dynamic'    => false,
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'item_text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-text' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'item_text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-text',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			//Time Options
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'item_time_color',
					'title'      => esc_html__( 'Time Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-time' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Time Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'item_time_typography',
					'title'      => esc_html__( 'Time Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-time',
					'group'      => esc_html__( 'Time Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_layout_options(
				array(
					'layouts'        => $this->get_layouts(),
					'exclude_option' => array( 'title_tag', 'title_color', 'title_hover_color', 'title_typography' ),
				)
			);
			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items_number'] = $atts['items_number'] > 5 ? '5' : $atts['items_number'];
			$atts['reviews']        = $this->get_reviews( $atts );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/business-reviews-google', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-business-reviews-google';
			$holder_classes[] = ! empty( $atts['drop_shadow'] ) && 'yes' === $atts['drop_shadow'] ? 'qodef-qi--drop-shadow' : '';

			$list_classes   = $this->get_list_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $list_classes );

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$list_item_classes = $this->get_list_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		public function get_reviews( $params ) {
			$place_id       = $params['place_id'];
			$unique         = wp_unique_id();
			$api_keys       = get_option( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_INTEGRATION_KEYS );
			$google_api_key = is_array( $api_keys ) && isset( $api_keys['google_places_api_key'] ) ? $api_keys['google_places_api_key'] : '';

			if ( '' !== $place_id && ! empty( $google_api_key ) ) {

				$transient_name = 'qi_addons_for_elementor_premium_google_reviews_' . $unique;

				$parameters = "key=$google_api_key&placeid=$place_id";

				if ( ! empty( $params['reviews_translations'] ) && 'no' === $params['reviews_translations']  ) {
					$parameters .= "&reviews_no_translations=true";
				}

				$url = "https://maps.googleapis.com/maps/api/place/details/json?$parameters";

				$google_transient = get_transient( $transient_name );

				$google_transient['id'] = isset( $google_transient['id'] ) ? $google_transient['id'] : '';

				if ( false === $google_transient || $place_id !== $google_transient['id'] ) {

					$result = wp_remote_get(
						$url,
						array(
							'method'      => 'GET',
							'timeout'     => 120,
							'httpversion' => '1.0',
							'user-agent'  => '',
							'headers'     => array(
								'Authorization' => 'Bearer ' . $google_api_key,
							),
						)
					);

					if ( is_wp_error( $result ) ) {
						$error_message = $result->get_error_message();
						echo 'Problem' . $error_message;
					} else {

						$response_code    = wp_remote_retrieve_response_code( $result );
						$response_message = wp_remote_retrieve_response_message( $result );

						$response_body = json_decode( $result['body'] );

						if ( 200 !== $response_code && ! empty( $response_message ) ) {
							$error_code = $response_body->error->code;
							if ( 'VALIDATION_ERROR' === $error_code ) {

								$message = esc_html__( 'Google Error Message: Incorrect Google API key. Please set up the API key', 'qi-addons-for-elementor-premium' );

							} elseif ( 'BUSINESS_NOT_FOUND' === $error_code ) {

								$message = esc_html__( 'Google Error Message: Incorrect Business ID', 'qi-addons-for-elementor-premium' );

							}

							$reviews['error']   = true;
							$reviews['message'] = $message;
						} elseif ( 200 !== $response_code ) {
							$reviews['error']   = true;
							$reviews['message'] = esc_html__( 'Error Occured', 'qi-addons-for-elementor-premium' );
						} elseif ( 'INVALID_REQUEST' === $response_body->status ) {
							$reviews['error']   = true;
							$reviews['message'] = esc_html__( 'Google Error Message: Incorrect Business ID', 'qi-addons-for-elementor-premium' );
						} elseif ( 'REQUEST_DENIED' === $response_body->status ) {
							$reviews['error']   = true;
							$reviews['message'] = $response_body->error_message;
						}else {
							$reviews = $response_body->result->reviews;
							if ( count( $reviews ) ) {
								$reviews['id'] = $place_id;
								set_transient( $transient_name, $reviews, 2 * DAY_IN_SECONDS );
							}
						}
					}
				} else {
					$reviews = $google_transient;
				}
				return $reviews;
			}
			return array();
		}

	}
}
