<div class="qodef-e-time">
	<?php
	$review_date  = new DateTime( "@$review->time" );
	$current_date = new DateTime();

	$difference = $current_date->diff( $review_date );
	$format     = '%d %s ' . esc_html__( 'ago', 'qi-addons-for-elementor-premium' );

	switch ( $difference ) {
		case $difference->y > 0:
			$time_interval = 1 === $difference->y ? esc_html__( 'year', 'qi-addons-for-elementor-premium' ) : esc_html__( 'years', 'qi-addons-for-elementor-premium' );
			$message       = sprintf( $format, $difference->y, $time_interval );
			break;
		case $difference->m > 0:
			$time_interval = 1 === $difference->m ? esc_html__( 'month', 'qi-addons-for-elementor-premium' ) : esc_html__( 'months', 'qi-addons-for-elementor-premium' );
			$message       = sprintf( $format, $difference->m, $time_interval );
			break;
		case $difference->d > 0:
			$time_interval = 1 === $difference->d ? esc_html__( 'day', 'qi-addons-for-elementor-premium' ) : esc_html__( 'days', 'qi-addons-for-elementor-premium' );
			$message       = sprintf( $format, $difference->d, $time_interval );
			break;
		case $difference->h > 0:
			$time_interval = 1 === $difference->h ? esc_html__( 'hour', 'qi-addons-for-elementor-premium' ) : esc_html__( 'hours', 'qi-addons-for-elementor-premium' );
			$message       = sprintf( $format, $difference->h, $time_interval );
			break;
		case $difference->i > 0:
			$time_interval = 1 === $difference->i ? esc_html__( 'minute', 'qi-addons-for-elementor-premium' ) : esc_html__( 'minutes', 'qi-addons-for-elementor-premium' );
			$message       = sprintf( $format, $difference->i, $time_interval );
			break;
		default:
			$message = '';
	}
	?>
	<span><?php echo esc_html( $message ); ?></span>
</div>
