<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_business_reviews_google_variation_boxed_centered' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_business_reviews_google_variation_boxed_centered( $variations ) {
		$variations['boxed-centered'] = esc_html__( 'Boxed Centered', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_business_reviews_google_layouts', 'qi_addons_for_elementor_premium_add_business_reviews_google_variation_boxed_centered' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_business_reviews_google_boxed_centered_options' ) ) {
	/**
	 * Function that add additional options for variation layout
	 *
	 * @param array $options
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_business_reviews_google_boxed_centered_options( $options ) {
		$boxed_centered = array();

		$box_border_radius = array(
			'field_type' => 'dimensions',
			'name'       => 'boxed_centered_border_radius',
			'title'      => esc_html__( 'Border Radius', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--boxed-centered .qodef-e-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'boxed-centered',
						'default-value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
		);

		$padding = array(
			'field_type' => 'dimensions',
			'name'       => 'boxed_centered_padding',
			'title'      => esc_html__( 'Padding', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--boxed-centered .qodef-e-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'boxed-centered',
						'default-value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
		);

		$background_color = array(
			'field_type' => 'color',
			'name'       => 'boxed_centered_background_color',
			'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--boxed-centered .qodef-e-inner' => 'background-color: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'boxed-centered',
						'default-value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
		);

		$boxed_centered[] = $padding;
		$boxed_centered[] = $box_border_radius;
		$boxed_centered[] = $background_color;

		return array_merge( $options, $boxed_centered );
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_business_reviews_google_extra_options', 'qi_addons_for_elementor_premium_add_business_reviews_google_boxed_centered_options' );
}
