<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_business_reviews_google_variation_boxed' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_business_reviews_google_variation_boxed( $variations ) {
		$variations['boxed'] = esc_html__( 'Boxed', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_business_reviews_google_layouts', 'qi_addons_for_elementor_premium_add_business_reviews_google_variation_boxed' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_business_reviews_google_boxed_options' ) ) {
	/**
	 * Function that add additional options for variation layout
	 *
	 * @param array $options
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_business_reviews_google_boxed_options( $options ) {
		$boxed = array();

		$box_border_radius = array(
			'field_type' => 'dimensions',
			'name'       => 'boxed_border_radius',
			'title'      => esc_html__( 'Border Radius', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--boxed-centered .qodef-e-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'boxed',
						'default-value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
		);

		$padding = array(
			'field_type' => 'dimensions',
			'name'       => 'boxed_padding',
			'title'      => esc_html__( 'Padding', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--boxed-centered .qodef-e-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'boxed',
						'default-value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
		);

		$background_color = array(
			'field_type' => 'color',
			'name'       => 'boxed_background_color',
			'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-item-layout--boxed .qodef-e-inner' => 'background-color: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'boxed',
						'default-value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
		);

		$boxed[] = $padding;
		$boxed[] = $box_border_radius;
		$boxed[] = $background_color;

		return array_merge( $options, $boxed );
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_business_reviews_google_extra_options', 'qi_addons_for_elementor_premium_add_business_reviews_google_boxed_options' );
}
