<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_business_reviews_google_variation_info_right' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_business_reviews_google_variation_info_right( $variations ) {
		$variations['info-right'] = esc_html__( 'Info Right', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_business_reviews_google_layouts', 'qi_addons_for_elementor_premium_add_business_reviews_google_variation_info_right' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_business_reviews_google_variation_info_right_options' ) ) {
	/**
	 * Function that add additional options for variation layout
	 *
	 * @param array $options
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_business_reviews_google_variation_info_right_options( $options ) {
		$info_right = array();

		$image_margin = array(
			'field_type' => 'slider',
			'name'       => 'image_margin_top',
			'title'      => esc_html__( 'Image Margin Top', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'em' ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-info-left' => 'margin-top: {{SIZE}}{{UNIT}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'info-right',
						'default-value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
		);

		$info_right[] = $image_margin;

		return array_merge( $options, $info_right );
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_business_reviews_google_extra_options', 'qi_addons_for_elementor_premium_add_business_reviews_google_variation_info_right_options' );
}
