<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_business_reviews_yelp_variation_centered' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_business_reviews_yelp_variation_centered( $variations ) {
		$variations['centered'] = esc_html__( 'Centered', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_business_reviews_yelp_layouts', 'qi_addons_for_elementor_premium_add_business_reviews_yelp_variation_centered' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_business_reviews_yelp_variation_centered_options' ) ) {
	/**
	 * Function that add additional options for variation layout
	 *
	 * @param array $options
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_business_reviews_yelp_variation_centered_options( $options ) {
		$centered = array();

		$enabled_image = array(
			'field_type'    => 'select',
			'name'          => 'enable_image',
			'title'         => esc_html__( 'Enable Image', 'qi-addons-for-elementor-premium' ),
			'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no' ),
			'default_value' => 'yes',
			'dependency'    => array(
				'show' => array(
					'layout' => array(
						'values'        => 'centered',
						'default-value' => '',
					),
				),
			),
			'group'         => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
		);

		$centered[] = $enabled_image;

		return array_merge( $options, $centered );
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_business_reviews_yelp_extra_options', 'qi_addons_for_elementor_premium_add_business_reviews_yelp_variation_centered_options' );
}
