<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_circled_slider_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param $shortcodes array
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_circled_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Circled_Slider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_circled_slider_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Slider_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Circled_Slider_Shortcode extends QiAddonsForElementor_Slider_Shortcode {

		public function __construct() {

			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_circled_slider_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/circled-slider' );
			$this->set_base( 'qi_addons_for_elementor_premium_circled_slider' );
			$this->set_name( esc_html__( 'Circled Slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that adds circled slider element', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#circled_slider' );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/circled-slider' );
			$this->set_video( 'https://www.youtube.com/watch?v=kwzysD78h2o' );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'items_padding',
					'title'      => esc_html__( 'Top/Bottom Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-item' => 'padding: {{SIZE}}{{UNIT}} 0;',
					),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Child elements', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_image' => $placeholder,
							'item_title' => esc_html__( 'Item Title 1', 'qi-addons-for-elementor-premium' ),
							'item_link'  => array(
								'url' => '#',
							),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type' => 'color',
							'name'       => 'item_color',
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}}.qodef-m-item' => 'background-color: {{VALUE}};',
							),
							'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_title',
							'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'title' ),
						),
						array(
							'field_type'  => 'text',
							'name'        => 'title_hightlight_words',
							'title'       => esc_html__( 'Highlight Word', 'qi-addons-for-elementor-premium' ),
							'description' => esc_html__( 'Enter the positions of the word you would like to display in different style (e.g. if you would like the third word to have highlight style, you would enter "3")', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_button_text',
							'title'         => esc_html__( 'Button Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'View more', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'image_horizontal_position',
					'title'      => esc_html__( 'Image Horizontal Position', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => -500,
							'max' => 500,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-circled-slider .qodef-m-item img' => 'left: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Main Image Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'image_width',
					'title'      => esc_html__( 'Image Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-circled-slider .qodef-m-item img' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Main Image Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_title',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-content .qodef-e-title',
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'content_left_offset',
					'title'      => esc_html__( 'Content Left Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 500,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-circled-slider .qodef-m-content' => 'left: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'content_width',
					'title'      => esc_html__( 'Content Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 700,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-circled-slider .qodef-m-content' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'bullet_right_offset',
					'title'      => esc_html__( 'Bullet Right Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 500,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .swiper-pagination-bullets' => 'right: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Bullet Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'bullet_border_size',
					'title'      => esc_html__( 'Bullet Border Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 50,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .swiper-pagination-bullets .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height: calc({{SIZE}}{{UNIT}} - 4px);',
					),
					'group'      => esc_html__( 'Bullet Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'bullet_border_color',
					'title'      => esc_html__( 'Bullet Border Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .swiper-pagination-bullets .swiper-pagination-bullet' => 'border: 1px solid {{VALUE}}; box-shadow: none;',
					),
					'group'      => esc_html__( 'Bullet Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'bullet_border_active_color',
					'title'      => esc_html__( 'Bullet Border Active Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .swiper-pagination-bullets .swiper-pagination-bullet svg path' => 'stroke: {{VALUE}};',
					),
					'group'      => esc_html__( 'Bullet Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'bullet_image_size',
					'title'      => esc_html__( 'Bullet Image Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 50,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .swiper-pagination-bullets .swiper-pagination-bullet img' => 'width: {{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Bullet Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'bullet_left_offset',
					'title'      => esc_html__( 'Space Between Bullets', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'vw' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 200,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .swiper-pagination-bullets .swiper-pagination-bullet' => 'margin-left: {{SIZE}}{{UNIT}}; margin-top: {{SIZE}}{{UNIT}} !important; margin-bottom: {{SIZE}}{{UNIT}} !important;',
					),
					'group'      => esc_html__( 'Bullet Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'button_margin_top',
					'title'      => esc_html__( 'Button Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content .qodef-qi-button' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class', 'button_text', 'button_link' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/circled-slider', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-circled-slider';
			$holder_classes[] = 'swiper-container-horizontal';

			return implode( ' ', $holder_classes );
		}

		public function generate_button_params( $atts, $item_params ) {
			if ( $item_params['item_link']['url'] ) {
				$atts['button_link'] = $item_params['item_link'];
				$atts['button_text'] = ! empty( $item_params['item_button_text'] ) ? esc_html( $item_params['item_button_text'] ) : esc_html__( 'Read More', 'qi-addons-for-elementor-premium' );

				$button_params = $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_button',
						'exclude'        => array( 'custom_class' ),
						'atts'           => $atts,
					)
				);

				return $button_params;
			}

			return array();
		}
	}
}
