<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_comparative_tables_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_comparative_tables_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Comparative_Tables_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_comparative_tables_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Comparative_Tables_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_comparative_tables_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/comparative-tables' );
			$this->set_base( 'qi_addons_for_elementor_premium_comparative_tables' );
			$this->set_name( esc_html__( 'Comparative Table', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays comparative tables', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Business', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/comparative-table/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#comparative_table' );
			$this->set_necessary_styles( qi_addons_for_elementor_icon_necessary_styles() );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'main_column_title',
					'title'         => esc_html__( 'Main Column Title', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Column Title', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'headings',
					'title'         => esc_html__( 'Headings', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'row_title' => esc_html__( 'Row 1', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'row_title' => esc_html__( 'Row 2', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'row_title' => esc_html__( 'Row 3', 'qi-addons-for-elementor-premium' ),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'text',
							'name'          => 'row_title',
							'title'         => esc_html__( 'Row Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Row', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Columns', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'column_title'      => esc_html__( 'Column Title 1', 'qi-addons-for-elementor-premium' ),
							'column_row_values' => esc_html__( '+, -, -', 'qi-addons-for-elementor-premium' ),
							'column_link'       => array(
								'url' => '#',
							),
							'column_link_text'  => esc_html__( 'Purchase', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'column_title'      => esc_html__( 'Column Title 2', 'qi-addons-for-elementor-premium' ),
							'column_row_values' => esc_html__( '-, -, +', 'qi-addons-for-elementor-premium' ),
							'column_link'       => array(
								'url' => '#',
							),
							'column_link_text'  => esc_html__( 'Purchase', 'qi-addons-for-elementor-premium' ),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'text',
							'name'          => 'column_title',
							'title'         => esc_html__( 'Column Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Column Title', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'column_row_values',
							'title'         => esc_html__( 'Rows Values', 'qi-addons-for-elementor-premium' ),
							'description'   => esc_html__( 'Enter pluses and minuses separated by comma', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( '+, -, +', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'link',
							'name'       => 'column_link',
							'title'      => esc_html__( 'Column Link', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'column_link_text',
							'title'         => esc_html__( 'Column Link Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Purchase', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'table_layout',
					'title'         => esc_html__( 'Table Layout', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'auto'  => esc_html__( 'Auto', 'qi-addons-for-elementor-premium' ),
						'fixed' => esc_html__( 'Fixed', 'qi-addons-for-elementor-premium' ),
					),
					'responsive'    => true,
					'default_value' => 'auto',
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-table' => 'table-layout: {{VALUE}};',
					),
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'minimal_width',
					'title'      => esc_html__( 'Minimal Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 1,
							'max' => 2000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table' => 'min-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'border_inside',
					'title'      => esc_html__( 'Border Style', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'all'    => esc_html__( 'All', 'qi-addons-for-elementor-premium' ),
						'inside' => esc_html__( 'Inside Only', 'qi-addons-for-elementor-premium' ),
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'border',
					'name'       => 'border',
					'title'      => esc_html__( 'Border', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-cell',
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'headings_cell_padding',
					'title'              => esc_html__( 'Column Title Cell Padding', 'qi-addons-for-elementor-premium' ),
					'allowed_dimensions' => array( 'top', 'bottom' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'responsive'         => true,
					'selectors'          => array(
						'{{WRAPPER}} .qodef-m-main-row .qodef-e-cell' => 'padding-top: {{TOP}}{{UNIT}}; padding-bottom: {{BOTTOM}}{{UNIT}};',
					),
					'group'              => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'cell_padding',
					'title'      => esc_html__( 'Cell Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-cell' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'first_column_width',
					'title'      => esc_html__( 'First Column Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 1,
							'max' => 2000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-cell:first-child' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'background_style',
					'title'      => esc_html__( 'Background Style', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'simple'        => esc_html__( 'Simple', 'qi-addons-for-elementor-premium' ),
						'row-content'   => esc_html__( 'Row - Content', 'qi-addons-for-elementor-premium' ),
						'title-content' => esc_html__( 'Title - Content', 'qi-addons-for-elementor-premium' ),
						'alternating'   => esc_html__( 'Alternating', 'qi-addons-for-elementor-premium' ),
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color',
					'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-background-style--simple .qodef-m-table' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--row-content .qodef-main-title' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--row-content .qodef-row-title' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--row-content .qodef-table-button:first-child' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--title-content .qodef-m-main-row' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--title-content .qodef-row-title' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--title-content .qodef-e-row:last-child' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--alternating .qodef-e-row:nth-child(2n+1)' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color_2',
					'title'      => esc_html__( 'Background Color Second', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'hide' => array(
							'background_style' => array(
								'values'        => 'simple',
								'default_value' => 'simple',
							),
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-background-style--row-content .qodef-e-content-column' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--title-content .qodef-sign' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-background-style--alternating .qodef-e-row:nth-child(2n)' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'title_tag',
					'title'      => esc_html__( 'Main Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Main Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Main Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-main-row .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Main Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Main Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-main-row .qodef-e-title',
					'group'      => esc_html__( 'Main Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'row_title_tag',
					'title'      => esc_html__( 'Row Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Row Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'row_title_color',
					'title'      => esc_html__( 'Row Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-row-title .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Row Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'row_title_typography',
					'title'      => esc_html__( 'Row Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-row-title .qodef-e-title',
					'group'      => esc_html__( 'Row Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'check_sign',
					'title'         => esc_html__( 'Check Sign', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(),
					'group'         => esc_html__( 'Sign Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'x_sign',
					'title'         => esc_html__( 'X Sign', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(),
					'group'         => esc_html__( 'Sign Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'check_sign_color',
					'title'      => esc_html__( 'Check Sign Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-sign.qodef--check' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Sign Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'check_sign_size',
					'title'      => esc_html__( 'Check Sign Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-sign.qodef--check' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Sign Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'x_sign_color',
					'title'      => esc_html__( 'X Sign Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-sign.qodef--x' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Sign Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'x_sign_size',
					'title'      => esc_html__( 'X Sign Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-sign.qodef--x' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Sign Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'hidden',
					'name'          => 'button_layout',
					'title'         => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'textual',
					'group'         => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array(
						'custom_class',
						'button_text',
						'button_link',
						'button_layout',
						'button_inner_border_style_tabs',
						'button_inner_border_normal',
						'button_inner_border_color',
						'button_inner_border_normal_end',
						'button_inner_border_hover',
						'button_inner_border_hover_color',
						'button_inner_border_hover_type',
						'button_inner_border_hover_end',
						'button_inner_border_style_tabs_end',
						'button_inner_border_divider',
						'button_inner_border_offset',
						'button_inner_border_width',
					),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_cell_background_color',
					'title'      => esc_html__( 'Button Cell Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-table-button .qodef-qi-button' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_cell_hover_background_color',
					'title'      => esc_html__( 'Button Cell Hover Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-table-button .qodef-qi-button:hover' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'button_padding',
					'title'              => esc_html__( 'Button Padding', 'qi-addons-for-elementor-premium' ),
					'allowed_dimensions' => array( 'top', 'bottom' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'responsive'         => true,
					'selectors'          => array(
						'{{WRAPPER}} .qodef-table-button .qodef-qi-button' => 'padding: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0 !important;',
					),
					'group'              => esc_html__( 'Button Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function load_assets() {
			parent::load_assets();

			qi_addons_for_elementor_icon_load_assets();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['heading_items']  = $this->parse_repeater_items( $atts['headings'] );
			$atts['column_items']   = $this->get_formatted_column_items( $this->parse_repeater_items( $atts['children'] ) );
			$atts['rows']           = count( $atts['heading_items'] );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/comparative-tables', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-comparative-tables';
			$holder_classes[] = ! empty( $atts['border_inside'] ) ? 'qodef-border--' . $atts['border_inside'] : '';
			$holder_classes[] = ! empty( $atts['background_style'] ) ? 'qodef-background-style--' . $atts['background_style'] : '';

			return implode( ' ', $holder_classes );
		}

		private function get_formatted_column_items( $items ) {
			foreach ( $items as $key => $item ) {
				$items[ $key ]['values'] = array_map( 'trim', explode( ',', $item['column_row_values'] ) );
			}

			return $items;
		}

		public function generate_button_params( $atts, $item_params ) {
			if ( $item_params['column_link']['url'] ) {
				$atts['button_link'] = $item_params['column_link'];
				$atts['button_text'] = ! empty( $item_params['column_link_text'] ) ? esc_html( $item_params['column_link_text'] ) : esc_html__( 'Purchase', 'qi-addons-for-elementor-premium' );

				$button_params = $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_button',
						'exclude'        => array(
							'custom_class',
							'button_inner_border_style_tabs',
							'button_inner_border_normal',
							'button_inner_border_color',
							'button_inner_border_normal_end',
							'button_inner_border_hover',
							'button_inner_border_hover_color',
							'button_inner_border_hover_type',
							'button_inner_border_hover_end',
							'button_inner_border_style_tabs_end',
							'button_inner_border_divider',
							'button_inner_border_offset',
							'button_inner_border_width',
						),
						'atts'           => $atts,
					)
				);

				return $button_params;
			}

			return array();
		}
	}
}
