<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_content_menu_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param $shortcodes array
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_content_menu_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Content_Menu_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_content_menu_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Slider_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Content_Menu_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {

			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_content_menu_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/content-menu' );
			$this->set_base( 'qi_addons_for_elementor_premium_content_menu' );
			$this->set_name( esc_html__( 'Content Menu', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that adds circular slider element', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Showcase', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/content-menu/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#content_menu' );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'menu',
					'title'      => esc_html__( 'Choose Menu', 'qi-addons-for-elementor-premium' ),
					'options'    => $this->get_menus_list(),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'horizontal' => esc_html__( 'Horizontal', 'qi-addons-for-elementor-premium' ),
						'vertical'   => esc_html__( 'Vertical', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'horizontal',
				)
			);

			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'alignment',
					'title'      => esc_html__( 'Horizontal Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'menu_typography',
					'title'      => esc_html__( 'Menu Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} nav ul li a',
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'menu_style_tabs',
					'title'      => esc_html__( 'Tabs Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'menu_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'menu_item_color',
					'title'      => esc_html__( 'Item Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} nav ul li a' => 'color: {{VALUE}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'menu_item_background_color',
					'title'      => esc_html__( 'Item Background Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} nav ul li a' => 'background-color: {{VALUE}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'menu_item_even_background_color',
					'title'      => esc_html__( 'Item Even Background Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} nav ul li:nth-child(even) a' => 'background-color: {{VALUE}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'menu_tab_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'menu_tab_hover',
					'title'      => esc_html__( 'Hover', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'menu_hover_color',
					'title'      => esc_html__( 'Menu Item Hover Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} nav ul li a:hover' => 'color: {{VALUE}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'menu_item_hover_background_color',
					'title'      => esc_html__( 'Menu Item Hover Background Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} nav ul li a:hover' => 'background-color: {{VALUE}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'menu_tab_hover_end',
					'title'      => esc_html__( 'Hover End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'menu_tab_active',
					'title'      => esc_html__( 'Active', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'menu_active_color',
					'title'      => esc_html__( 'Menu Item Active Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} nav ul li.current-menu-item a' => 'color: {{VALUE}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'menu_item_active_background_color',
					'title'      => esc_html__( 'Menu Item Active Background Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} nav ul li.current-menu-item a' => 'background-color: {{VALUE}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'menu_tab_active_end',
					'title'      => esc_html__( 'Active End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'menu_style_tabs_end',
					'title'      => esc_html__( 'Tabs End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'menu_divider_after_tabs',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'items_vertical_padding',
					'title'      => esc_html__( 'Vertical Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} nav ul li a' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'items_horizontal_padding',
					'title'      => esc_html__( 'Horizontal Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} nav ul li a' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_items',
					'title'      => esc_html__( 'Space Between', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-layout--horizontal nav ul li' => 'padding-right: {{SIZE}}{{UNIT}}; padding-left: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-layout--vertical nav ul li'   => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_items',
					'title'      => esc_html__( 'Space Between', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-layout--horizontal nav ul li' => 'padding-right: {{SIZE}}{{UNIT}}; padding-left: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-layout--vertical nav ul li'   => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'menu_item_border',
					'title'         => esc_html__( 'Enable Border Between Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => '',
					'group'         => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'menu_item_border_color',
					'title'      => esc_html__( 'Menu Item Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} nav ul li ' => 'border-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'menu_item_border' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'menu_item_border_thickness',
					'title'      => esc_html__( 'Menu Item Border Thickness', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-layout--vertical nav ul li'   => 'border-bottom-width: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-layout--horizontal nav ul li' => 'border-width: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'menu_item_border' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'menu_divider_after_border',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'menu_item_style',
					'title'         => esc_html__( 'Menu Item Style', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'default'                        => esc_html__( 'Default', 'qi-addons-for-elementor-premium' ),
						'with-icon'                      => esc_html__( 'With Icon', 'qi-addons-for-elementor-premium' ),
						'with-active-icon'               => esc_html__( 'With Active Icon', 'qi-addons-for-elementor-premium' ),
						'with-active-underline'          => esc_html__( 'With Active Underline', 'qi-addons-for-elementor-premium' ),
						'with-active-floating-underline' => esc_html__( 'With Active Floating Underline', 'qi-addons-for-elementor-premium' ),
						'with-active-background-svg'     => esc_html__( 'With Active Background SVG', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'default',
					'group'         => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'item_icon',
					'default_value' => array(),
					'title'         => esc_html__( 'Item Icon', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'menu_item_style' => array(
								'values'        => 'with-icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'item_icon_hover_move',
					'title'      => esc_html__( 'Move Icon On Hover', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'horizontal-short' => esc_html__( 'Horizontal Short', 'qi-addons-for-elementor-premium' ),
						'horizontal'       => esc_html__( 'Horizontal', 'qi-addons-for-elementor-premium' ),
						'vertical'         => esc_html__( 'Vertical', 'qi-addons-for-elementor-premium' ),
						'diagonal'         => esc_html__( 'Diagonal', 'qi-addons-for-elementor-premium' ),
						''                 => esc_html__( 'None', 'qi-addons-for-elementor-premium' ),
					),
					'dependency' => array(
						'show' => array(
							'menu_item_style' => array(
								'values'        => 'with-icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'active_item_icon',
					'default_value' => array(),
					'title'         => esc_html__( 'Active Item Icon', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'menu_item_style' => array(
								'values'        => 'with-active-icon',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'item_icon_appear',
					'title'      => esc_html__( 'Icon Appear', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'fade-in'                => esc_html__( 'Fade In', 'qi-addons-for-elementor-premium' ),
						'from-center-horizontal' => esc_html__( 'Reveal From Center Horizontal', 'qi-addons-for-elementor-premium' ),
						'from-center-vertical'   => esc_html__( 'Reveal From Center Vertical', 'qi-addons-for-elementor-premium' ),
						'from-left'              => esc_html__( 'Reveal From Left', 'qi-addons-for-elementor-premium' ),
					),
					'dependency' => array(
						'show' => array(
							'menu_item_style' => array(
								'values'        => array( 'with-active-icon', 'with-active-background-svg' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'menu_item_icon_position',
					'title'         => esc_html__( 'Menu Item Icon Position', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'left'  => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'right' => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'right',
					'group'         => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'menu_item_style' => array(
								'values'        => array( 'with-icon', 'with-active-icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'menu_item_icon_vertical_offset',
					'title'      => esc_html__( 'Menu Item Icon Vertical Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => - 100,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} nav ul li a .qodef-m-icon'        => 'top: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} nav ul li a .qodef-m-active-icon' => 'top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'menu_item_style' => array(
								'values'        => array( 'with-icon', 'with-active-icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'custom_icon_size',
					'title'         => esc_html__( 'Enable Custom Icons Size', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'menu_item_style' => array(
								'values'        => array( 'with-icon', 'with-active-icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_size',
					'title'      => esc_html__( 'Icon Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em', 'rem', 'vw' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} nav ul li a .qodef-m-icon, {{WRAPPER}} nav ul li a .qodef-m-active-icon' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'relation' => 'and',
						'show'     => array(
							'custom_icon_size' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
							'menu_item_style'  => array(
								'values'        => array( 'with-icon', 'with-active-icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_menu_item_and_icon',
					'title'      => esc_html__( 'Space Between Menu Item and Icon', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-menu-item-icon-position--left nav ul li a .qodef-m-icon, {{WRAPPER}} .qodef-menu-item-icon-position--left nav ul li a .qodef-m-active-icon'   => 'margin-right: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-menu-item-icon-position--right nav ul li a .qodef-m-icon, {{WRAPPER}} .qodef-menu-item-icon-position--right nav ul li a .qodef-m-active-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'menu_item_style' => array(
								'values'        => array( 'with-icon', 'with-active-icon' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'menu_item_icon_structure',
					'title'         => esc_html__( 'Menu Item Icon Structure', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'together' => esc_html__( 'Together', 'qi-addons-for-elementor-premium' ),
						'apart'    => esc_html__( 'Apart', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'together',
					'group'         => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'menu_item_style' => array(
								'values'        => array( 'with-icon', 'with-active-icon' ),
								'default_value' => '',
							),
							'layout'          => array(
								'values'        => 'vertical',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'menu_item_underline_distance',
					'title'      => esc_html__( 'Menu Item Underline Distance', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-menu-item-style--with-active-underline nav ul li a .qodef-m-text:after'   => 'bottom: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-menu-item-style--with-active-floating-underline .qodef-content-menu-line' => 'bottom: {{SIZE}}{{UNIT}};',
					),
					'range'      => array(
						'px' => array(
							'min' => - 100,
							'max' => 100,
						),
					),
					'dependency' => array(
						'show' => array(
							'menu_item_style' => array(
								'values'        => array( 'with-active-underline', 'with-active-floating-underline' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'menu_item_underline_thickness',
					'title'      => esc_html__( 'Menu Item Underline Thickness', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-menu-item-style--with-active-underline nav ul li a .qodef-m-text:after'   => 'height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-menu-item-style--with-active-floating-underline nav ul li a:after'        => 'width: {{SIZE}}{{UNIT}}; right: -{{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-menu-item-style--with-active-floating-underline .qodef-content-menu-line' => 'border-top-width: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'menu_item_style' => array(
								'values'        => array( 'with-active-underline', 'with-active-floating-underline' ),
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'image',
					'default_value' => array(),
					'name'          => 'menu_item_background_svg',
					'title'         => esc_html__( 'Menu Item Background SVG', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Menu Style', 'qi-addons-for-elementor-premium' ),
					'media_types'   => array( 'svg' ),
					'dependency'    => array(
						'show' => array(
							'menu_item_style' => array(
								'values'        => 'with-active-background-svg',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'enable_responsive_menu',
					'title'         => esc_html__( 'Enable Responsive Menu', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'no',
					'description'   => esc_html__( 'If enabled, content menu will be displayed vertically on touch devices', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Responsive Options', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'layout' => array(
								'values'        => 'horizontal',
								'default_value' => 'horizontal',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'menu_responsive_breakpoint',
					'title'         => esc_html__( 'Choose responsive breakpoint', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'1024' => esc_html__( '1024', 'qi-addons-for-elementor-premium' ),
						'768'  => esc_html__( '768', 'qi-addons-for-elementor-premium' ),
						'680'  => esc_html__( '680', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => '768',
					'group'         => esc_html__( 'Responsive Options', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'enable_responsive_menu' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'responsive_menu_alignment',
					'title'      => esc_html__( 'Responsive Menu Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'group'      => esc_html__( 'Responsive Options', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'enable_responsive_menu' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			add_filter( 'nav_menu_item_title', array( $this, 'item_icon' ), 10, 4 );
			add_filter( 'nav_menu_item_id', '__return_empty_string' );

			$atts['holder_classes'] = $this->get_holder_classes( $atts );

			$atts['nav_menu_content'] = wp_nav_menu( $this->get_menu_args( $atts ) );

			remove_filter( 'nav_menu_item_title', array( $this, 'item_icon' ) );
			remove_filter( 'nav_menu_item_id', '__return_empty_string' );

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/content-menu', 'templates/content', '', $atts );

		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-content-menu';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['menu_item_style'] ) ? 'qodef-menu-item-style--' . $atts['menu_item_style'] : '';
			$holder_classes[] = ! empty( $atts['menu_item_icon_structure'] ) ? 'qodef-menu-item-icon-structure--' . $atts['menu_item_icon_structure'] : '';
			$holder_classes[] = ! empty( $atts['menu_item_icon_position'] ) ? 'qodef-menu-item-icon-position--' . $atts['menu_item_icon_position'] : '';
			$holder_classes[] = ! empty( $atts['item_icon_hover_move'] ) ? 'qodef-hover--icon-move-' . $atts['item_icon_hover_move'] : '';
			$holder_classes[] = ! empty( $atts['item_icon_appear'] ) ? 'qodef--icon-appear-' . $atts['item_icon_appear'] : '';
			$holder_classes[] = ! empty( $atts['menu_item_border'] ) && 'yes' === $atts['menu_item_border'] ? 'qodef-border-between' : '';
			$holder_classes[] = ! empty( $atts['alignment'] ) ? 'qodef-alignment--' . $atts['alignment'] : '';
			$holder_classes[] = ! empty( $atts['custom_icon_size'] ) ? 'qodef-custom-icon-size' : '';
			$holder_classes[] = ! empty( $atts['menu_responsive_breakpoint'] ) ? 'qodef-responsive-breakpoint--' . $atts['menu_responsive_breakpoint'] : '';
			$holder_classes[] = ! empty( $atts['responsive_menu_alignment'] ) ? 'qodef-reponsive-alignment--' . $atts['responsive_menu_alignment'] : '';

			return implode( ' ', $holder_classes );
		}

		private function get_menus_list() {
			$menus            = array();
			$registered_menus = wp_get_nav_menus();

			foreach ( $registered_menus as $menu ) {
				$menus[ $menu->term_id ] = $menu->name;
			}

			return $menus;
		}

		private function get_menu_args( $atts ) {

			$args = array(
				'echo'            => false,
				'container'       => 'nav',
				'container_class' => 'qodef-content-menu',
				'depth'           => 1,
			);

			if ( '' !== $atts['menu'] ) {
				$args['menu'] = $atts['menu'];
			}

			return $args;

		}

		function item_icon( $title, $item, $args, $depth ) {

			$atts = $this->get_atts();

			$item_icon        = '';
			$active_item_icon = '';
			$svg_item_icon    = '';

			$title = '<span class="qodef-m-text">' . $title . '</span>';

			if ( ! empty( $atts['item_icon'] ) ) {
				$item_icon = qi_addons_for_elementor_premium_get_template_part( 'shortcodes/content-menu', 'templates/parts/icon', '', $atts );
			}

			if ( ! empty( $atts['active_item_icon'] ) ) {
				$active_item_icon = qi_addons_for_elementor_premium_get_template_part( 'shortcodes/content-menu', 'templates/parts/active-icon', '', $atts );
			}

			if ( ! empty( $atts['menu_item_background_svg'] ) ) {
				$menu_item_svg_url = esc_url( wp_get_attachment_url( $atts['menu_item_background_svg'] ) );

				$atts['menu_item_svg_icon'] = array(
					'library' => 'svg',
					'value'   => array(
						'url' => $menu_item_svg_url,
						'id'  => $atts['menu_item_background_svg'],
					),
				);
				$svg_item_icon              = qi_addons_for_elementor_premium_get_template_part( 'shortcodes/content-menu', 'templates/parts/svg-icon', '', $atts );

			}

			return $title . $item_icon . $active_item_icon . $svg_item_icon;

		}

	}
}
