<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_data_table_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_data_table_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Data_Table_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_data_table_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Data_Table_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_data_table_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/data-table' );
			$this->set_base( 'qi_addons_for_elementor_premium_data_table' );
			$this->set_name( esc_html__( 'Data Table', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays data table', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Business', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/data-table/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#data_table' );
			$this->set_video( 'https://www.youtube.com/watch?v=sWp6KDr_NcM' );
			$this->set_necessary_styles( qi_addons_for_elementor_icon_necessary_styles() );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'number',
					'name'       => 'row_per_page',
					'title'      => esc_html__( 'Row Per Page', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_row_counter',
					'title'         => esc_html__( 'Enable Row Counter', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'row_counter_width',
					'title'      => esc_html__( 'Counter Cell Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-counter' => 'width: {{SIZE}}%;',
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'headings',
					'title'         => esc_html__( 'Headings', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'column_title' => esc_html__( 'Column 1', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'column_title' => esc_html__( 'Column 2', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'column_title' => esc_html__( 'Column 3', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'column_title' => esc_html__( 'Column 4', 'qi-addons-for-elementor-premium' ),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'text',
							'name'          => 'column_title',
							'title'         => esc_html__( 'Column Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Column', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'column_width',
							'title'      => esc_html__( 'Column Width', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px' ),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}}.qodef-e-cell' => 'width: {{SIZE}}%;',
							),
						),
					),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_type'  => 'image',
							'item_image' => $placeholder,
						),
						array(
							'item_type'  => 'text',
							'item_title' => esc_html__( 'Cell 2', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_type'  => 'text',
							'item_title' => esc_html__( 'Cell 3', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_type'  => 'text',
							'item_title' => esc_html__( 'Cell 4', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_type'  => 'image',
							'item_image' => $placeholder,
						),
						array(
							'item_type'  => 'text',
							'item_title' => esc_html__( 'Cell 5', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_type'  => 'text',
							'item_title' => esc_html__( 'Cell 6', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_type'  => 'text',
							'item_title' => esc_html__( 'Cell 7', 'qi-addons-for-elementor-premium' ),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'select',
							'name'          => 'item_type',
							'title'         => esc_html__( 'Item Type', 'qi-addons-for-elementor-premium' ),
							'options'       => array(
								'text'  => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
								'image' => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
							),
							'default_value' => 'text',
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_text',
							'title'         => esc_html__( 'Item Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Item Text', 'qi-addons-for-elementor-premium' ),
							'dependency'    => array(
								'show' => array(
									'item_type' => array(
										'values'        => 'text',
										'default_value' => 'text',
									),
								),
							),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Item Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
							'dependency'    => array(
								'show' => array(
									'item_type' => array(
										'values'        => 'image',
										'default_value' => 'text',
									),
								),
							),
						),
						array(
							'field_type'    => 'select',
							'name'          => 'item_image_proportion',
							'default_value' => 'full',
							'title'         => esc_html__( 'Image Proportion', 'qi-addons-for-elementor-premium' ),
							'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'list_image_dimension', false, array( 'custom' ) ),
							'dependency'    => array(
								'show' => array(
									'item_type' => array(
										'values'        => 'image',
										'default_value' => 'text',
									),
								),
							),
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Item Link', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'table_layout',
					'title'         => esc_html__( 'Table Layout', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'auto'  => esc_html__( 'Auto', 'qi-addons-for-elementor-premium' ),
						'fixed' => esc_html__( 'Fixed', 'qi-addons-for-elementor-premium' ),
					),
					'responsive'    => true,
					'default_value' => 'auto',
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-table' => 'table-layout: {{VALUE}};',
					),
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'alignment',
					'title'         => esc_html__( 'Table Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						''       => esc_html__( 'Default', 'qi-addons-for-elementor-premium' ),
						'left'   => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'center' => esc_html__( 'Center', 'qi-addons-for-elementor-premium' ),
						'right'  => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
					),
					'responsive'    => true,
					'default_value' => '',
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-table' => 'text-align: {{VALUE}};',
					),
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'minimal_width',
					'title'      => esc_html__( 'Minimal Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 1,
							'max' => 2000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table' => 'min-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'background',
					'name'       => 'table_background',
					'title'      => esc_html__( 'Background', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-table',
					'types'      => array( 'classic' ),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color_headings_row',
					'title'      => esc_html__( 'Headings Row Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table .qodef-m-main-row' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color_first_column',
					'title'      => esc_html__( 'First Column Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table .qodef-e-cell:first-child' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'border_inside',
					'title'      => esc_html__( 'Border Style', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'all'    => esc_html__( 'All', 'qi-addons-for-elementor-premium' ),
						'inside' => esc_html__( 'Inside Only', 'qi-addons-for-elementor-premium' ),
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'border',
					'name'       => 'border',
					'title'      => esc_html__( 'Border', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-cell',
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'headings_cell_padding',
					'title'              => esc_html__( 'Headings Cell Padding', 'qi-addons-for-elementor-premium' ),
					'allowed_dimensions' => array( 'top', 'bottom' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'responsive'         => true,
					'selectors'          => array(
						'{{WRAPPER}} .qodef-e-cell.qodef-row-title' => 'padding-top: {{TOP}}{{UNIT}}; padding-bottom: {{BOTTOM}}{{UNIT}};',
					),
					'group'              => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'cell_padding',
					'title'      => esc_html__( 'Cell Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-cell' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'title_tag',
					'title'      => esc_html__( 'Main Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Main Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Main Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-main-row .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Main Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Main Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-main-row .qodef-e-title',
					'group'      => esc_html__( 'Main Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'cell_text_color',
					'title'      => esc_html__( 'Cell Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-cell.qodef-e-text'    => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-e-cell.qodef-e-counter' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Cell Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'cell_text_typography',
					'title'      => esc_html__( 'Cell Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-cell.qodef-e-text, {{WRAPPER}} .qodef-e-cell.qodef-e-counter',
					'group'      => esc_html__( 'Cell Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_link_color',
					'title'      => esc_html__( 'Text Link Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-cell.qodef-e-text .qodef-e-text-link' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Cell Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_link_typography',
					'title'      => esc_html__( 'Text Link Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-cell.qodef-e-text .qodef-e-text-link',
					'group'      => esc_html__( 'Cell Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'text_link_underline',
					'title'         => esc_html__( 'Text Link Underline', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						''                  => esc_html__( 'None', 'qi-addons-for-elementor-premium' ),
						'underline-hover'   => esc_html__( 'Hover Underline', 'qi-addons-for-elementor-premium' ),
						'underline-initial' => esc_html__( 'Initial Underline', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'underline-initial',
					'group'         => esc_html__( 'Cell Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'pagination_alignment',
					'title'         => esc_html__( 'Pagination Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'flex-start' => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'center'     => esc_html__( 'Center', 'qi-addons-for-elementor-premium' ),
						'flex-end'   => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
					),
					'responsive'    => true,
					'default_value' => 'flex-end',
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-table-pagination' => 'justify-content: {{VALUE}};',
					),
					'group'         => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'pagination_typography',
					'title'      => esc_html__( 'Pagination Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-table-pagination .qodef-e-nav',
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tabs',
					'name'       => 'pagination_style_tabs',
					'title'      => esc_html__( 'Pagination Start', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'pagination_style_tab_normal',
					'title'      => esc_html__( 'Normal', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'pagination_color',
					'title'      => esc_html__( 'Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table-pagination .qodef-e-nav' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'pagination_background_color',
					'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table-pagination .qodef-e-nav' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'pagination_style_tab_normal_end',
					'title'      => esc_html__( 'Normal End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'start_controls_tab',
					'name'       => 'pagination_style_tab_hover',
					'title'      => esc_html__( 'Active/Hover', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'pagination_hover_color',
					'title'      => esc_html__( 'Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table-pagination .qodef-e-nav.qodef--current' => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-m-table-pagination .qodef-e-nav:hover'          => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'pagination_hover_background_color',
					'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table-pagination .qodef-e-nav.qodef--current' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-m-table-pagination .qodef-e-nav:hover'          => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tab',
					'name'       => 'pagination_style_tab_hover_end',
					'title'      => esc_html__( 'Active/Hover End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'end_controls_tabs',
					'name'       => 'pagination_style_tabs_end',
					'title'      => esc_html__( 'Pagination End', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_pagination_style_end',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'pagination_arrow_prev',
					'title'         => esc_html__( 'Pagination Arrow Previous', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(),
					'group'         => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'pagination_arrow_next',
					'title'         => esc_html__( 'Pagination Arrow Next', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(),
					'group'         => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'pagination_arrows_size',
					'title'      => esc_html__( 'Pagination Arrows Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table-pagination .qodef-m-next' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-m-table-pagination .qodef-m-prev' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_arrows_style_end',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'pagination_border_radius',
					'title'      => esc_html__( 'Pagination Item Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table-pagination .qodef-e-nav' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'pagination_width',
					'title'      => esc_html__( 'Pagination Item Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table-pagination .qodef-e-nav' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'pagination_height',
					'title'      => esc_html__( 'Pagination Item Height', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table-pagination .qodef-e-nav' => 'height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'pagination_spacing',
					'title'      => esc_html__( 'Space Between Pagination Items', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table-pagination .qodef-e-nav' => 'margin: 0 calc({{SIZE}}{{UNIT}}/2);',
					),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'pagination_margin_top',
					'title'      => esc_html__( 'Pagination Margin Top', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-table-pagination' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function load_assets() {
			parent::load_assets();

			qi_addons_for_elementor_icon_load_assets();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['holder_classes']   = $this->get_holder_classes( $atts );
			$atts['heading_items']    = $this->parse_repeater_items( $atts['headings'] );
			$atts['cells']            = $this->parse_repeater_items( $atts['children'] );
			$atts['columns']          = count( $atts['heading_items'] );
			$atts['row_per_page']     = ! empty( $atts['row_per_page'] ) ? $atts['row_per_page'] : count( $atts['cells'] );
			$atts['number_of_tables'] = ceil( count( $atts['cells'] ) / $atts['columns'] / $atts['row_per_page'] );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/data-table', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-data-table';
			$holder_classes[] = ! empty( $atts['border_inside'] ) ? 'qodef-border--' . $atts['border_inside'] : '';
			$holder_classes[] = ! empty( $atts['text_link_underline'] ) ? 'qodef-text-link--' . esc_attr( $atts['text_link_underline'] ) : '';

			return implode( ' ', $holder_classes );
		}
	}
}
