<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_divided_device_slider_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_divided_device_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Divided_Device_Slider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_divided_device_slider_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Divided_Device_Slider_Shortcode extends QiAddonsForElementor_Slider_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_divided_device_slider_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/divided-device-slider' );
			$this->set_base( 'qi_addons_for_elementor_premium_divided_device_slider' );
			$this->set_name( esc_html__( 'Divided Device Slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays divided device slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/divided-device-slider/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#divided_device_slider' );
			$this->set_video( 'https://www.youtube.com/watch?v=eigKwr3nPgc' );
			$this->set_scripts(
				array(
					'gsap'       => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/gsap.min.js',
						'dependency' => array( 'jquery' ),
					),
					'split-text' => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/SplitText.min.js',
						'dependency' => array( 'jquery' ),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'content_title',
					'title'         => esc_html__( 'Content Title', 'qi-addons-for-elementor-premium' ),
					'default_value' => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'color_positions',
					'title'       => esc_html__( 'Positions of Different Colored Words', 'qi-addons-for-elementor-premium' ),
					'dynamic'     => false,
					'description' => esc_html__( 'Enter the positions of the words which you would like to be in different color in title. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a different color, you would enter "1,3,4")', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'content_button_text_1',
					'title'         => esc_html__( 'Button Text 1', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Read More', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'link',
					'name'       => 'content_button_link_1',
					'title'      => esc_html__( 'Button Link 1', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'content_button_text_2',
					'title'         => esc_html__( 'Button Text 2', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'View More', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'link',
					'name'       => 'content_button_link_2',
					'title'      => esc_html__( 'Button Link 2', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'device',
					'title'      => esc_html__( 'Device Frame', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'mobile' => esc_html__( 'Mobile', 'qi-addons-for-elementor-premium' ),
						'tablet' => esc_html__( 'Tablet', 'qi-addons-for-elementor-premium' ),
						'laptop' => esc_html__( 'Laptop', 'qi-addons-for-elementor-premium' ),
						'custom' => esc_html__( 'Custom', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'custom_device',
					'multiple'   => 'no',
					'title'      => esc_html__( 'Custom Device Image', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'device' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'device_max_width',
					'title'      => esc_html__( 'Device Maximum Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'vw', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 2500,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-device-holder' => 'max-width: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_image'        => $placeholder,
							'item_device_image' => $placeholder,
							'item_title'        => esc_html__( 'Example Title 1', 'qi-addons-for-elementor-premium' ),
							'item_subtitle'     => esc_html__( 'Example Subtitle 1', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_image'        => $placeholder,
							'item_device_image' => $placeholder,
							'item_title'        => esc_html__( 'Example Title 2', 'qi-addons-for-elementor-premium' ),
							'item_subtitle'     => esc_html__( 'Example Subtitle 2', 'qi-addons-for-elementor-premium' ),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type'    => 'image',
							'name'          => 'item_device_image',
							'title'         => esc_html__( 'Device Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_title',
							'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Example Title', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_subtitle',
							'title'         => esc_html__( 'Subtitle', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Example Subtitle', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'change_slides_on_scroll',
					'title'         => esc_html__( 'Change Slides On Scroll', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
					'group'         => esc_html__( 'Slider Settings', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'slider_height',
					'title'      => esc_html__( 'Slider Height', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'vh' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1440,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
						'vh' => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-divided-device-slider' => 'height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Slider Settings', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'content_position',
					'title'         => esc_html__( 'Content Position', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'after'  => esc_html__( 'After Slider', 'qi-addons-for-elementor-premium' ),
						'before' => esc_html__( 'Before Slider', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'after',
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'content_width',
					'title'      => esc_html__( 'Content Width', 'qi-addons-for-elementor-premium' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content' => 'width: {{SIZE}}%;',
						'{{WRAPPER}} .qodef-content--after .qodef-m-device-holder' => 'left: calc(100% - {{SIZE}}%);',
						'{{WRAPPER}} .qodef-content--before .qodef-m-device-holder' => 'right: calc(100% - {{SIZE}}%);',
						'{{WRAPPER}} .qodef-m-main-items-holder' => 'width: calc(100% - {{SIZE}}%);',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'content_padding',
					'title'      => esc_html__( 'Content Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'device_image_border_radius',
					'title'      => esc_html__( 'Device Images Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-device-slider' => 'border-radius: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'device_image_offsets',
					'title'      => esc_html__( 'Device Images Offsets', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-device-slider-holder' => 'top: {{TOP}}{{UNIT}}; right: {{RIGHT}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}}; left: {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'content_title_tag',
					'title'         => esc_html__( 'Content Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'content_title_color',
					'title'      => esc_html__( 'Content Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'content_title_different_color',
					'title'      => esc_html__( 'Content Title Different Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title .qodef-e-colored' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'content_title_typography',
					'title'      => esc_html__( 'Content Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-title',
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'content_title_margin_bottom',
					'title'      => esc_html__( 'Content Title Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h3',
					'group'         => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-holder .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-item-holder .qodef-e-title',
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-holder .qodef-e-subtitle' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'subtitle_typography',
					'title'      => esc_html__( 'Subtitle Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-item-holder .qodef-e-subtitle',
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'subtitle_margin_bottom',
					'title'      => esc_html__( 'Subtitle Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-holder .qodef-e-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_buttons',
					'title'      => esc_html__( 'Space Between Buttons', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-button-holder .qodef-e-button:first-child' => 'margin-right: {{SIZE}}{{UNIT}}; margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Buttons Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class', 'button_link', 'button_text' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Buttons', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'hidden',
					'name'          => 'slider_navigation_position',
					'title'         => esc_html__( 'Navigation Position', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'together',
					'group'         => esc_html__( 'Slider Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_slider_options(
				array(
					'exclude_option' => array(
						'centered',
						'columns',
						'space',
						'images_proportion',
						'slider_loop',
						'slider_speed_animation',
						'slider_pagination',
						'slider_navigation_position',
						'slider_navigation_together_alignment',
						'slider_navigation_together_vertical_position',
					),
					'group'          => esc_html__( 'Slider Settings', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'text_animation',
					'title'         => esc_html__( 'Text Animation', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'fade-in-bottom'   => esc_html__( 'Fade In From Bottom', 'qi-addons-for-elementor-premium' ),
						'fade-in-right'    => esc_html__( 'Fade In From Right', 'qi-addons-for-elementor-premium' ),
						'letter-by-letter' => esc_html__( 'Letter By Letter', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'fade-in-bottom',
				)
			);

			$this->map_extra_options();
		}

		public function load_assets() {
			wp_enqueue_script( 'gsap' );
			wp_enqueue_script( 'split-text' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['slider_pagination_position']           = 'inside';
			$atts['slider_navigation_together_alignment'] = ( 'after' === $atts['content_position'] ) ? 'flex-end' : 'flex-start';

			$atts['unique']             = wp_unique_id();
			$atts['content_title']      = $this->get_modified_title( $atts );
			$atts['holder_classes']     = $this->get_holder_classes( $atts );
			$atts['items']              = $this->parse_repeater_items( $atts['children'] );
			$atts['device_slider_attr'] = $this->get_device_slider_data( $atts );
			$atts['item_slider_attr']   = $this->get_item_slider_data( $atts );
			$atts['button_params']      = $this->generate_button_params( $atts );
			$atts['this_shortcode']     = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/divided-device-slider', 'templates/divided-device-slider', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-divided-device-slider';
			$holder_classes[] = ! empty( $atts['change_slides_on_scroll'] ) && 'yes' === $atts['change_slides_on_scroll'] ? 'qodef--change-on-scroll' : '';
			$holder_classes[] = ! empty( $atts['content_position'] ) ? 'qodef-content--' . $atts['content_position'] : '';
			$holder_classes[] = ! empty( $atts['text_animation'] ) ? 'qodef-qi--text-animation-' . $atts['text_animation'] : '';

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$list_item_classes = $this->get_slider_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		private function get_item_slider_data( $atts ) {
			$atts['effect'] = 'fade';

			return $this->get_slider_data( $atts );
		}

		private function get_device_slider_data( $atts ) {
			$atts['effect']            = 'fade';
			$atts['slider_autoplay']   = 'no';
			$atts['slider_navigation'] = 'no';

			unset( $atts['unique'] );

			return $this->get_slider_data( $atts );
		}

		private function generate_button_params( $atts ) {
			$atts['button_text'] = '';
			$atts['button_link'] = array(
				'url'               => '',
				'is_external'       => '',
				'nofollow'          => '',
				'custom_attributes' => '',
			);

			$params = $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'qi_addons_for_elementor_button',
					'exclude'        => array( 'custom_class' ),
					'atts'           => $atts,
				)
			);

			return $params;
		}

		private function get_modified_title( $atts ) {
			$title = $atts['content_title'];

			if ( ! empty( $title ) ) {
				$split_title = explode( ' ', $title );

				if ( ! empty( $atts['color_positions'] ) ) {
					$color_positions = explode( ',', str_replace( ' ', '', $atts['color_positions'] ) );

					foreach ( $color_positions as $position ) {
						$position = intval( $position );
						if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
							$split_title[ $position - 1 ] = '<span class="qodef-e-colored">' . $split_title[ $position - 1 ] . '</span>';
						}
					}
				}

				$title = implode( ' ', $split_title );
			}

			return $title;
		}
	}
}
