<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_divided_showcase_carousel_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_divided_showcase_carousel_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Divided_Showcase_Carousel_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_divided_showcase_carousel_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Slider_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Divided_Showcase_Carousel_Shortcode extends QiAddonsForElementor_Slider_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_divided_showcase_carousel_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/divided-showcase-carousel' );
			$this->set_base( 'qi_addons_for_elementor_premium_divided_showcase_carousel' );
			$this->set_name( esc_html__( 'Divided Showcase Carousel', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays divided showcase carousel', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/divided-showcase-carousel/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#divided_showcase_carousel' );
			$this->set_scripts(
				array(
					'gsap'       => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/gsap.min.js',
						'dependency' => array( 'jquery' ),
					),
					'split-text' => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/SplitText.min.js',
						'dependency' => array( 'jquery' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_slider_options(
				array(
					'group'          => 'Slider Settings',
					'exclude_option' => array( 'centered' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'text_tag',
					'title'      => esc_html__( 'Text Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-title',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'subtitle_tag',
					'title'      => esc_html__( 'Subtitle Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-subtitle' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'subtitle_typography',
					'title'      => esc_html__( 'Subtitle Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-subtitle',
					'group'      => esc_html__( 'Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'subtitle_margin_bottom',
					'title'      => esc_html__( 'Subtitle Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}}',
					),
					'group'      => esc_html__( 'Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'item_padding',
					'title'              => esc_html__( 'Text Padding', 'qi-addons-for-elementor-premium' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'responsive'         => true,
					'allowed_dimensions' => array( 'left', 'right' ),
					'selectors'          => array(
						'{{WRAPPER}} .qodef-divided-showcase-carousel-text' => 'padding: 0 {{RIGHT}}{{UNIT}} 0 {{LEFT}}{{UNIT}};',
					),
					'group'              => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_image' => $placeholder,
							'item_link'  => array(),
							'title'      => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_image' => $placeholder,
							'item_link'  => array(),
						),
						array(
							'item_image' => $placeholder,
							'item_link'  => array(),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'textarea',
							'name'          => 'subtitle',
							'title'         => esc_html__( 'Subtitle', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'subtitle' ),
						),
						array(
							'field_type'    => 'textarea',
							'name'          => 'text',
							'title'         => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'title' ),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Item Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Item Link', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_button',
					'title'         => esc_html__( 'Enable Button', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'text_animation',
					'title'         => esc_html__( 'Text Animation', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'fade-in'          => esc_html__( 'Fade In', 'qi-addons-for-elementor-premium' ),
						'letter-by-letter' => esc_html__( 'Letter By Letter', 'qi-addons-for-elementor-premium' ),
						'fade-in-raw'      => esc_html__( 'Fade In Raw', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'fade-in',
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_premium_premium_button',
					'exclude'           => array( 'custom_class', 'button_link' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'button_margin',
					'title'              => esc_html__( 'Button Margin', 'qi-addons-for-elementor-premium' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'responsive'         => true,
					'allowed_dimensions' => array( 'top', 'bottom' ),
					'selectors'          => array(
						'{{WRAPPER}} .qodef-m-button' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
					),
					'dependency'         => array(
						'show' => array(
							'enable_button' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'              => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function load_assets() {
			wp_enqueue_script( 'gsap' );
			wp_enqueue_script( 'split-text' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['unique']              = rand( 0, 999 );
			$atts['main_holder_classes'] = $this->get_main_holder_classes( $atts );
			$atts['holder_classes']      = $this->get_holder_classes( $atts );
			$atts['text_holder_classes'] = $this->get_text_holder_classes( $atts );
			$atts['item_classes']        = $this->get_item_classes( $atts );
			$atts['items']               = $this->parse_repeater_items( $atts['children'] );
			$atts['slider_attr']         = $this->get_slider_data( $atts );
			$atts['text_slider_attr']    = $this->get_text_slider_data( $atts );
			$atts['button_params']       = $this->generate_button_params( $atts );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/divided-showcase-carousel', 'templates/content', '', $atts );
		}

		private function get_main_holder_classes( $atts ) {
			$main_holder_classes = $this->init_holder_classes();

			$main_holder_classes[] = 'qodef-qi-divided-showcase-carousel';

			return implode( ' ', $main_holder_classes );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes[] = '';

			$slider_classes = $this->get_slider_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $slider_classes );

			return implode( ' ', $holder_classes );
		}

		private function get_text_holder_classes( $atts ) {
			$holder_classes[] = 'qodef-divided-showcase-carousel-text';

			$holder_classes[] = ! empty( $atts['text_animation'] ) ? 'qodef-qi--text-animation-' . $atts['text_animation'] : '';
			$slider_classes   = $this->get_slider_classes( $atts );
			$holder_classes   = array_merge( $holder_classes, $slider_classes );

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$slider_item_classes = $this->get_slider_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $slider_item_classes );

			return implode( ' ', $item_classes );
		}

		private function get_text_slider_data( $atts ) {

			$atts['unique']               = '';
			$atts['columns']              = 1;
			$atts['columns_1440']         = 1;
			$atts['columns_1366']         = 1;
			$atts['columns_1024']         = 1;
			$atts['columns_768']          = 1;
			$atts['columns_680']          = 1;
			$atts['columns_480']          = 1;
			$atts['space']['size']        = 0;
			$atts['space_tablet']['size'] = 0;
			$atts['space_mobile']['size'] = 0;
			$atts['centered_slides']      = 'no';
			$atts['slider_navigation']    = 'no';
			$atts['slider_pagination']    = 'no';
			$atts['partial_columns']      = 'no';
			$atts['effect']               = 'fade';

			return $this->get_slider_data( $atts );
		}

		private function generate_button_params( $atts ) {

			if ( 'yes' === $atts['enable_button'] ) {
				$atts['button_link'] = array(
					'url'               => '',
					'is_external'       => '',
					'nofollow'          => '',
					'custom_attributes' => '',
				);

				return $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_premium_premium_button',
						'exclude'        => array( 'custom_class' ),
						'atts'           => $atts,
					)
				);
			}

			return array();
		}
	}
}
