<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_divided_slider_diverge_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_divided_slider_diverge_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Divided_Slider_Diverge_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_divided_slider_diverge_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Slider_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Divided_Slider_Diverge_Shortcode extends QiAddonsForElementor_Slider_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_divided_slider_diverge_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/divided-slider-diverge' );
			$this->set_base( 'qi_addons_for_elementor_premium_divided_slider_diverge' );
			$this->set_name( esc_html__( 'Divided Slider Diverge', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays divided slider diverge', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/divided-slider-diverge/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#divided_slider_diverge' );
			$this->set_necessary_styles( qi_addons_for_elementor_icon_necessary_styles() );

			$this->set_option(
				array(
					'field_type' => 'note',
					'name'       => 'warning',
					'title'      => esc_html__( 'Please note that this shortcode can be used only as a standalone shortcode on a page', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_scripts(
				array(
					'jquery-effects-core' => array(
						'registered' => true,
					),
					'multiscroll'         => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/divided-slider-diverge/assets/js/plugins/jquery.multiscroll.min.js',
						'dependency' => array( 'jquery', 'jquery-effects-core' ),
					),
				)
			);

			$this->set_necessary_styles(
				array(
					'multiscroll' => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/divided-slider-diverge/assets/css/plugins/jquery.multiscroll.css',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'disable_breakpoint',
					'title'         => esc_html__( 'Disable on smaller screens', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'1024' => esc_html__( 'Below 1024px', 'qi-addons-for-elementor-premium' ),
						'768'  => esc_html__( 'Below 768px', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => '1024',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'text_bottom',
					'title'         => esc_html__( 'Text Bottom', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						''    => esc_html__( 'Default', 'qi-addons-for-elementor-premium' ),
						'no'  => esc_html__( 'No', 'qi-addons-for-elementor-premium' ),
						'yes' => esc_html__( 'Yes', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => '',
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Slide Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'slide_layout'        => 'image-left',
							'slide_image'         => $placeholder,
							'slide_content_title' => esc_html__( 'Content Title 1', 'qi-addons-for-elementor-premium' ),
							'slide_content_text'  => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
						),
						array(
							'slide_layout'        => 'image-right',
							'slide_image'         => $placeholder,
							'slide_content_title' => esc_html__( 'Content Title 2', 'qi-addons-for-elementor-premium' ),
							'slide_content_text'  => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
						),
					),
					'items'         => array(
						array(
							'field_type' => 'select',
							'name'       => 'slide_navigation_style',
							'title'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
							'options'    => array(
								''      => esc_html__( 'Default', 'qi-addons-for-elementor-premium' ),
								'light' => esc_html__( 'Light', 'qi-addons-for-elementor-premium' ),
								'dark'  => esc_html__( 'Dark', 'qi-addons-for-elementor-premium' ),
							),
						),
						array(
							'field_type'    => 'select',
							'name'          => 'slide_layout',
							'title'         => esc_html__( 'Slide Layout', 'qi-addons-for-elementor-premium' ),
							'options'       => array(
								'image-left'  => esc_html__( 'Image On Left', 'qi-addons-for-elementor-premium' ),
								'image-right' => esc_html__( 'Image On Right', 'qi-addons-for-elementor-premium' ),
							),
							'default_value' => 'image-left',
						),
						array(
							'field_type' => 'color',
							'name'       => 'slide_background_color',
							'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'slide_image',
							'title'         => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type'    => 'text',
							'name'          => 'slide_content_title',
							'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'title' ),
						),
						array(
							'field_type'    => 'textarea',
							'name'          => 'slide_content_text',
							'title'         => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'slide_button_text',
							'title'         => esc_html__( 'Button Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'View more', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'link',
							'name'       => 'slide_button_link',
							'title'      => esc_html__( 'Button Link', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'alignment',
					'title'      => esc_html__( 'Horizontal Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slide-content' => 'text-align: {{VALUE}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'slide_content_padding',
					'title'      => esc_html__( 'Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slide-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Item Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_margin_top',
					'title'      => esc_html__( 'Title Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Item Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slide-content .qodef-m-title' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'text_margin_bottom',
					'title'      => esc_html__( 'Text Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Item Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slide-content .qodef-m-content-text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'button_margin_top',
					'title'      => esc_html__( 'Button Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Item Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slide-content .qodef-m-button-holder .qodef-qi-premium-button' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'button_margin_bottom',
					'title'      => esc_html__( 'Button Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Item Spacing Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slide-content .qodef-m-button-holder .qodef-qi-premium-button' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slide-content .qodef-m-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-slide-content .qodef-m-title',
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-slide-content .qodef-m-content-text' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-slide-content .qodef-m-content-text',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_premium_premium_button',
					'exclude'           => array( 'custom_class', 'button_text', 'button_link' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'navigation_arrow_up_icon',
					'title'         => esc_html__( 'Arrow Up Icon', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-arrow-up',
						'library' => 'solid',
					),
					'group'         => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'navigation_arrow_down_icon',
					'title'         => esc_html__( 'Arrow Down Icon', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-arrow-down',
						'library' => 'solid',
					),
					'group'         => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'navigation_arrow_icon_size',
					'title'      => esc_html__( 'Arrow Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-nav .qodef-e-nav-arrow' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'navigation_arrow_color',
					'title'      => esc_html__( 'Arrow Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-nav .qodef-e-nav-arrow' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'navigation_arrow_color_dark',
					'title'      => esc_html__( 'Dark Arrow Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-skin--dark .qodef-m-nav .qodef-e-nav-arrow' => 'color: {{VALUE}} !important;',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'navigation_arrow_color_light',
					'title'      => esc_html__( 'Light Arrow Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-skin--light .qodef-m-nav .qodef-e-nav-arrow' => 'color: {{VALUE}} !important;',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'navigation_counter_color',
					'title'      => esc_html__( 'Counter Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-counter' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'navigation_counter_color_dark',
					'title'      => esc_html__( 'Counter Color Dark', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-skin--dark .qodef-m-counter' => 'color: {{VALUE}} !important;',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'navigation_counter_color_light',
					'title'      => esc_html__( 'Counter Color Light', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-skin--light .qodef-m-counter' => 'color: {{VALUE}} !important;',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'navigation_counter_typography',
					'title'      => esc_html__( 'Counter Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-counter',
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'navigation_number_arrows_space',
					'title'      => esc_html__( 'Space Between Counter and Arrows', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-counter' => 'margin: {{SIZE}}{{UNIT}} 0;',
					),
					'group'      => esc_html__( 'Navigation Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'background_image_size',
					'title'         => esc_html__( 'Background Image Size', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Background Image Style', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'cover'   => esc_html__( 'Cover', 'qi-addons-for-elementor-premium' ),
						'contain' => esc_html__( 'Contain', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'cover',
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-slide-image' => 'background-size: {{VALUE}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'background_image_position',
					'title'         => esc_html__( 'Background Image Position', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Background Image Style', 'qi-addons-for-elementor-premium' ),
					'default_value' => '',
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-slide-image' => 'background-position: {{VALUE}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'background_image_repeat',
					'title'         => esc_html__( 'Background Image Repeat', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Background Image Style', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'no-repeat' => esc_html__( 'No Repeat', 'qi-addons-for-elementor-premium' ),
						'repeat'    => esc_html__( 'Repeat', 'qi-addons-for-elementor-premium' ),
						'repeat-x'  => esc_html__( 'Repeat X', 'qi-addons-for-elementor-premium' ),
						'repeat-y'  => esc_html__( 'Repeat Y', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'no-repeat',
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-slide-image' => 'background-repeat: {{VALUE}};',
					),
				)
			);

			$this->map_extra_options();
		}

		public function load_assets() {
			parent::load_assets();

			qi_addons_for_elementor_icon_load_assets();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/divided-slider-diverge', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-divided-slider-diverge qodef-m';
			$holder_classes[] = ! empty( $atts['disable_breakpoint'] ) ? 'qodef-disable-below--' . $atts['disable_breakpoint'] : '';
			$holder_classes[] = ! empty( $atts['text_bottom'] ) ? 'qodef-text-bottom--' . $atts['text_bottom'] : '';

			return implode( ' ', $holder_classes );
		}

		public function get_slide_image_styles( $slide_atts ) {
			$styles = array();

			$styles[] = ! empty( $slide_atts['slide_image'] ) ? 'background-image: url(' . wp_get_attachment_url( $slide_atts['slide_image'] ) . ')' : '';
			$styles[] = ! empty( $slide_atts['slide_background_color'] ) ? 'background-color: ' . $slide_atts['slide_background_color'] . '' : '';

			return $styles;
		}

		public function get_slide_data( $slide_atts ) {
			$data = array();

			$data['data-navigation-skin'] = ! empty( $slide_atts['slide_navigation_style'] ) ? $slide_atts['slide_navigation_style'] : '';

			return $data;
		}

		public function generate_button_params( $atts, $item_params ) {
			if ( $item_params['slide_button_link']['url'] ) {
				$atts['button_link'] = $item_params['slide_button_link'];
				$atts['button_text'] = ! empty( $item_params['slide_button_text'] ) ? esc_html( $item_params['slide_button_text'] ) : esc_html__( 'Read More', 'qi-addons-for-elementor-premium' );

				$button_params = $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_premium_premium_button',
						'exclude'        => array( 'custom_class' ),
						'atts'           => $atts,
					)
				);

				return $button_params;
			}

			return array();
		}
	}
}
