<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_divided_slider_reveal_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_divided_slider_reveal_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Divided_Slider_Reveal_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_divided_slider_reveal_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Slider_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Divided_Slider_Reveal_Shortcode extends QiAddonsForElementor_Slider_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_divided_slider_reveal_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/divided-slider-reveal' );
			$this->set_base( 'qi_addons_for_elementor_premium_divided_slider_reveal' );
			$this->set_name( esc_html__( 'Divided Slider Reveal', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays divided slider reveal', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/divided-slider-reveal/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#divided_slider_reveal' );
			$this->set_video( 'https://youtu.be/4SKh83xnXYU' );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_slider_options(
				array(
					'group'          => 'Slider Settings',
					'exclude_option' => array( 'centered', 'images_proportion', 'columns', 'space', 'slider_pagination_offset' ),
					'include_option' => array( 'vertical' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'slider_pagination_divider_offset',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Slider Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'slider_pagination_offset',
					'title'      => esc_html__( 'Pagination Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'vh' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
						'vh' => array(
							'min' => 0,
							'max' => 10,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-swiper-container.qodef-pagination--inside > .swiper-pagination'  => 'bottom: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-swiper-pagination-outside'                                          => 'margin-top: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .swiper-container-vertical ~ .qodef-swiper-pagination-outside'               => 'margin-top: 0; margin-left: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-swiper-container.swiper-container-vertical > .swiper-pagination' => 'bottom: auto; right: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-qi-divided-slider-reveal.qodef--slider-reverse-columns .qodef-qi-swiper-container.swiper-container-vertical > .swiper-pagination' => 'bottom: auto; left: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'hide' => array(
							'slider_pagination' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
					'group'      => esc_html__( 'Slider Pagination Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'enable_mouse_scroll',
					'title'         => esc_html__( 'Enable Mouse Scroll', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Slides will change instead of scrolling page when scrolled over slider', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Slider Settings', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'slider_reverse_columns',
					'title'         => esc_html__( 'Reverse Columns', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'no',
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'text_tag',
					'title'      => esc_html__( 'Text Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-title',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'main_image' => $placeholder,
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'textarea',
							'name'          => 'text',
							'title'         => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'title' ),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'main_image',
							'title'         => esc_html__( 'Main Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type'    => 'image',
							'name'          => 'top_image',
							'title'         => esc_html__( 'Top Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type' => 'slider',
							'name'       => 'top_image_width',
							'title'      => esc_html__( 'Top Image Width', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%', 'em' ),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}} .qodef-small-image-holder .qodef-e-image:nth-child(1)' => 'width: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'top_image_left',
							'title'      => esc_html__( 'Top Image Left Position', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%', 'em' ),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}} .qodef-small-image-holder .qodef-e-image:nth-child(1)' => 'left: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'top_image_top',
							'title'      => esc_html__( 'Top Image Top Position', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%', 'em' ),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}} .qodef-small-image-holder .qodef-e-image:nth-child(1)' => 'top: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'link',
							'name'       => 'top_image_link',
							'title'      => esc_html__( 'Top Image Link', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'bottom_image',
							'title'         => esc_html__( 'Bottom Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type' => 'slider',
							'name'       => 'bottom_image_width',
							'title'      => esc_html__( 'Bottom Image Width', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%', 'em' ),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}} .qodef-small-image-holder .qodef-e-image:nth-child(2)' => 'width: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'bottom_image_left',
							'title'      => esc_html__( 'Bottom Image Left Position', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%', 'em' ),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}} .qodef-small-image-holder .qodef-e-image:nth-child(2)' => 'left: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'bottom_image_top',
							'title'      => esc_html__( 'Bottom Image Bottom Position', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%', 'em' ),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}} .qodef-small-image-holder .qodef-e-image:nth-child(2)' => 'bottom: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'link',
							'name'       => 'bottom_image_link',
							'title'      => esc_html__( 'Bottom Image Link', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'middle_image',
							'title'         => esc_html__( 'Middle Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type' => 'slider',
							'name'       => 'middle_image_width',
							'title'      => esc_html__( 'Middle Image Width', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%', 'em' ),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}} .qodef-small-image-holder .qodef-e-image:nth-child(3)' => 'width: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'middle_image_left',
							'title'      => esc_html__( 'Middle Image Right Position', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%', 'em' ),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}} .qodef-small-image-holder .qodef-e-image:nth-child(3)' => 'right: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'middle_image_top',
							'title'      => esc_html__( 'Middle Image Top Position', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%', 'em' ),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}} .qodef-small-image-holder .qodef-e-image:nth-child(3)' => 'top: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'link',
							'name'       => 'middle_image_link',
							'title'      => esc_html__( 'Middle Image Link', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'color',
							'name'       => 'background_color',
							'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['centered_slides'] = 'yes';
			$atts['columns']         = 1;
			$atts['effect']          = 'fade';

			$atts['unique']              = rand( 0, 999 );
			$atts['main_holder_classes'] = $this->get_main_holder_classes( $atts );
			$atts['holder_classes']      = $this->get_holder_classes( $atts );
			$atts['text_holder_classes'] = $this->get_text_holder_classes( $atts );
			$atts['item_classes']        = $this->get_item_classes( $atts );
			$atts['items']               = $this->parse_repeater_items( $atts['children'] );
			$slider_scroll               = ! empty( $atts['enable_mouse_scroll'] ) && 'yes' === $atts['enable_mouse_scroll'] ? true : false;
			$atts['slider_attr']         = $this->get_slider_data( $atts, array( 'sliderScroll' => $slider_scroll ) );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/divided-slider-reveal', 'templates/content', '', $atts );
		}

		private function get_main_holder_classes( $atts ) {
			$main_holder_classes = $this->init_holder_classes();

			$main_holder_classes[] = 'qodef-qi-divided-slider-reveal';
			$main_holder_classes[] = ! empty( $atts['slider_reverse_columns'] ) && 'yes' === $atts['slider_reverse_columns'] ? 'qodef--slider-reverse-columns' : '';

			return implode( ' ', $main_holder_classes );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes[] = '';

			$slider_classes = $this->get_slider_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $slider_classes );

			return implode( ' ', $holder_classes );
		}

		private function get_text_holder_classes( $atts ) {
			$holder_classes[] = 'qodef-divided-slider-reveal-text';

			$slider_classes = $this->get_slider_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $slider_classes );

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$slider_item_classes = $this->get_slider_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $slider_item_classes );

			return implode( ' ', $item_classes );
		}

		public function get_background_styles( $atts ) {
			$styles = array();

			$styles[] = ! empty( $atts['background_color'] ) ? 'background-color: ' . $atts['background_color'] . '' : '';

			return $styles;
		}
	}
}
