<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_fixed_project_slider_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_fixed_project_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Fixed_Project_Slider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_fixed_project_slider_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Slider_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Fixed_Project_Slider_Shortcode extends QiAddonsForElementor_Slider_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_fixed_project_slider_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/fixed-project-slider' );
			$this->set_base( 'qi_addons_for_elementor_premium_fixed_project_slider' );
			$this->set_name( esc_html__( 'Fixed Project Slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays fixed project slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/fixed-project-slider/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#fixed_project_slider' );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->map_slider_options(
				array(
					'exclude_option' => array(
						'loop',
						'centered',
						'columns',
						'space',
						'slider_pagination',
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_responsive',
					'title'         => esc_html__( 'Enable Responsive Under', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'1024'  => esc_html__( '1024', 'qi-addons-for-elementor-premium' ),
						'768'   => esc_html__( '768', 'qi-addons-for-elementor-premium' ),
						'680'   => esc_html__( '680', 'qi-addons-for-elementor-premium' ),
						'never' => esc_html__( 'Never', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => '1024',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_full_height',
					'title'         => esc_html__( 'Enable Full Height Widget', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Slider height will remain the same', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'no',
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color',
					'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-fixed-project-slider' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-fixed-project-slider .qodef-m-items-holder' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'slider_left_offset',
					'title'      => esc_html__( 'Slider Left Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( '%' ),
					'range'      => array(
						'%' => array(
							'min' => 0,
							'max' => 50,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-fixed-project-slider .qodef-m-holder' => 'padding-left: {{SIZE}}%;',
						'{{WRAPPER}} .qodef-qi-fixed-project-slider .qodef-m-items-holder' => 'left: calc(( 100% - {{SIZE}}% ) * 2 / 3 + {{SIZE}}%);',
						'{{WRAPPER}} .qodef-qi-swiper-container+.qodef-swiper-together-nav' => 'width: calc(100% -  {{SIZE}}%);',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'content_width',
					'title'      => esc_html__( 'Content Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 700,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-fixed-project-slider .qodef-m-items-holder' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'item_content_padding',
					'title'      => esc_html__( 'Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-textual .qodef-e-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_main_image'  => $placeholder,
							'item_title'       => esc_html__( 'Example Title 1', 'qi-addons-for-elementor-premium' ),
							'item_text'        => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
							'item_button_text' => esc_html__( 'View more', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_main_image'  => $placeholder,
							'item_title'       => esc_html__( 'Example Title 2', 'qi-addons-for-elementor-premium' ),
							'item_text'        => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
							'item_button_text' => esc_html__( 'View more', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_main_image'  => $placeholder,
							'item_title'       => esc_html__( 'Example Title 3', 'qi-addons-for-elementor-premium' ),
							'item_text'        => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
							'item_button_text' => esc_html__( 'View more', 'qi-addons-for-elementor-premium' ),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'image',
							'name'          => 'item_main_image',
							'title'         => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_title',
							'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Example Title', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'html',
							'name'          => 'item_text',
							'title'         => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_button_text',
							'title'         => esc_html__( 'Button Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'View more', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_left_offset',
					'title'      => esc_html__( 'Title Left Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => -200,
							'max' => 200,
						),
						'%'  => array(
							'min' => -100,
							'max' => 100,
						),
						'em' => array(
							'min' => -10,
							'max' => 10,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-textual .qodef-e-title' => 'left: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-textual .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-item-textual .qodef-e-title',
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item-textual .qodef-e-text' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-item-textual .qodef-e-text',
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'         => 'dimensions',
					'name'               => 'text_button_padding',
					'title'              => esc_html__( 'Text/Button Padding', 'qi-addons-for-elementor-premium' ),
					'allowed_dimensions' => array( 'left', 'right' ),
					'size_units'         => array( 'px', '%', 'em' ),
					'responsive'         => true,
					'selectors'          => array(
						'{{WRAPPER}} .qodef-e-item-textual .qodef-e-text'          => 'padding: 0 {{RIGHT}}{{UNIT}} 0 {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-e-item-textual .qodef-e-button-holder' => 'padding: 0 {{RIGHT}}{{UNIT}} 0 {{LEFT}}{{UNIT}};',
					),
					'group'              => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_margin_bottom',
					'title'      => esc_html__( 'Title Margin Bottom on Responsive', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 200,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'text_margin_bottom',
					'title'      => esc_html__( 'Text Margin Bottom on Responsive', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 200,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class', 'button_text', 'button_link' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['unique']           = wp_unique_id();
			$atts['holder_classes']   = $this->get_holder_classes( $atts );
			$atts['items']            = $this->parse_repeater_items( $atts['children'] );
			$atts['slider_attr']      = $this->get_image_slider_data( $atts );
			$atts['item_slider_attr'] = $this->get_item_slider_data( $atts );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/fixed-project-slider', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-fixed-project-slider';
			$holder_classes[] = ! empty( $atts['enable_responsive'] ) ? 'qodef-qi-fixed-project-slider-responsive--' . $atts['enable_responsive'] : '';
			$holder_classes[] = ! empty( $atts['enable_full_height'] ) && 'yes' === $atts['enable_full_height'] ? 'qodef--full-height' : '';

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$list_item_classes = $this->get_slider_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		public function generate_button_params( $atts, $item_params ) {
			if ( $item_params['item_link']['url'] ) {
				$atts['button_link'] = $item_params['item_link'];
				$atts['button_text'] = ! empty( $item_params['item_button_text'] ) ? esc_html( $item_params['item_button_text'] ) : esc_html__( 'Read More', 'qi-addons-for-elementor-premium' );

				$button_params = $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_button',
						'exclude'        => array( 'custom_class' ),
						'atts'           => $atts,
					)
				);

				return $button_params;
			}

			return array();
		}

		private function get_image_slider_data( $atts ) {
			$atts['partial_columns']               = 'yes';
			$atts['slider_loop']                   = 'yes';
			$atts['partial_columns_value']         = array( 'size' => 0.5 );
			$atts['disable_partial_columns_under'] = ! empty( $atts['enable_responsive'] ) && ( 'never' !== $atts['enable_responsive'] ) ? $atts['enable_responsive'] : '';

			return $this->get_slider_data( $atts );
		}

		private function get_item_slider_data( $atts ) {
			$atts['effect']                     = 'fade';
			$atts['slider_navigation_position'] = 'inside';
			$atts['slider_pagination_position'] = 'inside';

			return $this->get_slider_data( $atts );
		}
	}
}
