<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_flip_box_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_flip_box_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Flip_Box_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_flip_box_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Flip_Box_Shortcode extends QiAddonsForElementor_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/flip-box' );
			$this->set_base( 'qi_addons_for_elementor_premium_flip_box' );
			$this->set_name( esc_html__( 'Flip Box', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that adds flip box', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/flip-box/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#flip_box' );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'height',
					'title'      => esc_html__( 'Height', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box' => 'height: {{SIZE}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'width',
					'title'      => esc_html__( 'Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box' => 'width: {{SIZE}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'border_radius',
					'title'      => esc_html__( 'Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box .qodef-qi-flip-box-holder' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type'   => 'select',
					'name'         => 'trigger',
					'title'        => esc_html__( 'Trigger', 'qi-addons-for-elementor-premium' ),
					'options'      => array(
						'hover'     => esc_html__( 'Hover', 'qi-addons-for-elementor-premium' ),
						'click'     => esc_html__( 'Click', 'qi-addons-for-elementor-premium' ),
						'button'    => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'hover',
				)
			);
			$this->set_option(
				array(
					'field_type'   => 'select',
					'name'         => 'animation_type',
					'title'        => esc_html__( 'Animation Type', 'qi-addons-for-elementor-premium' ),
					'options'      => array(
						'flip'          => esc_html__( 'Flip', 'qi-addons-for-elementor-premium' ),
						'flip-whole'    => esc_html__( 'Flip Whole', 'qi-addons-for-elementor-premium' ),
						'slide'         => esc_html__( 'Slide Over', 'qi-addons-for-elementor-premium' ),
						'pull'          => esc_html__( 'Pull', 'qi-addons-for-elementor-premium' ),
						'switch'        => esc_html__( 'Switch', 'qi-addons-for-elementor-premium' ),
						'fade'          => esc_html__( 'Fade', 'qi-addons-for-elementor-premium' ),
						'zoom-in'       => esc_html__( 'Zoom In', 'qi-addons-for-elementor-premium' ),
						'zoom-out'      => esc_html__( 'Zoom Out', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'flip',
				)
			);
			$this->set_option(
				array(
					'field_type'   => 'select',
					'name'         => 'animation_direction',
					'title'        => esc_html__( 'Animation Direction', 'qi-addons-for-elementor-premium' ),
					'options'      => array(
						'left'      => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'right'     => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
						'up'        => esc_html__( 'Up', 'qi-addons-for-elementor-premium' ),
						'down'      => esc_html__( 'Down', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'left',
					'dependency' => array(
						'hide' => array(
							'animation_type' => array(
								'values'        => array( 'fade', 'zoom-in', 'zoom-out' ),
								'default_value' => 'flip',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'number',
					'name'          => 'duration',
					'default_value' => 750,
					'responsive'    => true,
					'title'         => esc_html__( 'Duration (ms)', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box' => '--qodef-duration: {{VALUE}}ms;',
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => '3d_effect',
					'title'         => esc_html__( '3D Effect', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Adds 3D effect to content elements', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'no',
					'dependency' => array(
						'show' => array(
							'animation_type' => array(
								'values'        => array( 'flip', 'flip-whole' ),
								'default_value' => 'flip',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'overlay',
					'title'         => esc_html__( 'Overlay', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Show overlay when back side is turned', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'no',
				)
			);
			
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'front_icon',
					'title'         => esc_html__( 'Icon', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-bolt',
						'library' => 'solid',
					),
					'group'         => esc_html__( 'Front Side', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'front_title',
					'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Front Side Title', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Front Side', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'html',
					'name'          => 'front_description',
					'title'         => esc_html__( 'Description', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Front Side Text', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Front Side', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'front_trigger_icon',
					'title'         => esc_html__( 'Trigger Button', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-play-circle',
						'library' => 'solid',
					),
					'group'         => esc_html__( 'Front Side', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'trigger' => array(
								'values'        => array( 'button' ),
								'default_value' => 'hover',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'back_icon',
					'title'         => esc_html__( 'Icon', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-bolt',
						'library' => 'solid',
					),
					'group'         => esc_html__( 'Back Side', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'back_title',
					'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Back Side Title', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Back Side', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'html',
					'name'          => 'back_description',
					'title'         => esc_html__( 'Description', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Back Side Text', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Back Side', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'button_text',
					'title'         => esc_html__( 'Button Text', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Back Side', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type'    => 'link',
					'name'          => 'button_link',
					'title'         => esc_html__( 'Button Link', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Back Side', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'back_trigger_icon',
					'title'         => esc_html__( 'Trigger Button', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-play-circle',
						'library' => 'solid',
					),
					'group'         => esc_html__( 'Back Side', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'trigger' => array(
								'values'        => array( 'button' ),
								'default_value' => 'hover',
							),
						),
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'front_side_padding',
					'title'      => esc_html__( 'Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Front Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'front_side_horizontal_alignment',
					'title'      => esc_html__( 'Horizontal Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons_flex', false ),
					'default_value' => 'center',
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-qi-flip-box-content' => 'align-items: {{VALUE}};',
					),
					'group'      => esc_html__( 'Front Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'front_side_vertical_alignment',
					'title'      => esc_html__( 'Vertical Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons_flex_vertical', false ),
					'default_value' => 'center',
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front' => 'justify-content: {{VALUE}};',
					),
					'group'      => esc_html__( 'Front Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'front_side_text_alignment',
					'title'      => esc_html__( 'Text Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'default_value' => 'left',
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-qi-flip-box-content' => 'text-align: {{VALUE}};',
					),
					'group'      => esc_html__( 'Front Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'background',
					'name'       => 'front_side_background',
					'title'      => esc_html__( 'Background', 'qi-addons-for-elementor-premium' ),
					'types'      => array( 'classic', 'gradient', 'video' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-flip-box-front',
					'group'      => esc_html__( 'Front Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'front_side_content_background',
					'title'      => esc_html__( 'Content Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-qi-flip-box-content' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Front Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'front_side_content_padding',
					'title'      => esc_html__( 'Content Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-qi-flip-box-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Front Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'front_icon_boxed',
					'title'         => esc_html__( 'Icon Boxed', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', true ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Front Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'front_icon_size',
					'title'      => esc_html__( 'Icon Size', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Front Icon Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-icon-holder' => 'font-size: {{SIZE}}{{UNIT}};',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'front_icon_color',
					'title'      => esc_html__( 'Icon Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Front Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-icon-holder' => 'color: {{VALUE}};',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'front_icon_background_color',
					'title'      => esc_html__( 'Icon Background Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Front Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-icon-holder' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'front_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'front_icon_border_color',
					'title'      => esc_html__( 'Icon Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Front Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-icon-holder' => 'border-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'front_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'front_icon_stroke_color',
					'title'      => esc_html__( 'Icon Stroke Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Front Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-icon-holder svg' => 'stroke: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'front_icon[library]' => array(
								'values'        => 'svg',
								'default_value' => '',
							),
						),
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'front_icon_box_size',
					'title'      => esc_html__( 'Icon Box Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-icon-holder' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Front Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'front_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'front_icon_border_width',
					'title'      => esc_html__( 'Icon Border Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em'),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 30,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-icon-holder' => 'border-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Front Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'front_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'front_icon_border_radius',
					'title'      => esc_html__( 'Icon Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-icon-holder' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Front Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'front_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'number',
					'name'          => 'front_icon_stroke_width',
					'title'         => esc_html__( 'Icon Stroke Width', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Front Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'     => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-icon-holder svg' => 'stroke-width: {{VALUE}};',
					),
					'default_value' => 1,
					'dependency'    => array(
						'show' => array(
							'front_icon[library]' => array(
								'values'        => 'svg',
								'default_value' => '',
							),
						),
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'heading',
					'name'       => 'front_title_style_heading',
					'title'      => esc_html__( 'Front Title', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Front Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'front_title_tag',
					'title'      => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Front Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'front_title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Front Typography Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-title' => 'color: {{VALUE}};',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'front_title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-title',
					'group'      => esc_html__( 'Front Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type'  => 'dimensions',
					'name'        => 'front_title_padding',
					'title'       => esc_html__( 'Title Padding', 'qi-addons-for-elementor-premium' ),
					'group'       => esc_html__( 'Front Typography Style', 'qi-addons-for-elementor-premium' ),
					'size_units'  => array( 'px', '%', 'em' ),
					'responsive'  => true,
					'selectors'   => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'front_title_typography_divider',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'       => esc_html__( 'Front Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'heading',
					'name'       => 'front_description_style_heading',
					'title'      => esc_html__( 'Front Description', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Front Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'front_description_color',
					'title'      => esc_html__( 'Description Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-description-holder > *' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Front Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'front_description_typography',
					'title'      => esc_html__( 'Description Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-description-holder > *',
					'group'      => esc_html__( 'Front Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type'  => 'dimensions',
					'name'        => 'front_description_padding',
					'title'       => esc_html__( 'Description Padding', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'set up and bottom padding', 'qi-addons-for-elementor-premium' ),
					'group'       => esc_html__( 'Front Typography Style', 'qi-addons-for-elementor-premium' ),
					'size_units'  => array( 'px', '%', 'em' ),
					'responsive'  => true,
					'selectors'   => array(
						'{{WRAPPER}} .qodef-qi-flip-box-front .qodef-front-description-holder' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'back_side_padding',
					'title'      => esc_html__( 'Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Back Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'back_side_horizontal_alignment',
					'title'      => esc_html__( 'Horizontal Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons_flex', false ),
					'default_value' => 'center',
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-qi-flip-box-content' => 'align-items: {{VALUE}};',
					),
					'group'      => esc_html__( 'Back Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'back_side_vertical_alignment',
					'title'      => esc_html__( 'Vertical Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons_flex_vertical', false ),
					'default_value' => 'center',
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back' => 'justify-content: {{VALUE}};',
					),
					'group'      => esc_html__( 'Back Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'back_side_text_alignment',
					'title'      => esc_html__( 'Text Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'default_value' => 'left',
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-qi-flip-box-content' => 'text-align: {{VALUE}};',
					),
					'group'      => esc_html__( 'Back Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'background',
					'name'       => 'back_side_background',
					'title'      => esc_html__( 'Background', 'qi-addons-for-elementor-premium' ),
					'types'      => array( 'classic', 'gradient', 'video' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-flip-box-back',
					'group'      => esc_html__( 'Back Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'back_side_content_background',
					'title'      => esc_html__( 'Content Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-qi-flip-box-content' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Back Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'back_side_content_padding',
					'title'      => esc_html__( 'Content Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-qi-flip-box-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Back Side Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'back_icon_boxed',
					'title'         => esc_html__( 'Icon Boxed', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', true ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Back Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'back_icon_size',
					'title'      => esc_html__( 'Icon Size', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Back Icon Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-icon-holder' => 'font-size: {{SIZE}}{{UNIT}};',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'back_icon_color',
					'title'      => esc_html__( 'Icon Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Back Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-icon-holder' => 'color: {{VALUE}};',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'back_icon_background_color',
					'title'      => esc_html__( 'Icon Background Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Back Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-icon-holder' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'back_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'back_icon_border_color',
					'title'      => esc_html__( 'Icon Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Back Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-icon-holder' => 'border-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'back_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'back_icon_stroke_color',
					'title'      => esc_html__( 'Icon Stroke Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Back Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-icon-holder svg' => 'stroke: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'back_icon[library]' => array(
								'values'        => 'svg',
								'default_value' => '',
							),
						),
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'back_icon_box_size',
					'title'      => esc_html__( 'Icon Box Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-icon-holder' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Back Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'back_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'back_icon_border_width',
					'title'      => esc_html__( 'Icon Border Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em'),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 30,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-icon-holder' => 'border-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Back Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'back_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'back_icon_border_radius',
					'title'      => esc_html__( 'Icon Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-icon-holder' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Back Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'back_icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'number',
					'name'          => 'back_icon_stroke_width',
					'title'         => esc_html__( 'Icon Stroke Width', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Back Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'     => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-icon-holder svg' => 'stroke-width: {{VALUE}};',
					),
					'default_value' => 1,
					'dependency'    => array(
						'show' => array(
							'back_icon[library]' => array(
								'values'        => 'svg',
								'default_value' => '',
							),
						),
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'heading',
					'name'       => 'back_title_style_heading',
					'title'      => esc_html__( 'Back Title', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Back Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'back_title_tag',
					'title'      => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Back Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'back_title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Back Typography Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-title' => 'color: {{VALUE}};',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'back_title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-title',
					'group'      => esc_html__( 'Back Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type'  => 'dimensions',
					'name'        => 'back_title_padding',
					'title'       => esc_html__( 'Title Padding', 'qi-addons-for-elementor-premium' ),
					'group'       => esc_html__( 'Back Typography Style', 'qi-addons-for-elementor-premium' ),
					'size_units'  => array( 'px', '%', 'em' ),
					'responsive'  => true,
					'selectors'   => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'back_title_typography_divider',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'       => esc_html__( 'Back Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'heading',
					'name'       => 'back_description_style_heading',
					'title'      => esc_html__( 'Back Description', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Back Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'back_description_color',
					'title'      => esc_html__( 'Description Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-description-holder > *' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Back Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'back_description_typography',
					'title'      => esc_html__( 'Description Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-description-holder > *',
					'group'      => esc_html__( 'Back Typography Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type'  => 'dimensions',
					'name'        => 'back_description_padding',
					'title'       => esc_html__( 'Description Padding', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'set up and bottom padding', 'qi-addons-for-elementor-premium' ),
					'group'       => esc_html__( 'Back Typography Style', 'qi-addons-for-elementor-premium' ),
					'size_units'  => array( 'px', '%', 'em' ),
					'responsive'  => true,
					'selectors'   => array(
						'{{WRAPPER}} .qodef-qi-flip-box-back .qodef-back-description-holder' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);
			
			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class', 'button_text', 'button_link' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'background',
					'name'       => 'overlay_background',
					'title'      => esc_html__( 'Background', 'qi-addons-for-elementor-premium' ),
					'types'      => array( 'classic', 'gradient', 'video' ),
					'selector'   => '{{WRAPPER}} .qodef-qi-flip-box .qodef-qi-flip-overlay .qodef-qi-flip-overlay-inner',
					'group'      => esc_html__( 'Overlay Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'overlay_opacity',
					'title'      => esc_html__( 'Opacity', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Overlay Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( '%' ),
					'range'      => array(
						'%' => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-flip-box .qodef-qi-flip-overlay .qodef-qi-flip-overlay-inner' => 'opacity: calc({{SIZE}}/100);',
					),
				)
			);
			
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['button_params']  = $this->generate_button_params( $atts );
			$atts['this_object']    = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/flip-box', 'templates/flip-box', '', $atts );
		}


		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-flip-box';
			$holder_classes[] = 'qodef-qi-trigger-'.$atts['trigger'];
			$holder_classes[] = 'qodef-qi-animation-type-'.$atts['animation_type'];
			$holder_classes[] = 'qodef-qi-animation-direction-'.$atts['animation_direction'];
			$holder_classes[] = ( 'yes' === $atts['front_icon_boxed'] ) ? 'qodef-front-icon-boxed' : '';
			$holder_classes[] = ( 'yes' === $atts['back_icon_boxed'] ) ? 'qodef-back-icon-boxed' : '';
			$holder_classes[] = ( 'yes' === $atts['3d_effect'] ) ? 'qodef-3d-effect' : '';

			return implode( ' ', $holder_classes );
		}

		
		private function generate_button_params( $atts ) {
			if ( $atts['button_link']['url'] ) {
				$atts['button_text'] = ! empty( $atts['button_text'] ) ? esc_html( $atts['button_text'] ) : esc_html__( 'Click Here', 'qi-addons-for-elementor-premium' );
				$params = $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_button',
						'exclude'        => array( 'custom_class' ),
						'atts'           => $atts,
					)
				);
				return $params;
			}
			return array();
		}

	}
}
