<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_floating_item_showcase_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_floating_item_showcase_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Floating_Item_Showcase_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_floating_item_showcase_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Floating_Item_Showcase_Shortcode extends QiAddonsForElementor_List_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_floating_item_showcase_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/floating-item-showcase' );
			$this->set_base( 'qi_addons_for_elementor_premium_floating_item_showcase' );
			$this->set_name( esc_html__( 'Floating Item Showcase', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays floating items', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/floating-item-showcase/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#floating_item_showcase' );
			$this->set_scripts(
				array(
					'smooth-scrollbar' => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/smooth-scrollbar/smooth-scrollbar.js',
						'dependency' => array( 'jquery' ),
					),
					'overscroll'       => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/smooth-scrollbar/overscroll.js',
						'dependency' => array( 'jquery' ),
					),
					'gsap'             => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/gsap.min.js',
						'dependency' => array( 'jquery' ),
					),
					'scroll-trigger'   => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/ScrollTrigger.min.js',
						'dependency' => array( 'jquery' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'overlay_title',
					'title'      => esc_html__( 'Overlay Title', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_overlay_image',
					'title'         => esc_html__( 'Enable Overlay Image', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'overlay_image',
					'title'      => esc_html__( 'Overlay Image', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'enable_overlay_image' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'overlay_position',
					'title'      => esc_html__( 'Overlay Title\Image Position', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'back'  => esc_html__( 'Back', 'qi-addons-for-elementor-premium' ),
						'front' => esc_html__( 'Front', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_image'    => $placeholder,
							'item_link'     => array(),
							'item_title'    => esc_html__( 'Item Title 1', 'qi-addons-for-elementor-premium' ),
							'item_subtitle' => esc_html__( 'Item Subtitle 1', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_image'             => $placeholder,
							'item_link'              => array(),
							'item_title'             => esc_html__( 'Item Title 2', 'qi-addons-for-elementor-premium' ),
							'item_subtitle'          => esc_html__( 'Item Subtitle 2', 'qi-addons-for-elementor-premium' ),
							'item_top_offset'        => array(
								'size' => 200,
								'unit' => 'px',
							),
							'item_horizontal_offset' => array(
								'size' => 0,
								'unit' => 'px',
							),
							'item_offset_alignment'  => 'right',
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'text',
							'name'          => 'item_title',
							'title'         => esc_html__( 'Item Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'title' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_subtitle',
							'title'         => esc_html__( 'Item Subtitle', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'subtitle' ),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Item Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Item Link', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'item_width',
							'title'      => esc_html__( 'Item Width', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', 'vw', 'em' ),
							'range'      => array(
								'px' => array(
									'min' => 0,
									'max' => 1000,
								),
								'em' => array(
									'min' => 0,
									'max' => 100,
								),
							),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}} img' => 'max-width: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'item_top_offset',
							'title'      => esc_html__( 'Item Top Offset', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', 'vh', 'em' ),
							'range'      => array(
								'px' => array(
									'min' => 0,
									'max' => 2000,
								),
								'em' => array(
									'min' => 0,
									'max' => 100,
								),
							),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type'    => 'select',
							'name'          => 'item_offset_alignment',
							'title'         => esc_html__( 'Item Alignment', 'qi-addons-for-elementor-premium' ),
							'options'       => array(
								'left'  => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
								'right' => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
							),
							'default_value' => 'left',
							'group'         => esc_html__( 'Overlay Title\Image Style', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'item_horizontal_offset',
							'title'      => esc_html__( 'Item Offset', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', 'vw', 'em' ),
							'range'      => array(
								'px' => array(
									'min' => 0,
									'max' => 2000,
								),
								'em' => array(
									'min' => 0,
									'max' => 100,
								),
							),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}}' => '{{item_offset_alignment.value}}: {{SIZE}}{{UNIT}};',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'overlay_title_tag',
					'title'      => esc_html__( 'Overlay Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Overlay Title\Image Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'overlay_title_color',
					'title'      => esc_html__( 'Overlay Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-overlay-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Overlay Title\Image Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'overlay_title_typography',
					'title'      => esc_html__( 'Overlay Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-overlay-title',
					'group'      => esc_html__( 'Overlay Title\Image Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'  => 'slider',
					'name'        => 'overlay_title_padding',
					'title'       => esc_html__( 'Overlay Title\Image Padding', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'set left and right padding', 'qi-addons-for-elementor-premium' ),
					'group'       => esc_html__( 'Overlay Title\Image Style', 'qi-addons-for-elementor-premium' ),
					'size_units'  => array( 'px', '%', 'em' ),
					'responsive'  => true,
					'selectors'   => array(
						'{{WRAPPER}} .qodef-e-overlay-title-holder' => 'padding: 0 {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-e-overlay-image-holder' => 'padding: 0 {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'item_layout',
					'title'         => esc_html__( 'Item Layout', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'info_on_hover' => esc_html__( 'Info On Hover', 'qi-addons-for-elementor-premium' ),
						'info_below'    => esc_html__( 'Info Below', 'qi-addons-for-elementor-premium' ),
						'info_follow'   => esc_html__( 'Info Follow', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'info_on_hover',
					'group'         => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'image_grayscale',
					'title'         => esc_html__( 'Image Grayscale', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
					'default_value' => '',
					'dependency'    => array(
						'show' => array(
							'item_layout' => array(
								'values'        => array( 'info_below', 'info_follow' ),
								'default_value' => 'info_on_hover',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'title_tag',
					'title'      => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} article .qodef-e-title' => 'color: {{VALUE}};',
						'.qodef-{{ID}} .qodef-e-title'       => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} article .qodef-e-title, .qodef-{{ID}} .qodef-e-title',
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'subtitle_tag',
					'title'      => esc_html__( 'Subtitle Tag', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag' ),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} article .qodef-e-subtitle' => 'color: {{VALUE}};',
						'.qodef-{{ID}} .qodef-e-subtitle'       => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'subtitle_typography',
					'title'      => esc_html__( 'Subtitle Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} article .qodef-e-subtitle, .qodef-{{ID}} .qodef-e-subtitle',
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'hover_background_color',
					'title'      => esc_html__( 'Hover Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} article .qodef-e-content .qodef-e-content-inner' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'item_layout' => array(
								'values'        => 'info_on_hover',
								'default_value' => 'info_on_hover',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'info_follow_background_color',
					'title'      => esc_html__( 'Info Follow Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'.qodef-{{ID}} .qodef-e-content > *' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'item_layout' => array(
								'values'        => 'info_follow',
								'default_value' => 'info_on_hover',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'           => 'checkbox',
					'name'                 => 'info_follow_text_blend_mode',
					'title'                => esc_html__( 'Info Follow Text Blend Mode', 'qi-addons-for-elementor-premium' ),
					'group'                => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
					'default_value'        => '',
					'selectors_dictionary' => array(
						'yes' => 'mix-blend-mode: difference;',
						''    => '',
					),
					'selectors'            => array(
						'.qodef-{{ID}}' => '{{VALUE}}',
					),
					'dependency'           => array(
						'show' => array(
							'item_layout' => array(
								'values'        => 'info_follow',
								'default_value' => 'info_on_hover',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'info_follow_max_width',
					'title'      => esc_html__( 'Info Follow Max Width', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1000,
						),
					),
					'selectors'  => array(
						'.qodef-{{ID}}' => 'max-width: {{SIZE}}{{UNIT}}',
					),
					'dependency' => array(
						'show' => array(
							'item_layout' => array(
								'values'        => 'info_follow',
								'default_value' => 'info_on_hover',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'subtitle_margin_bottom',
					'title'      => esc_html__( 'Subtitle Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} article .qodef-e-subtitle'            => 'margin-bottom: {{SIZE}}{{UNIT}};',
						'.qodef-{{ID}} .qodef-e-content .qodef-e-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'image_margin_bottom',
					'title'      => esc_html__( 'Image Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} article .qodef-e-image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'item_layout' => array(
								'values'        => 'info_below',
								'default_value' => 'info_on_hover',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'appear_animation',
					'title'      => esc_html__( 'Appear Animation', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Appear Animation', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'from-bottom' => esc_html__( 'From Bottom', 'qi-addons-for-elementor-premium' ),
						'from-center' => esc_html__( 'From Center', 'qi-addons-for-elementor-premium' ),
						''            => esc_html__( 'None', 'qi-addons-for-elementor-premium' ),
					),
					'default_value'    => 'from-bottom',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'cursor_follow_image_enable',
					'title'         => esc_html__( 'Enable Cursor Follow Image', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'no',
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'cursor_follow_image',
					'title'      => esc_html__( 'Cursor Follow Image', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'cursor_follow_image_enable' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);

			$this->map_extra_options();
		}

		public function load_assets() {
			wp_enqueue_script( 'smooth-scrollbar' );
			wp_enqueue_script( 'overscroll' );
			wp_enqueue_script( 'gsap' );
			wp_enqueue_script( 'scroll-trigger' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['behavior']               = 'masonry';
			$atts['holder_classes']         = $this->get_holder_classes( $atts );
			$atts['masonry_holder_classes'] = $this->get_masonry_holder_classes( $atts );
			$atts['item_classes']           = $this->get_item_classes( $atts );
			$atts['items']                  = $this->parse_repeater_items( $atts['children'] );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/floating-item-showcase', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-floating-item-showcase';
			$holder_classes[] = 'qodef-qi--' . $atts['item_layout'];
			$holder_classes[] = 'yes' == $atts['image_grayscale'] ? 'qodef-qi--grayscale-images' : '';
			$holder_classes[] = ! empty( $atts['appear_animation'] ) ? 'qodef-qi--appear-animation-' . $atts['appear_animation'] : '';
			$holder_classes[] = 'yes' == $atts['cursor_follow_image_enable'] ? 'qodef-qi--cursor-follow-image-enabled' : '';

			return implode( ' ', $holder_classes );
		}

		private function get_masonry_holder_classes( $atts ) {

			$holder_classes = array( 'qodef-masonry-holder' );

			$atts['columns'] = 2;

			$list_classes   = $this->get_list_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $list_classes );

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes      = $this->init_item_classes();
			$list_item_classes = $this->get_list_item_classes( $atts );
			$item_classes      = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}
	}
}
