<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_google_map_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_google_map_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Google_Map_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_google_map_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Google_Map_Shortcode extends QiAddonsForElementor_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/google-map' );
			$this->set_base( 'qi_addons_for_elementor_premium_google_map' );
			$this->set_name( esc_html__( 'Google Map', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays google map with provided parameters', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Business', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/google-map/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#google_map' );
			$this->set_video( 'https://www.youtube.com/watch?v=chLFKAkAU7k' );
			$this->set_option(
				array(
					'field_type' => 'note',
					'name'       => 'warning',
					'title'      => esc_html__( 'Please note that for this widget Google Maps API key must be inserted in Integration page', 'qi-addons-for-elementor-premium' ),
				)
			);

			if ( ! empty( $this->get_api_key() ) ) {
				$this->set_scripts(
					array(
						'google-map-api' => array(
							'registered' => false,
							'url'        => '//maps.googleapis.com/maps/api/js?key=' . esc_attr( $this->get_api_key() ),
							'dependency' => array( 'jquery' ),
						),
					)
				);
			}

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'address1',
					'title'      => esc_html__( 'Address 1', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'address2',
					'title'      => esc_html__( 'Address 2', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'address3',
					'title'      => esc_html__( 'Address 3', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'address4',
					'title'      => esc_html__( 'Address 4', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'image',
					'name'          => 'pin',
					'title'         => esc_html__( 'Pin Icon', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'map_height',
					'title'         => esc_html__( 'Map Height (px)', 'qi-addons-for-elementor-premium' ),
					'default_value' => '300',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'map_zoom',
					'title'         => esc_html__( 'Map Zoom', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Input the default zoom value for the map. Note that this value applies in the event that the map contains a single address only. In the event of multiple addresses being shown, Google Map reverts to its own zoom values in order to fit all the addresses on the screen.', 'qi-addons-for-elementor-premium' ),
					'default_value' => '12',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'map_style',
					'title'         => esc_html__( 'Map Style', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Enter Snazzy Map style JSON code', 'qi-addons-for-elementor-premium' ),
					'default_value' => '',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'map_drag',
					'title'         => esc_html__( 'Enable Map Dragging', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Use this option to enable map dragging', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'yes',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'map_scroll',
					'title'         => esc_html__( 'Enable Map Scroll', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Use this option to enable map scrolling', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'no',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'street_view_control',
					'title'         => esc_html__( 'Enable Map Street View Control', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Use this option to enable street view control on map', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'yes',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'map_type_control',
					'title'         => esc_html__( 'Enable Map Type Control', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Use this option to enable type control on map', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'yes',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'checkbox',
					'name'          => 'map_full_screen_control',
					'title'         => esc_html__( 'Enable Map Full Screen Control', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Use this option to enable full screen control on map', 'qi-addons-for-elementor-premium' ),
					'default_value' => 'yes',
				)
			);
		}

		public static function call_shortcode( $params ) {
			$html = qi_addons_for_elementor_framework_call_shortcode( 'qi_addons_for_elementor_premium_google_map', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$rand_number            = rand( 0, 1000 );
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['rand_number']    = $rand_number;
			$atts['holder_id']      = 'qodef-map-id--' . $rand_number;
			$atts['map_data']       = $this->get_map_data( $atts );

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/google-map', 'templates/google-map', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-google-map';
			$holder_classes[] = ( ! empty( $this->get_api_key() ) ) ? 'qodef--has-key' : '';

			return implode( ' ', $holder_classes );
		}

		private function get_map_data( $atts ) {
			$map_data = array();

			$addresses_array = array();
			if ( '' !== $atts['address1'] ) {
				array_push( $addresses_array, esc_attr( $atts['address1'] ) );
			}
			if ( '' !== $atts['address2'] ) {
				array_push( $addresses_array, esc_attr( $atts['address2'] ) );
			}
			if ( '' !== $atts['address3'] ) {
				array_push( $addresses_array, esc_attr( $atts['address3'] ) );
			}
			if ( '' !== $atts['address4'] ) {
				array_push( $addresses_array, esc_attr( $atts['address4'] ) );
			}
			if ( '' !== $atts['map_style'] ) {
				$map_syle = json_decode( $atts['map_style'] );
			}

			if ( '' !== $atts['pin'] ) {
				$map_pin = wp_get_attachment_image_src( $atts['pin'], 'full', true );
				$map_pin = $map_pin[0];
			} else {
				$map_pin = QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/google-map/assets/img/pin.png';
			}

			$map_data[] = "data-addresses='[\"" . implode( '","', $addresses_array ) . "\"]'";
			$map_data[] = 'data-pin=' . $map_pin;
			$map_data[] = 'data-unique-id=' . $atts['rand_number'];
			$map_data[] = 'data-height=' . $atts['map_height'];
			$map_data[] = 'data-zoom=' . $atts['map_zoom'];

			if ( '' !== $atts['map_style'] ) {
				$map_data[] = 'data-style=' . preg_replace( '/\s*/m', '', $atts['map_style'] );
			}
			if ( '' !== $atts['street_view_control'] ) {
				$map_data[] = 'data-street-view=' . $atts['street_view_control'];
			}
			if ( '' !== $atts['map_type_control'] ) {
				$map_data[] = 'data-map-type=' . $atts['map_type_control'];
			}

			if ( '' !== $atts['map_full_screen_control'] ) {
				$map_data[] = 'data-map-full-screen=' . $atts['map_full_screen_control'];
			}

			if ( '' !== $atts['map_drag'] ) {
				$map_data[] = 'data-map-drag=' . $atts['map_drag'];
			}

			if ( '' !== $atts['map_scroll'] ) {
				$map_data[] = 'data-map-scroll=' . $atts['map_scroll'];
			}

			return implode( ' ', $map_data );
		}

		private function get_api_key() {

			return qi_addons_for_elementor_premium_get_api_keys( 'google_maps_api_key' );

		}
	}
}
