<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_borders_to_list_shortcode' ) ) {

	function qi_addons_for_elementor_premium_add_borders_to_list_shortcode( $object, $group, $include_option ) {

		$object->set_option(
			array(
				'field_type'    => 'select',
				'name'          => 'borders',
				'title'         => esc_html__( 'Borders', 'qi-addons-for-elementor-premium' ),
				'options'       => array(
					''        => esc_html__( 'Default', 'qi-addons-for-elementor-premium' ),
					'all'     => esc_html__( 'All', 'qi-addons-for-elementor-premium' ),
					'between' => esc_html__( 'Between', 'qi-addons-for-elementor-premium' ),
				),
				'dependency'    => array(
					'hide' => array(
						'masonry_images_proportion' => array(
							'values'        => 'fixed',
							'default_value' => '',
						),
					),
				),
				'default_value' => '',
				'group'         => $group,
			)
		);

		$object->set_option(
			array(
				'field_type'    => 'color',
				'name'          => 'borders_color',
				'title'         => esc_html__( 'Borders Color', 'qi-addons-for-elementor-premium' ),
				'dependency'    => array(
					'hide' => array(
						'borders' => array(
							'values'        => '',
							'default_value' => '',
						),
					),
				),
				'default_value' => '',
				'group'         => $group,
				'selectors'     => array(
					'{{WRAPPER}} .qodef-qi-grid.qodef-borders--all .qodef-grid-inner>.qodef-grid-item:after'      => 'background: {{VALUE}};',
					'{{WRAPPER}} .qodef-qi-grid.qodef-borders--all .qodef-grid-inner>.qodef-grid-item:before'     => 'background: {{VALUE}};',
					'{{WRAPPER}} .qodef-qi-grid.qodef-borders--all .qodef-grid-inner:after'                       => 'background: {{VALUE}};',
					'{{WRAPPER}} .qodef-qi-grid.qodef-borders--all .qodef-grid-inner:before'                      => 'background    : {{VALUE}};',
					'{{WRAPPER}} .qodef-qi-grid.qodef-borders--between .qodef-grid-inner>.qodef-grid-item:after'  => 'background    : {{VALUE}};',
					'{{WRAPPER}} .qodef-qi-grid.qodef-borders--between .qodef-grid-inner>.qodef-grid-item:before' => 'background    : {{VALUE}};',
				),
			)
		);

		return $object;
	}

	add_action( 'qi_addons_for_elementor_action_map_additional_options', 'qi_addons_for_elementor_premium_add_borders_to_list_shortcode', 10, 3 );
}
