<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_horizontal_double_row_project_showcase_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_horizontal_double_row_project_showcase_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Horizontal_Double_Row_Project_Showcase_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_horizontal_double_row_project_showcase_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Horizontal_Double_Row_Project_Showcase_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_horizontal_double_row_project_showcase_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/horizontal-double-row-project-showcase' );
			$this->set_base( 'qi_addons_for_elementor_premium_horizontal_double_row_project_showcase' );
			$this->set_name( esc_html__( 'Horizontal Double Row Projects', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays projects in horizontal slider', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/horizontal-double-row-project-showcase/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#horizontal_double_row_project_showcase' );
			$this->set_video( 'https://www.youtube.com/watch?v=xCLkXwnTH5E' );
			$this->set_scripts(
				array(
					'smooth-scrollbar' => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/smooth-scrollbar/smooth-scrollbar.js',
						'dependency' => array( 'jquery' ),
					),
					'overscroll'       => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/smooth-scrollbar/overscroll.js',
						'dependency' => array( 'jquery' ),
					),
					'gsap'             => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/gsap.min.js',
						'dependency' => array( 'jquery' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'items_hover_icon',
					'title'         => esc_html__( 'Items Hover Icon', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-arrow-right',
						'library' => 'fa-solid',
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'featured_title',
					'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Featured Title', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Featured Item', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'featured_subtitle',
					'title'         => esc_html__( 'Subtitle', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Featured Subtitle', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Featured Item', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'featured_image',
					'title'      => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Featured Item', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'featured_button_text',
					'title'         => esc_html__( 'Button Text', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'See more', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Featured Item', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'link',
					'name'       => 'featured_link',
					'title'      => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Featured Item', 'qi-addons-for-elementor-premium' ),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_image'    => $placeholder,
							'item_link'     => array(),
							'item_title'    => esc_html__( 'Item Title 1', 'qi-addons-for-elementor-premium' ),
							'item_subtitle' => esc_html__( 'Item Subtitle 1', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_image'    => $placeholder,
							'item_link'     => array(),
							'item_title'    => esc_html__( 'Item Title 2', 'qi-addons-for-elementor-premium' ),
							'item_subtitle' => esc_html__( 'Item Subtitle 2', 'qi-addons-for-elementor-premium' ),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'text',
							'name'          => 'item_title',
							'title'         => esc_html__( 'Item Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'title' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_subtitle',
							'title'         => esc_html__( 'Item Subtitle', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'subtitle' ),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Item Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Item Link', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'  => 'dimensions',
					'name'        => 'padding',
					'title'       => esc_html__( 'Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'vh' ),
					'responsive'  => true,
					'selectors'   => array(
						'{{WRAPPER}} .qodef-items-holder .qodef-scroll-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .qodef-items-holder .scroll-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'       => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'  => 'slider',
					'name'        => 'height',
					'title'       => esc_html__( 'Height (vh)', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'Please note that this option will be ignored in case page height is bigger than window height', 'qi-addons-for-elementor-premium' ),
					'range'       => array(
						'px' => array(
							'min' => 10,
							'max' => 100,
						),
					),
					'responsive'  => true,
					'selectors'   => array(
						'{{WRAPPER}} .qodef-qi-horizontal-double-row-project-showcase:not(.qodef-horizontal-scroll-in-content)' => 'height: {{SIZE}}vh;',
					),
					'group'       => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_items',
					'title'      => esc_html__( 'Space Between Items', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 50,
							'max' => 500,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} article' => 'margin-left: {{SIZE}}{{UNIT}}; margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_color',
					'title'      => esc_html__( 'Icon Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-image .qodef-e-icon-holder-inner' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_size',
					'title'      => esc_html__( 'Icon Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-image .qodef-e-icon-holder-inner' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_background_image',
					'title'         => esc_html__( 'Enable Background Image', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Background Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'image',
					'name'          => 'background_image',
					'title'         => esc_html__( 'Background Image', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Background Style', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'enable_background_image' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'background_image_vertical_offset',
					'title'      => esc_html__( 'Background Image Vertical Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-background' => 'top: {{SIZE}}{{UNIT}};',
					),
					'dependency'    => array(
						'show' => array(
							'enable_background_image' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
					'group'      => esc_html__( 'Background Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'item_width',
					'title'      => esc_html__( 'Width', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 600,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} article:not(.qodef-e-featured)' => 'width: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'hover_background_color',
					'title'      => esc_html__( 'Hover Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-image .qodef-e-icon-holder' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h4',
					'group'         => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-title-link' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-title-link',
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'subtitle_tag',
					'title'         => esc_html__( 'Subtitle Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'p',
					'group'         => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} article .qodef-e-subtitle' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'subtitle_typography',
					'title'      => esc_html__( 'Subtitle Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} article .qodef-e-subtitle',
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_margin_top',
					'title'      => esc_html__( 'Title Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-title' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'subtitle_margin_top',
					'title'      => esc_html__( 'Subtitle Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-subtitle' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'featured_item_width',
					'title'      => esc_html__( 'Width', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Featured Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} article.qodef-e-featured' => 'width: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'featured_title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Featured Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'featured_title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-title-featured' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Featured Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'featured_title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-title-featured',
					'group'      => esc_html__( 'Featured Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'featured_subtitle_tag',
					'title'         => esc_html__( 'Subtitle Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'p',
					'group'         => esc_html__( 'Featured Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'featured_subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} article.qodef-e-featured .qodef-e-featured-subtitle' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Featured Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'featured_subtitle_typography',
					'title'      => esc_html__( 'Subtitle Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} article.qodef-e-featured .qodef-e-featured-subtitle',
					'group'      => esc_html__( 'Featured Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'featured_subtitle_margin_top',
					'title'      => esc_html__( 'Content Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Featured Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-content-featured' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'featured_title_margin_top',
					'title'      => esc_html__( 'Title Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Featured Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-title-featured' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'featured_button_margin_top',
					'title'      => esc_html__( 'Button Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Spacing Featured Item Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-featured-read-more' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class', 'button_text', 'button_link' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Featured Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->map_extra_options();
		}

		public function load_assets() {
			wp_enqueue_script( 'smooth-scrollbar' );
			wp_enqueue_script( 'overscroll' );
			wp_enqueue_script( 'gsap' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['holder_classes']    = $this->get_holder_classes( $atts );
			$atts['items']             = $this->parse_repeater_items( $atts['children'] );
			$atts['button_params']     = $this->generate_button_params( $atts );
			$atts['background_styles'] = $this->get_background_styles( $atts );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/horizontal-double-row-project-showcase', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-horizontal-double-row-project-showcase';

			return implode( ' ', $holder_classes );
		}

		private function generate_button_params( $atts ) {
			$atts['button_link'] = $atts['featured_link'];
			$atts['button_text'] = ! empty( $atts['featured_button_text'] ) ? esc_html( $atts['featured_button_text'] ) : esc_html__( 'Read More', 'qi-addons-for-elementor-premium' );

			$button_params = $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'qi_addons_for_elementor_button',
					'exclude'        => array( 'custom_class' ),
					'atts'           => $atts,
				)
			);

			return $button_params;
		}

		public function get_background_styles( $atts ) {
			$styles = array();

			$styles[] = ! empty( $atts['background_image'] ) ? 'background-image: url(' . wp_get_attachment_url( $atts['background_image'] ) . ')' : '';

			return $styles;
		}
	}
}





