<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_hover_aware_slider_variation_standard' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_hover_aware_slider_variation_standard( $variations ) {
		$variations['standard'] = esc_html__( 'Standard', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_hover_aware_slider_layouts', 'qi_addons_for_elementor_premium_add_hover_aware_slider_variation_standard' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_hover_aware_slider_standard_add_extra_options' ) ) {
	function qi_addons_for_elementor_premium_hover_aware_slider_standard_add_extra_options( $extra_options ) {
		$standard = array();

		$standard_text = array(
			'field_type'    => 'textarea',
			'name'          => 'standard_text',
			'title'         => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
			'dependency'    => array(
				'show' => array(
					'layout' => array(
						'values'        => 'standard',
						'default_value' => '',
					),
				),
			),
			'default_value' => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
		);

		$standard_text_position = array(
			'field_type'    => 'select',
			'name'          => 'standard_text_position',
			'title'         => esc_html__( 'Text Position', 'qi-addons-for-elementor-premium' ),
			'options'       => array(
				'flex-start' => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
				'center'     => esc_html__( 'Middle', 'qi-addons-for-elementor-premium' ),
				'flex-end'   => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
			),
			'default_value' => 'center',
			'selectors'     => array(
				'{{WRAPPER}} .qodef-layout--standard .qodef-m-main-holder' => 'align-items: {{VALUE}};',
			),
			'dependency'    => array(
				'show' => array(
					'layout' => array(
						'values'        => 'standard',
						'default_value' => '',
					),
				),
			),
			'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
		);

		$standard_item_direction = array(
			'field_type' => 'select',
			'name'       => 'standard_item_direction',
			'title'      => esc_html__( 'Item Direction', 'qi-addons-for-elementor-premium' ),
			'options'    => array(
				'column' => esc_html__( 'Vertical', 'qi-addons-for-elementor-premium' ),
				'row'    => esc_html__( 'Horizontal', 'qi-addons-for-elementor-premium' ),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-layout--standard .qodef-m-items' => 'flex-direction: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'standard',
						'default_value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
		);

		$standard_text_alignment = array(
			'field_type' => 'choose',
			'name'       => 'standard_text_alignment',
			'title'      => esc_html__( 'Text Alignment', 'qi-addons-for-elementor-premium' ),
			'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
			'responsive' => true,
			'selectors'  => array(
				'{{WRAPPER}} .qodef-layout--standard .qodef-m-text' => 'text-align: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'standard',
						'default_value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
		);

		$standard[] = $standard_text;
		$standard[] = $standard_text_position;
		$standard[] = $standard_item_direction;
		$standard[] = $standard_text_alignment;

		return array_merge( $extra_options, $standard );
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_hover_aware_slider_extra_options', 'qi_addons_for_elementor_premium_hover_aware_slider_standard_add_extra_options' );
}
