<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_icon_progress_bar_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_icon_progress_bar_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Icon_Progress_Bar_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_icon_progress_bar_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Icon_Progress_Bar_Shortcode extends QiAddonsForElementor_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/icon-progress-bar' );
			$this->set_base( 'qi_addons_for_elementor_premium_icon_progress_bar' );
			$this->set_name( esc_html__( 'Icon Progress Bar', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that adds icon progress bar', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Infographics', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/icon-progress-bar/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#icon_progress_bar' );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'icon',
					'title'         => esc_html__( 'Icon', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-bolt',
						'library' => 'solid',
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'number',
					'name'          => 'icons_number',
					'default_value' => 10,
					'title'         => esc_html__( 'Number of Icons', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'number',
					'name'          => 'active_icons_number',
					'default_value' => 5,
					'title'         => esc_html__( 'Number of Active Icons', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space',
					'title'      => esc_html__( 'Gap Between Icons', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar' => 'gap: {{SIZE}}{{UNIT}};',
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'number',
					'name'          => 'icon_animation_delay',
					'default_value' => 100,
					'title'         => esc_html__( 'Icon Animation Delay (ms)', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'slider',
					'name'          => 'animation_start',
					'title'         => esc_html__( 'Animation Start (%)', 'qi-addons-for-elementor-premium' ),
					'description'   => esc_html__( 'Input a value in % corresponding to the total amount of the widget height (relative to browser bottom) that you wish to be visible before the animation starts.', 'qi-addons-for-elementor-premium' ),
					'size_units'    => array( '%' ),
					'range'         => array(
						'%' => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'default_value' => array(
						'unit' => '%',
						'size' => '15',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'icon_boxed',
					'title'         => esc_html__( 'Boxed', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'no_yes', true ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_size',
					'title'      => esc_html__( 'Size', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder' => 'font-size: {{SIZE}}{{UNIT}};',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_color',
					'title'      => esc_html__( 'Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder' => 'color: {{VALUE}};',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'active_icon_color',
					'title'      => esc_html__( 'Active Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder.qodef-active' => 'color: {{VALUE}};',
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_background_color',
					'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'active_icon_background_color',
					'title'      => esc_html__( 'Active Background Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder.qodef-active' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_border_color',
					'title'      => esc_html__( 'Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder' => 'border-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'active_icon_border_color',
					'title'      => esc_html__( 'Active Border Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder.qodef-active' => 'border-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_stroke_color',
					'title'      => esc_html__( 'Stroke Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder svg' => 'stroke: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'icon[library]' => array(
								'values'        => 'svg',
								'default_value' => '',
							),
						),
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'active_icon_stroke_color',
					'title'      => esc_html__( 'Active Stroke Color', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder.qodef-active svg' => 'stroke: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'icon[library]' => array(
								'values'        => 'svg',
								'default_value' => '',
							),
						),
					),
				)
			);
			
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_box_size',
					'title'      => esc_html__( 'Box Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'icon_border_width',
					'title'      => esc_html__( 'Border Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em'),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 30,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder' => 'border-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'icon_border_radius',
					'title'      => esc_html__( 'Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'icon_boxed' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'number',
					'name'          => 'icon_stroke_width',
					'title'         => esc_html__( 'Stroke Width', 'qi-addons-for-elementor-premium' ),
					'group'         => esc_html__( 'Icon Style', 'qi-addons-for-elementor-premium' ),
					'selectors'     => array(
						'{{WRAPPER}} .qodef-qi-icon-progress-bar .qodef-icon-holder svg' => 'stroke-width: {{VALUE}};',
					),
					'default_value' => 1,
					'dependency'    => array(
						'show' => array(
							'icon[library]' => array(
								'values'        => 'svg',
								'default_value' => '',
							),
						),
					),
				)
			);
			
			
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			//$atts['button_params']  = $this->generate_button_params( $atts );
			$atts['this_object']    = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/icon-progress-bar', 'templates/icon-progress-bar', '', $atts );
		}


		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-icon-progress-bar';
			$holder_classes[] = ( 'yes' === $atts['icon_boxed'] ) ? 'qodef-icon-boxed' : '';

			return implode( ' ', $holder_classes );
		}

		
		private function generate_button_params( $atts ) {
			if ( $atts['button_link']['url'] ) {
				$atts['button_text'] = ! empty( $atts['button_text'] ) ? esc_html( $atts['button_text'] ) : esc_html__( 'Click Here', 'qi-addons-for-elementor-premium' );
				$params = $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_button',
						'exclude'        => array( 'custom_class' ),
						'atts'           => $atts,
					)
				);
				return $params;
			}
			return array();
		}

	}
}
