<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_image_hotspots_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_image_hotspots_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Image_Hotspots_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_image_hotspots_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Image_Hotspots_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_image_hotspots_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/image-hotspots' );
			$this->set_base( 'qi_addons_for_elementor_premium_image_hotspots' );
			$this->set_name( esc_html__( 'Image Hotspots', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays image hotspots', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Showcase', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/image-hotspots/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#image_hotspots' );
			$this->set_video( 'https://www.youtube.com/watch?v=_bDjp81kN7U' );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'main_image',
					'title'      => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Spots', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_title'                   => esc_html__( 'Example Title 1', 'qi-addons-for-elementor-premium' ),
							'item_subtitle'                => esc_html__( 'Example Subtitle 1', 'qi-addons-for-elementor-premium' ),
							'item_pin_vertical_position'   => 'top',
							'item_pin_horizontal_position' => 'left',
						),
						array(
							'item_title'    => esc_html__( 'Example Title 2', 'qi-addons-for-elementor-premium' ),
							'item_subtitle' => esc_html__( 'Example Subtitle 2', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'item_title'                   => esc_html__( 'Example Title 3', 'qi-addons-for-elementor-premium' ),
							'item_subtitle'                => esc_html__( 'Example Subtitle 3', 'qi-addons-for-elementor-premium' ),
							'item_pin_vertical_position'   => 'middle',
							'item_pin_horizontal_position' => 'right',
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'text',
							'name'          => 'item_title',
							'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Example Title', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_subtitle',
							'title'         => esc_html__( 'Subtitle', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Example Subtitle', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'link',
							'name'          => 'item_link',
							'title'         => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'icons',
							'name'          => 'item_pin',
							'title'         => esc_html__( 'Pin', 'qi-addons-for-elementor-premium' ),
							'default_value' => array(),
						),
						array(
							'field_type'    => 'select',
							'name'          => 'item_pin_horizontal_position',
							'title'         => esc_html__( 'Pin Horizontal Position', 'qi-addons-for-elementor-premium' ),
							'options'       => array(
								'left'   => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
								'center' => esc_html__( 'Center', 'qi-addons-for-elementor-premium' ),
								'right'  => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
							),
							'default_value' => 'center',
						),
						array(
							'field_type'    => 'select',
							'name'          => 'item_pin_vertical_position',
							'title'         => esc_html__( 'Pin Vertical Position', 'qi-addons-for-elementor-premium' ),
							'options'       => array(
								'top'    => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
								'middle' => esc_html__( 'Middle', 'qi-addons-for-elementor-premium' ),
								'bottom' => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
							),
							'default_value' => 'middle',
						),
						array(
							'field_type' => 'slider',
							'name'       => 'item_pin_vertical_offset',
							'title'      => esc_html__( 'Pin Vertical Offset', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%' ),
							'range'      => array(
								'px' => array(
									'min' => - 1000,
									'max' => 1000,
								),
								'%'  => array(
									'min' => - 100,
									'max' => 100,
								),
							),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}}.qodef-vertical--top.qodef-e-item' => 'top: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} {{CURRENT_ITEM}}.qodef-vertical--middle.qodef-e-item' => 'top: calc(50% + {{SIZE}}{{UNIT}});',
								'{{WRAPPER}} {{CURRENT_ITEM}}.qodef-vertical--bottom.qodef-e-item' => 'bottom: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'item_pin_horizontal_offset',
							'title'      => esc_html__( 'Pin Horizontal Offset', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%' ),
							'range'      => array(
								'px' => array(
									'min' => - 1000,
									'max' => 1000,
								),
								'%'  => array(
									'min' => - 100,
									'max' => 100,
								),
							),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}}.qodef-horizontal--left.qodef-e-item' => 'left: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} {{CURRENT_ITEM}}.qodef-horizontal--center.qodef-e-item' => 'left: calc(50% + {{SIZE}}{{UNIT}});',
								'{{WRAPPER}} {{CURRENT_ITEM}}.qodef-horizontal--right.qodef-e-item' => 'right: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type'    => 'select',
							'name'          => 'item_fade_info_position',
							'title'         => esc_html__( 'Fade Info Position', 'qi-addons-for-elementor-premium' ),
							'options'       => array(
								''       => esc_html__( 'Default', 'qi-addons-for-elementor-premium' ),
								'top'    => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
								'right'  => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
								'bottom' => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
								'left'   => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
							),
							'default_value' => '',
							'description'   => esc_html__( 'Option will take effect for fade option for Info Display', 'qi-addons-for-elementor-premium' ),
							'group'         => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'icons',
					'name'          => 'pin',
					'title'         => esc_html__( 'Pin', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						'value'   => 'fas fa-plus',
						'library' => 'solid',
					),
					'group'         => esc_html__( 'Pin Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'pin_color',
					'title'      => esc_html__( 'Pin Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-pin' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Pin Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'pin_size',
					'title'      => esc_html__( 'Pin Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 1,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-pin .qodef-e-icon' => 'font-size: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Pin Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'divider',
					'name'       => 'item_divider_pin_mid',
					'title'      => esc_html__( 'Divider', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Pin Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'pin_background_color',
					'title'      => esc_html__( 'Pin Holder Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-pin' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Pin Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'pin_holder_size',
					'title'      => esc_html__( 'Pin Holder Size', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => 1,
							'max' => 300,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-pin' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Pin Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'pin_border_radius',
					'title'      => esc_html__( 'Pin Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em', '%' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-pin' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Pin Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'info_display',
					'title'      => esc_html__( 'Info Display', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'fade'   => esc_html__( 'Fade in', 'qi-addons-for-elementor-premium' ),
						'reveal' => esc_html__( 'Reveal', 'qi-addons-for-elementor-premium' ),
					),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'info_position',
					'title'         => esc_html__( 'Info Position', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'top'    => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
						'right'  => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
						'bottom' => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
						'left'   => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'top',
					'dependency'    => array(
						'show' => array(
							'info_display' => array(
								'values'        => 'fade',
								'default_value' => 'fade',
							),
						),
					),
					'group'         => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'info_with_arrow',
					'title'      => esc_html__( 'Info With Arrow', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'dependency' => array(
						'show' => array(
							'info_display' => array(
								'values'        => 'fade',
								'default_value' => 'fade',
							),
						),
					),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'info_offset_from_pin',
					'title'      => esc_html__( 'Info Offset from Pin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => -100,
							'max' => 100,
						),
						'%'  => array(
							'min' => -100,
							'max' => 100,
						),
						'em' => array(
							'min' => -100,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-info-position--top.qodef-e-item .qodef-e-info' => 'bottom: calc( 100% + {{SIZE}}{{UNIT}});',
						'{{WRAPPER}} .qodef-info-position--right.qodef-e-item .qodef-e-info' => 'left: calc( 100% + {{SIZE}}{{UNIT}});',
						'{{WRAPPER}} .qodef-info-position--bottom.qodef-e-item .qodef-e-info' => 'top: calc( 100% + {{SIZE}}{{UNIT}});',
						'{{WRAPPER}} .qodef-info-position--left.qodef-e-item .qodef-e-info' => 'right: calc( 100% + {{SIZE}}{{UNIT}});',
					),
					'dependency' => array(
						'show' => array(
							'info_display' => array(
								'values'        => 'fade',
								'default_value' => 'fade',
							),
						),
					),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'info_background_color',
					'title'      => esc_html__( 'Info Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-info' => 'background-color: {{VALUE}}; border-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'info_padding',
					'title'      => esc_html__( 'Info Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'info_border_radius',
					'title'      => esc_html__( 'Info Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-info' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h5',
					'group'         => esc_html__( 'Info Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Info Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-title',
					'group'      => esc_html__( 'Info Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_margin_bottom',
					'title'      => esc_html__( 'Title Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Info Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item .qodef-e-subtitle' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Info Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'subtitle_typography',
					'title'      => esc_html__( 'Subtitle Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-subtitle',
					'group'      => esc_html__( 'Info Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/image-hotspots', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-image-hotspots';
			$holder_classes[] = ! empty( $atts['info_display'] ) ? 'qodef-info--' . $atts['info_display'] : '';
			$holder_classes[] = ! empty( $atts['info_with_arrow'] ) ? 'qodef-info-arrow--' . $atts['info_with_arrow'] : '';

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts, $item ) {
			$item_classes = $this->init_item_classes();

			$item_classes[] = 'qodef-e-item';
			$item_classes[] = ! empty( $item['item_pin_vertical_position'] ) ? 'qodef-vertical--' . $item['item_pin_vertical_position'] : '';
			$item_classes[] = ! empty( $item['item_pin_horizontal_position'] ) ? 'qodef-horizontal--' . $item['item_pin_horizontal_position'] : '';

			if ( ! empty( $item['item_fade_info_position'] ) ) {
				$item_classes[] = 'qodef-info-position--' . $item['item_fade_info_position'];
			} elseif ( ! empty( $atts['info_position'] ) ) {
				$item_classes[] = 'qodef-info-position--' . $atts['info_position'];
			}

			return implode( ' ', $item_classes );
		}
	}
}
