<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_image_marquee_variation_vertical' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_image_marquee_variation_vertical( $variations ) {
		$variations['vertical'] = esc_html__( 'Vertical', 'qi-addons-for-elementor-premium' );

		return $variations;
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_image_marquee_layouts', 'qi_addons_for_elementor_premium_add_image_marquee_variation_vertical' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_image_marquee_vertical_add_extra_options' ) ) {
	function qi_addons_for_elementor_premium_image_marquee_vertical_add_extra_options( $extra_options ) {
		$vertical = array();

		$vertical_text = array(
			'field_type' => 'slider',
			'name'       => 'vertical_height',
			'title'      => esc_html__( 'Vertical Height', 'qi-addons-for-elementor-premium' ),
			'size_units' => array( 'px', '%', 'vh' ),
			'range'      => array(
				'px' => array(
					'min' => 0,
					'max' => 1000,
				),
			),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-layout--vertical' => 'height: {{SIZE}}{{UNIT}};',
			),
			'responsive' => true,
		);

		$vertical[] = $vertical_text;

		return array_merge( $extra_options, $vertical );
	}

	add_filter( 'qi_addons_for_elementor_premium_filter_image_marquee_extra_options', 'qi_addons_for_elementor_premium_image_marquee_vertical_add_extra_options' );
}
