<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_image_slider_image_hovers' ) ) {
	function qi_addons_for_elementor_premium_image_slider_image_hovers( $image_hovers ) {
		//to move 'None' value to the end
		$none = $image_hovers[''];
		unset( $image_hovers[''] );

		$image_hovers['distort']        = esc_html__( 'Distort', 'qi-addons-for-elementor-premium' );
		$image_hovers['grayscale-idle'] = esc_html__( 'Grayscale Idle Images', 'qi-addons-for-elementor-premium' );
		$image_hovers['grayscale']      = esc_html__( 'Grayscale Image Effect', 'qi-addons-for-elementor-premium' );
		$image_hovers['invert']         = esc_html__( 'Invert Colors', 'qi-addons-for-elementor-premium' );
		$image_hovers['gradient']       = esc_html__( 'Gradient', 'qi-addons-for-elementor-premium' );
		$image_hovers['']               = $none;

		return $image_hovers;
	}

	add_filter( 'qi_addons_for_elementor_image_slider_filter_image_hover', 'qi_addons_for_elementor_premium_image_slider_image_hovers' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_image_slider_extra_options' ) ) {
	function qi_addons_for_elementor_premium_image_slider_extra_options( $options ) {
		$extra_options = array();

		$gradient_color_1 = array(
			'field_type' => 'color',
			'name'       => 'gradient_color_1',
			'title'      => esc_html__( 'Gradient Color 1', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Gradient Style', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-image--hover-gradient' => '--qi-gradient-color-1: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'image_hover' => array(
						'values'        => 'gradient',
						'default_value' => '',
					),
				),
			),
		);

		$gradient_color_2 = array(
			'field_type' => 'color',
			'name'       => 'gradient_color_2',
			'title'      => esc_html__( 'Gradient Color 2', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Gradient Style', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-image--hover-gradient' => '--qi-gradient-color-2: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'image_hover' => array(
						'values'        => 'gradient',
						'default_value' => '',
					),
				),
			),
		);

		$gradient_color_3 = array(
			'field_type' => 'color',
			'name'       => 'gradient_color_3',
			'title'      => esc_html__( 'Gradient Color 3', 'qi-addons-for-elementor-premium' ),
			'group'      => esc_html__( 'Gradient Style', 'qi-addons-for-elementor-premium' ),
			'selectors'  => array(
				'{{WRAPPER}} .qodef-image--hover-gradient' => '--qi-gradient-color-3: {{VALUE}};',
			),
			'dependency' => array(
				'show' => array(
					'image_hover' => array(
						'values'        => 'gradient',
						'default_value' => '',
					),
				),
			),
		);

		$extra_options[] = $gradient_color_1;
		$extra_options[] = $gradient_color_2;
		$extra_options[] = $gradient_color_3;

		return array_merge( $options, $extra_options );
	}

	add_filter( 'qi_addons_for_elementor_filter_image_slider_extra_options', 'qi_addons_for_elementor_premium_image_slider_extra_options' );
}

if ( ! function_exists( 'qi_addons_for_elementor_premium_additional_image_slider_scripts' ) ) {
	/**
	 * Function that register modules 3rd party scripts
	 *
	 * @param array $scripts
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_additional_image_slider_scripts( $scripts ) {

		$scripts['tilt'] = array(
			'registered' => false,
			'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/gsap.min.js',
			'dependency' => array( 'jquery' ),
		);

		return $scripts;
	}

	add_filter( 'qi_addons_for_elementor_filter_image_slider_register_scripts', 'qi_addons_for_elementor_premium_additional_image_slider_scripts' );
}
