<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_interactive_info_images_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param $shortcodes array
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_interactive_info_images_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Interactive_Info_Images_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_interactive_info_images_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Slider_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Interactive_Info_Images_Shortcode extends QiAddonsForElementor_Slider_Shortcode {

		public function __construct() {

			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_interactive_info_images_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/interactive-info-images' );
			$this->set_base( 'qi_addons_for_elementor_premium_interactive_info_images' );
			$this->set_name( esc_html__( 'Interactive Info Images', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that adds interactive info images element', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Showcase', 'qi-addons-for-elementor-premium' ) );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#interactive_info_images' );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/interactive-info-images/' );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'active_item_position',
					'title'       => esc_html__( 'Active Item Position', 'qi-addons-for-elementor-premium' ),
					'description' => esc_html__( 'Input the number corresponding to the position of the item you wish to be opened initially. ', 'qi-addons-for-elementor-premium' ),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Child elements', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_image' => $placeholder,
							'item_title' => esc_html__( 'Item Title 1', 'qi-addons-for-elementor-premium' ),
							'item_link'  => array(
								'url' => '#',
							),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_title',
							'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'title' ),
						),
						array(
							'field_type'    => 'textarea',
							'name'          => 'item_text',
							'title'         => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
						),
						array(
							'field_type' => 'html',
							'name'       => 'item_custom_content',
							'title'      => esc_html__( 'Custom Content', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_button_text',
							'title'         => esc_html__( 'Button Text', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'View more', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'image_border_radius',
					'title'      => esc_html__( 'Image Border Radius', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Image Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-content .qodef-e-title',
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content .qodef-e-text' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-content .qodef-e-text',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'alignment',
					'title'      => esc_html__( 'Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons_flex', false ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content .qodef-m-content-inner' => 'align-items: {{VALUE}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'choose',
					'name'       => 'vertical_alignment',
					'title'      => esc_html__( 'Vertical Alignment', 'qi-addons-for-elementor-premium' ),
					'options'    => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons_flex_vertical', false ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content .qodef-m-content-inner' => 'justify-content: {{VALUE}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'content_padding',
					'title'      => esc_html__( 'Content Padding', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content .qodef-m-content-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => - 100,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content .qodef-e-text' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'button_margin_top',
					'title'      => esc_html__( 'Button Margin Top', 'qi-addons-for-elementor-premium' ),
					'group'      => esc_html__( 'Content Style', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'range'      => array(
						'px' => array(
							'min' => - 100,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-content .qodef-qi-button' => 'margin-top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class', 'button_text', 'button_link' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/interactive-info-images', 'templates/holder', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-interactive-info-images';

			return implode( ' ', $holder_classes );
		}

		public function generate_button_params( $atts, $item_params ) {
			if ( $item_params['item_link']['url'] ) {
				$atts['button_link'] = $item_params['item_link'];
				$atts['button_text'] = ! empty( $item_params['item_button_text'] ) ? esc_html( $item_params['item_button_text'] ) : esc_html__( 'Read More', 'qi-addons-for-elementor-premium' );

				$button_params = $this->populate_imported_shortcode_atts(
					array(
						'shortcode_base' => 'qi_addons_for_elementor_button',
						'exclude'        => array( 'custom_class' ),
						'atts'           => $atts,
					)
				);

				return $button_params;
			}

			return array();
		}
	}
}
