<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_interactive_project_carousel_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_interactive_project_carousel_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Interactive_Project_Carousel_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_interactive_project_carousel_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Slider_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Interactive_Project_Carousel_Shortcode extends QiAddonsForElementor_Slider_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_interactive_project_carousel_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/interactive-project-carousel' );
			$this->set_base( 'qi_addons_for_elementor_premium_interactive_project_carousel' );
			$this->set_name( esc_html__( 'Interactive Project Carousel', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays interactive project carousel holder', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/interactive-project-carousel/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#interactive_project_carousel' );
			$this->set_video( 'https://www.youtube.com/watch?v=BnEdmL30Twk' );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'slider',
					'name'          => 'row_number',
					'title'         => esc_html__( 'Number of Rows', 'qi-addons-for-elementor-premium' ),
					'range'         => array(
						'px' => array(
							'min' => 1,
							'max' => 7,
						),
					),
					'default_value' => array(
						'size' => 1,
						'unit' => 'px',
					),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Child elements', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_title'    => esc_html__( 'Example Title 1', 'qi-addons-for-elementor-premium' ),
							'item_subtitle' => esc_html__( 'Example Subtitle 1', 'qi-addons-for-elementor-premium' ),
							'item_image'    => $placeholder,
						),
						array(
							'item_title'    => esc_html__( 'Example Title 2', 'qi-addons-for-elementor-premium' ),
							'item_subtitle' => esc_html__( 'Example Subtitle 2', 'qi-addons-for-elementor-premium' ),
							'item_image'    => $placeholder,
						),
						array(
							'item_title'    => esc_html__( 'Example Title 3', 'qi-addons-for-elementor-premium' ),
							'item_subtitle' => esc_html__( 'Example Subtitle 3', 'qi-addons-for-elementor-premium' ),
							'item_image'    => $placeholder,
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'text',
							'name'          => 'item_title',
							'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Example Title', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_subtitle',
							'title'         => esc_html__( 'Subtitle', 'qi-addons-for-elementor-premium' ),
							'default_value' => esc_html__( 'Example Subtitle', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Link', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'item_image_max_width',
							'title'      => esc_html__( 'Image Maximum Width', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', 'vw', '%' ),
							'range'      => array(
								'px' => array(
									'min' => 0,
									'max' => 1000,
								),
							),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}}.qodef-e-media-image' => 'max-width: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'item_image_vertical_offset',
							'title'      => esc_html__( 'Image Vertical Offset', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%' ),
							'range'      => array(
								'px' => array(
									'min' => - 1000,
									'max' => 1000,
								),
								'%'  => array(
									'min' => - 100,
									'max' => 100,
								),
							),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} .qodef-vertical--top {{CURRENT_ITEM}}.qodef-e-media-image' => 'top: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .qodef-vertical--middle {{CURRENT_ITEM}}.qodef-e-media-image' => 'top: calc(50% + {{SIZE}}{{UNIT}});',
								'{{WRAPPER}} .qodef-vertical--bottom {{CURRENT_ITEM}}.qodef-e-media-image' => 'bottom: {{SIZE}}{{UNIT}};',
							),
						),
						array(
							'field_type' => 'slider',
							'name'       => 'item_image_horizontal_offset',
							'title'      => esc_html__( 'Image Horizontal Offset', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%' ),
							'range'      => array(
								'px' => array(
									'min' => - 1000,
									'max' => 1000,
								),
								'%'  => array(
									'min' => - 100,
									'max' => 100,
								),
							),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} .qodef-horizontal--left {{CURRENT_ITEM}}.qodef-e-media-image' => 'left: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .qodef-horizontal--center {{CURRENT_ITEM}}.qodef-e-media-image' => 'left: calc(50% + {{SIZE}}{{UNIT}});',
								'{{WRAPPER}} .qodef-horizontal--right {{CURRENT_ITEM}}.qodef-e-media-image' => 'right: {{SIZE}}{{UNIT}};',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'image_animation',
					'title'         => esc_html__( 'Image Animation', 'qi-addons-for-elementor-premium' ),
					'options' => array(
						'fade'  => esc_html__( 'Fade', 'qi-addons-for-elementor-premium' ),
						'fade-from-bottom'   => esc_html__( 'Fade From Bottom', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'fade',
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'min_height',
					'title'      => esc_html__( 'Minimal Height', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'vh' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 2000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-interactive-project-carousel' => 'min-height: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color',
					'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-qi-interactive-project-carousel' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'border_between_rows',
					'title'         => esc_html__( 'Enable Border Between Rows', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'align_items',
					'title'      => esc_html__( 'Align Items', 'qi-addons-for-elementor-premium' ),
					'options'    => array(
						'flex-start' => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
						'center'     => esc_html__( 'Center', 'qi-addons-for-elementor-premium' ),
						'flex-end'   => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
						'baseline'   => esc_html__( 'Baseline', 'qi-addons-for-elementor-premium' ),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item' => 'align-items: {{VALUE}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'images_max_width',
					'title'      => esc_html__( 'Images Maximum Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'vw', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-media-image' => 'max-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'images_vertical_position',
					'title'         => esc_html__( 'Images Vertical Position', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'top'    => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
						'middle' => esc_html__( 'Middle', 'qi-addons-for-elementor-premium' ),
						'bottom' => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'middle',
					'group'         => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'images_horizontal_position',
					'title'         => esc_html__( 'Images Horizontal Position', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'left'   => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
						'center' => esc_html__( 'Center', 'qi-addons-for-elementor-premium' ),
						'right'  => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'right',
					'group'         => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'images_vertical_offset',
					'title'      => esc_html__( 'Images Vertical Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => - 1000,
							'max' => 1000,
						),
						'%'  => array(
							'min' => - 100,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-vertical--top .qodef-e-media-image' => 'top: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-vertical--middle .qodef-e-media-image' => 'top: calc(50% + {{SIZE}}{{UNIT}});',
						'{{WRAPPER}} .qodef-vertical--bottom .qodef-e-media-image' => 'bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'images_horizontal_offset',
					'title'      => esc_html__( 'Images Horizontal Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => - 1000,
							'max' => 1000,
						),
						'%'  => array(
							'min' => - 100,
							'max' => 100,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-horizontal--left .qodef-e-media-image' => 'left: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-horizontal--center .qodef-e-media-image' => 'left: calc(50% + {{SIZE}}{{UNIT}});',
						'{{WRAPPER}} .qodef-horizontal--right .qodef-e-media-image' => 'right: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Item Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h3',
					'group'         => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_active_color',
					'title'      => esc_html__( 'Title Active/Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item.qodef--hovered .qodef-e-title' => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-e-item.qodef--active .qodef-e-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-title',
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item .qodef-e-subtitle' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'dimensions',
					'name'       => 'subtitle_margin',
					'title'      => esc_html__( 'Subtitle Margin', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'vw' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item .qodef-e-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'subtitle_vertical_position',
					'title'         => esc_html__( 'Subtitle Vertical Position', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'flex-start' => esc_html__( 'Top', 'qi-addons-for-elementor-premium' ),
						'center'     => esc_html__( 'Middle', 'qi-addons-for-elementor-premium' ),
						'flex-end'   => esc_html__( 'Bottom', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'middle',
					'selectors'     => array(
						'{{WRAPPER}} .qodef-e-item .qodef-e-subtitle' => 'align-self: {{VALUE}};',
					),
					'group'         => esc_html__( 'Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_active_color',
					'title'      => esc_html__( 'Subtitle Active/Hover Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item.qodef--hovered .qodef-e-subtitle' => 'color: {{VALUE}};',
						'{{WRAPPER}} .qodef-e-item.qodef--active .qodef-e-subtitle' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'subtitle_typography',
					'title'      => esc_html__( 'Subtitle Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-subtitle',
					'group'      => esc_html__( 'Subtitle Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_items',
					'title'      => esc_html__( 'Space Between Items', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 200,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-item' => 'padding: 0 {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-m-swiper-holder' => 'width: calc(100% + 2*{{SIZE}}{{UNIT}});',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_rows',
					'title'      => esc_html__( 'Space Between Rows', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', 'em', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 200,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .swiper-container' => 'padding: {{SIZE}}{{UNIT}} 0;',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'border_width',
					'title'      => esc_html__( 'Border Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( '%' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-borders--yes.qodef-qi-interactive-project-carousel .swiper-container:before' => 'left: calc((100% - {{SIZE}}%)/2 + {{space_between_items.size}}{{space_between_items.unit}}); right: calc((100% - {{SIZE}}%)/2 + {{space_between_items.size}}{{space_between_items.unit}});',
					),
					'dependency' => array(
						'show' => array(
							'border_between_rows' => array(
								'values'        => 'yes',
								'default_value' => 'yes',
							),
						),
					),
					'group'      => esc_html__( 'Border Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'border_color',
					'title'      => esc_html__( 'Border Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-borders--yes.qodef-qi-interactive-project-carousel .swiper-container:before' => 'background-color: {{VALUE}};',
					),
					'dependency' => array(
						'show' => array(
							'border_between_rows' => array(
								'values'        => 'yes',
								'default_value' => 'yes',
							),
						),
					),
					'group'      => esc_html__( 'Border Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'border_thickness',
					'title'      => esc_html__( 'Border Thickness', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-borders--yes.qodef-qi-interactive-project-carousel .swiper-container:before' => 'height: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'border_between_rows' => array(
								'values'        => 'yes',
								'default_value' => 'yes',
							),
						),
					),
					'group'      => esc_html__( 'Border Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'border_offset',
					'title'      => esc_html__( 'Border Vertical Offset', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => -100,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-borders--yes.qodef-qi-interactive-project-carousel .swiper-container:before' => 'top: {{SIZE}}{{UNIT}};',
					),
					'dependency' => array(
						'show' => array(
							'border_between_rows' => array(
								'values'        => 'yes',
								'default_value' => 'yes',
							),
						),
					),
					'group'      => esc_html__( 'Border Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['items_per_row']  = $this->get_items_per_row( $atts );
			$atts['slider_attr']    = $this->get_item_slider_data( $atts );
			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/interactive-project-carousel', 'templates/interactive-project-carousel', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-interactive-project-carousel';
			$holder_classes[] = ! empty( $atts['images_vertical_position'] ) ? 'qodef-vertical--' . $atts['images_vertical_position'] : '';
			$holder_classes[] = ! empty( $atts['images_horizontal_position'] ) ? 'qodef-horizontal--' . $atts['images_horizontal_position'] : '';
			$holder_classes[] = ! empty( $atts['border_between_rows'] ) ? 'qodef-borders--' . $atts['border_between_rows'] : '';
			$holder_classes[] = ! empty( $atts['image_animation'] ) ? 'qodef-qi--image-animation-' . $atts['image_animation'] : '';

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$item_classes[] = 'swiper-slide';
			$item_classes[] = 'qodef-e-item';

			return implode( ' ', $item_classes );
		}

		private function get_item_slider_data( $atts ) {
			$atts['slider_loop']       = 'no';
			$atts['slider_pagination'] = 'no';
			$atts['slider_navigation'] = 'no';

			return $this->get_slider_data( $atts );
		}

		public function get_items_per_row( $atts ) {
			$items_per_row = array();
			$rows          = isset( $atts['row_number']['size'] ) && ! empty( $atts['row_number']['size'] ) ? $atts['row_number']['size'] : 1;
			$items_count   = count( $atts['items'] );
			$base          = intval( floor( $items_count / $rows ) );
			$rest          = $items_count % $rows;

			if ( 0 === $base ) {
				return array( $items_count );
			}

			for ( $i = $rows - 1; $i >= 0; $i-- ) {
				$items_per_row[ $i ] = $base;
				if ( $i >= $rest && 0 !== $rest ) {
					$items_per_row[ $i ] += 1;
					$rest--;
				}
			}

			ksort( $items_per_row );

			return $items_per_row;
		}
	}
}
