<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_intro_glitch_effect_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_intro_glitch_effect_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Intro_Glitch_Effect_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_intro_glitch_effect_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Intro_Glitch_Effect_Shortcode extends QiAddonsForElementor_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_intro_glitch_effect_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/intro-glitch-effect' );
			$this->set_base( 'qi_addons_for_elementor_premium_intro_glitch_effect' );
			$this->set_name( esc_html__( 'Intro Glitch Effect', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays intro glitch effect', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/intro-glitch-effect/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#intro_glitch_effect' );
			$this->set_necessary_styles( qi_addons_for_elementor_icon_necessary_styles() );
			$this->set_option(
				array(
					'field_type' => 'note',
					'name'       => 'warning',
					'title'      => esc_html__( 'Please note that this shortcode should be used only in first section on a page', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'headline_type',
					'title'         => esc_html__( 'Headline Type', 'qi-addons-for-elementor-premium' ),
					'options'       => array(
						'text'  => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
						'image' => esc_html__( 'Image', 'qi-addons-for-elementor-premium' ),
					),
					'default_value' => 'text',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'headline',
					'title'         => esc_html__( 'Headline Text', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Headline', 'qi-addons-for-elementor-premium' ),
					'dependency'    => array(
						'show' => array(
							'headline_type' => array(
								'values'        => 'text',
								'default_value' => 'text',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'headline_image',
					'title'      => esc_html__( 'Headline Image', 'qi-addons-for-elementor-premium' ),
					'dependency' => array(
						'show' => array(
							'headline_type' => array(
								'values'        => 'image',
								'default_value' => 'text',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'bottom_image',
					'title'      => esc_html__( 'Bottom Image', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'This is example title', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'text',
					'title'         => esc_html__( 'Text', 'qi-addons-for-elementor-premium' ),
					'default_value' => qi_addons_for_elementor_get_example_text( 'excerpt_short' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color',
					'title'      => esc_html__( 'Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-screen-1'                                                   => 'background-color: {{VALUE}};',
						'.qodef-qi--no-touch {{WRAPPER}} .qodef-m-headline.qodef-m-headline-bottom:after' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'second_background_color',
					'title'      => esc_html__( 'Second Background Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-screen-2'             => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .qodef-qi-intro-glitch-effect' => 'background-color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'headline_image_width',
					'title'      => esc_html__( 'Headline Image Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'vw' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-screen-1 .qodef-m-screen-inner' => 'max-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'content_width',
					'title'      => esc_html__( 'Content Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'vw' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1000,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-screen-2 .qodef-m-screen-inner' => 'max-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'choose',
					'name'          => 'content_alignment',
					'title'         => esc_html__( 'Content Alignment', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'alignment_icons', false ),
					'default_value' => 'center',
					'responsive'    => true,
					'selectors'     => array(
						'{{WRAPPER}} .qodef-m-screen-2 .qodef-m-screen-inner' => 'text-align: {{VALUE}};',
					),
					'group'         => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'headline_title_tag',
					'title'         => esc_html__( 'Headline Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Headline Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'headline_color',
					'title'      => esc_html__( 'Headline Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-headline-holder' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Headline Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'headline_typography',
					'title'      => esc_html__( 'Headline Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-headline-holder',
					'group'      => esc_html__( 'Headline Style', 'qi-addons-for-elementor-premium' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'title_typography',
					'title'      => esc_html__( 'Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-title',
					'group'      => esc_html__( 'Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'title_margin_bottom',
					'title'      => esc_html__( 'Title Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-screen-inner > .qodef-m-text' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'text_typography',
					'title'      => esc_html__( 'Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-screen-inner > .qodef-m-text',
					'group'      => esc_html__( 'Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'text_margin_bottom',
					'title'      => esc_html__( 'Text Margin Bottom', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%', 'em' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-screen-inner > .qodef-m-text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Spacing Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'qi_addons_for_elementor_button',
					'exclude'           => array( 'custom_class' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'qi-addons-for-elementor-premium' ),
					),
				)
			);

			$this->map_extra_options();
		}

		public function load_assets() {
			parent::load_assets();
			qi_addons_for_elementor_icon_load_assets();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['button_params']  = $this->generate_button_params( $atts );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/intro-glitch-effect', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-intro-glitch-effect';

			return implode( ' ', $holder_classes );
		}

		private function generate_button_params( $atts ) {

			return $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'qi_addons_for_elementor_button',
					'exclude'        => array( 'custom_class' ),
					'atts'           => $atts,
				)
			);
		}
	}
}
