<?php

if ( ! function_exists( 'qi_addons_for_elementor_premium_add_intro_write_out_floating_images_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function qi_addons_for_elementor_premium_add_intro_write_out_floating_images_shortcode( $shortcodes ) {
		$shortcodes[] = 'QiAddonsForElementorPremium_Intro_Write_Out_Floating_Images_Shortcode';

		return $shortcodes;
	}

	add_filter( 'qi_addons_for_elementor_filter_register_shortcodes', 'qi_addons_for_elementor_premium_add_intro_write_out_floating_images_shortcode' );
}

if ( class_exists( 'QiAddonsForElementor_Shortcode' ) ) {
	class QiAddonsForElementorPremium_Intro_Write_Out_Floating_Images_Shortcode extends QiAddonsForElementor_List_Shortcode {

		public function __construct() {
			$this->set_extra_options( apply_filters( 'qi_addons_for_elementor_premium_filter_intro_write_out_floating_images_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( QI_ADDONS_FOR_ELEMENTOR_PREMIUM_SHORTCODES_URL_PATH . '/intro-write-out-floating-images' );
			$this->set_base( 'qi_addons_for_elementor_premium_intro_write_out_floating_images' );
			$this->set_name( esc_html__( 'Intro Scrolling Images', 'qi-addons-for-elementor-premium' ) );
			$this->set_description( esc_html__( 'Shortcode that displays intro write out floating images', 'qi-addons-for-elementor-premium' ) );
			$this->set_category( esc_html__( 'Qi Addons For Elementor Premium', 'qi-addons-for-elementor-premium' ) );
			$this->set_subcategory( esc_html__( 'Creative', 'qi-addons-for-elementor-premium' ) );
			$this->set_demo( 'https://qodeinteractive.com/qi-addons-for-elementor/intro-scrolling-images/' );
			$this->set_documentation( 'https://qodeinteractive.com/qi-addons-for-elementor/documentation/#intro_scrolling_images' );
			$this->set_scripts(
				array(
					'gsap'           => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/gsap.min.js',
						'dependency' => array( 'jquery' ),
					),
					'scroll-trigger' => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/ScrollTrigger.min.js',
						'dependency' => array( 'jquery' ),
					),
					'scroll-to'      => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/ScrollToPlugin.min.js',
						'dependency' => array( 'jquery' ),
					),
					'split-text'     => array(
						'registered' => false,
						'url'        => QI_ADDONS_FOR_ELEMENTOR_PREMIUM_ASSETS_URL_PATH . '/plugins/gsap/SplitText.min.js',
						'dependency' => array( 'jquery' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'overlay_title',
					'title'         => esc_html__( 'Overlay Title', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Title', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'overlay_image_1',
					'title'      => esc_html__( 'Overlay Image Back', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'overlay_image_2',
					'title'      => esc_html__( 'Overlay Image Front', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'top_text',
					'title'         => esc_html__( 'Top Text', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Welcome', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'right_text',
					'title'         => esc_html__( 'Right Text', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Example Text Right', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'bottom_text',
					'title'         => esc_html__( 'Bottom Text', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Just Scroll', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'left_text',
					'title'         => esc_html__( 'Left Text', 'qi-addons-for-elementor-premium' ),
					'default_value' => esc_html__( 'Example Text Left', 'qi-addons-for-elementor-premium' ),
				)
			);

			$placeholder = get_option( 'qi_addons_for_elementor_placeholder_image' );

			$this->set_option(
				array(
					'field_type'    => 'repeater',
					'name'          => 'children',
					'title'         => esc_html__( 'Items', 'qi-addons-for-elementor-premium' ),
					'default_value' => array(
						array(
							'item_image' => $placeholder,
							'item_link'  => array(),
						),
					),
					'items'         => array(
						array(
							'field_type'    => 'image',
							'name'          => 'item_image',
							'title'         => esc_html__( 'Item Image', 'qi-addons-for-elementor-premium' ),
							'default_value' => $placeholder,
						),
						array(
							'field_type' => 'link',
							'name'       => 'item_link',
							'title'      => esc_html__( 'Item Link', 'qi-addons-for-elementor-premium' ),
						),
						array(
							'field_type' => 'select',
							'name'       => 'item_alignment',
							'title'      => esc_html__( 'Image Alignment', 'qi-addons-for-elementor-premium' ),
							'options'    => array(
								''       => esc_html__( 'Default', 'qi-addons-for-elementor-premium' ),
								'left'   => esc_html__( 'Left', 'qi-addons-for-elementor-premium' ),
								'center' => esc_html__( 'Center', 'qi-addons-for-elementor-premium' ),
								'right'  => esc_html__( 'Right', 'qi-addons-for-elementor-premium' ),
							),
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}}' => 'text-align: {{VALUE}}',
							),
						),
						array(
							'field_type' => 'dimensions',
							'name'       => 'item_padding',
							'title'      => esc_html__( 'Item Padding', 'qi-addons-for-elementor-premium' ),
							'size_units' => array( 'px', '%', 'em' ),
							'responsive' => true,
							'selectors'  => array(
								'{{WRAPPER}} {{CURRENT_ITEM}} .qodef-e-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'items_holder_width',
					'title'      => esc_html__( 'Items Holder Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 2500,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-holder-inner' => 'width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'items_top_bottom_space',
					'title'      => esc_html__( 'Items Holder Top/Bottom Space', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 400,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-holder-inner .qodef-grid-inner' => 'padding: {{SIZE}}{{UNIT}} 0;',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_items_horizontal',
					'title'      => esc_html__( 'Space Between Items Horizontal', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 30,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} article.qodef-grid-item .qodef-e-inner' => 'width: calc((100% - {{SIZE}}%)/2);',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'space_between_items_vertical',
					'title'      => esc_html__( 'Space Between Items Vertical', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} article.qodef-grid-item' => 'padding: calc({{SIZE}}{{UNIT}}/2) 0;',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'overlay_image_back_width',
					'title'      => esc_html__( 'Overlay Image Back Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1500,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-image-overlay-holder.qodef-image-1' => 'max-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'overlay_image_front_width',
					'title'      => esc_html__( 'Overlay Image Front Width', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1500,
						),
					),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-image-overlay-holder.qodef-image-2' => 'max-width: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'overlay_title_tag',
					'title'         => esc_html__( 'Overlay Title Tag', 'qi-addons-for-elementor-premium' ),
					'options'       => qi_addons_for_elementor_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h1',
					'group'         => esc_html__( 'Overlay Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'overlay_title_color',
					'title'      => esc_html__( 'Overlay Title Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-m-overlay-title' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Overlay Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'overlay_title_typography',
					'title'      => esc_html__( 'Overlay Title Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-m-overlay-title',
					'group'      => esc_html__( 'Overlay Title Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'additional_text_color',
					'title'      => esc_html__( 'Additional Text Color', 'qi-addons-for-elementor-premium' ),
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-additional' => 'color: {{VALUE}};',
					),
					'group'      => esc_html__( 'Additional Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'typography',
					'name'       => 'additional_text_typography',
					'title'      => esc_html__( 'Additional Text Typography', 'qi-addons-for-elementor-premium' ),
					'selector'   => '{{WRAPPER}} .qodef-e-additional',
					'group'      => esc_html__( 'Additional Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'slider',
					'name'       => 'additional_text_offset',
					'title'      => esc_html__( 'Additional Text Offset from Edges', 'qi-addons-for-elementor-premium' ),
					'size_units' => array( 'px', '%' ),
					'responsive' => true,
					'selectors'  => array(
						'{{WRAPPER}} .qodef-e-additional.qodef--top' => 'top: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-e-additional.qodef--right' => 'right: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-e-additional.qodef--bottom' => 'bottom: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .qodef-e-additional.qodef--left' => 'left: {{SIZE}}{{UNIT}};',
					),
					'group'      => esc_html__( 'Additional Text Style', 'qi-addons-for-elementor-premium' ),
				)
			);

			$this->map_extra_options();
		}

		public function load_assets() {
			wp_enqueue_script( 'gsap' );
			wp_enqueue_script( 'scroll-trigger' );
			wp_enqueue_script( 'scroll-to' );
			wp_enqueue_script( 'split-text' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['behavior'] = 'columns';
			$atts['columns']  = 1;

			$atts['additional']           = array( 'top', 'right', 'bottom', 'left' );
			$atts['holder_classes']       = $this->get_holder_classes( $atts );
			$atts['holder_inner_classes'] = $this->get_holder_inner_classes( $atts );
			$atts['item_classes']         = $this->get_item_classes( $atts );
			$atts['items']                = $this->parse_repeater_items( $atts['children'] );

			$atts['this_shortcode'] = $this;

			return qi_addons_for_elementor_premium_get_template_part( 'shortcodes/intro-write-out-floating-images', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-qi-intro-write-out-floating-images';

			return implode( ' ', $holder_classes );
		}

		private function get_holder_inner_classes( $atts ) {

			$holder_classes = array( 'qodef-holder-inner' );

			$list_classes   = $this->get_list_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $list_classes );

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes      = $this->init_item_classes();
			$list_item_classes = $this->get_list_item_classes( $atts );
			$item_classes      = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}
	}
}
